/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.tags;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.ConditionalDataProvider;
import gg.moonflower.pollen.api.resource.condition.ConditionalTagEntry;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.extensions.TagBuilderExtension;
import gg.moonflower.pollen.core.mixin.data.TagsProviderAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;

public abstract class PollinatedTagsProvider<T>
extends TagsProvider<T>
implements ConditionalDataProvider {
    private final Map<ResourceLocation, List<PollinatedResourceConditionProvider>> providers = new HashMap<ResourceLocation, List<PollinatedResourceConditionProvider>>();
    private final String domain;

    public PollinatedTagsProvider(DataGenerator generator, PollinatedModContainer container, Registry<T> registry) {
        super(generator, registry);
        this.domain = container.getId();
    }

    public void addConditions(TagKey<T> tag, PollinatedResourceConditionProvider ... providers) {
        this.addConditions(tag.f_203868_(), providers);
    }

    @Override
    public void addConditions(ResourceLocation id, PollinatedResourceConditionProvider ... providers) {
        if (providers.length == 0) {
            return;
        }
        this.providers.computeIfAbsent(id, __ -> new ArrayList()).addAll(Arrays.asList(providers));
    }

    @Override
    public void injectConditions(ResourceLocation id, JsonObject json) {
        if (this.providers.containsKey(id)) {
            PollinatedResourceConditionProvider.write(json, this.providers.get(id).toArray(new PollinatedResourceConditionProvider[0]));
        }
    }

    protected PollinatedTagAppender<T> tag(TagKey<T> tag) {
        return new PollinatedTagAppender(this.m_206426_(tag), this.f_126540_, this.domain);
    }

    protected Tag.Builder m_206426_(TagKey<T> tag) {
        return ((TagsProviderAccessor)((Object)this)).getBuilders().computeIfAbsent(tag.f_203868_(), __ -> new Tag.Builder());
    }

    public static class PollinatedTagAppender<T>
    extends TagsProvider.TagAppender<T> {
        private final Tag.Builder builder;
        private final Registry<T> registry;
        private final String source;

        protected PollinatedTagAppender(Tag.Builder builder, Registry<T> registry, String source) {
            super(builder, registry, source);
            this.builder = builder;
            this.registry = registry;
            this.source = source;
        }

        public PollinatedTagAppender<T> add(T item) {
            return (PollinatedTagAppender)super.m_126582_(item);
        }

        public PollinatedTagAppender<T> addTag(TagKey<T> tag) {
            return (PollinatedTagAppender)super.m_206428_(tag);
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> pollenAdd(T ... toAdd) {
            return (PollinatedTagAppender)super.m_126584_((Object[])toAdd);
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> addTag(TagKey<T> ... values) {
            for (TagKey<T> value : values) {
                this.addTag(value);
            }
            return this;
        }

        public PollinatedTagAppender<T> addOptional(ResourceLocation resourceLocation) {
            return (PollinatedTagAppender)super.m_176839_(resourceLocation);
        }

        public PollinatedTagAppender<T> addOptionalTag(ResourceLocation resourceLocation) {
            return (PollinatedTagAppender)super.m_176841_(resourceLocation);
        }

        public PollinatedTagAppender<T> replace() {
            return this.replace(true);
        }

        public PollinatedTagAppender<T> replace(boolean value) {
            ((TagBuilderExtension)this.builder).pollen_replace(value);
            return this;
        }

        private static JsonObject createConditionJson(PollinatedResourceConditionProvider[] conditions) {
            JsonObject json = new JsonObject();
            PollinatedResourceConditionProvider.write(json, conditions);
            return json;
        }

        public PollinatedTagAppender<T> addConditional(T item, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.add(item);
            }
            this.builder.m_13307_((Tag.Entry)new ConditionalTagEntry((Tag.Entry)new Tag.ElementEntry(this.registry.m_7981_(item)), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalTag(TagKey<T> tag, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addTag(tag);
            }
            this.builder.m_13307_((Tag.Entry)new ConditionalTagEntry((Tag.Entry)new Tag.TagEntry(tag.f_203868_()), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalOptional(ResourceLocation item, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addOptional(item);
            }
            this.builder.m_13307_((Tag.Entry)new ConditionalTagEntry((Tag.Entry)new Tag.OptionalElementEntry(item), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalOptionalTag(ResourceLocation tag, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addOptionalTag(tag);
            }
            this.builder.m_13307_((Tag.Entry)new ConditionalTagEntry((Tag.Entry)new Tag.OptionalTagEntry(tag), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }
    }
}

