/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.fluid;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface PollenFluidBehavior {
    default public boolean canDescend(Player player) {
        return true;
    }

    default public boolean canAscend(LivingEntity entity) {
        return true;
    }

    default public boolean canSprint(Player player) {
        return true;
    }

    default public boolean shouldEntityDrown(LivingEntity entity) {
        return !entity.f_19853_.m_8055_(entity.m_142538_()).m_60713_(Blocks.f_50628_);
    }

    default public boolean canVehicleTraverse(LivingEntity entity, Entity vehicle) {
        return vehicle.m_6146_();
    }

    @Nullable
    default public ParticleOptions getDrowningParticles(LivingEntity entity) {
        return ParticleTypes.f_123795_;
    }

    default public float getDrowningDamage(LivingEntity entity) {
        return 2.0f;
    }

    default public boolean negatesFallDamage(Entity entity) {
        return true;
    }

    default public boolean canExtinguishFire(Entity entity) {
        return true;
    }

    default public double getMotionScale(Entity entity) {
        return 0.014;
    }

    default public double getSlowDown(LivingEntity entity) {
        return entity.m_20142_() ? 0.9 : 0.8;
    }

    @Nullable
    default public SoundEvent getAmbientEnter(Player player) {
        return SoundEvents.f_12537_;
    }

    @Nullable
    default public SoundEvent getAmbientLoop(Player player) {
        return SoundEvents.f_12643_;
    }

    @Nullable
    default public SoundEvent getAmbientExit(Player player) {
        return SoundEvents.f_12590_;
    }

    default public void applyPhysics(LivingEntity entity, Vec3 travelVector, double fallSpeed, boolean falling) {
        double e = entity.m_20186_();
        double f = this.getSlowDown(entity);
        float g = 0.02f;
        float h = EnchantmentHelper.m_44922_((LivingEntity)entity);
        if (h > 3.0f) {
            h = 3.0f;
        }
        if (!entity.m_20096_()) {
            h *= 0.5f;
        }
        if (h > 0.0f) {
            f += (0.546000063419342 - f) * (double)h / 3.0;
            g += (entity.m_6113_() - g) * h / 3.0f;
        }
        if (entity.m_21023_(MobEffects.f_19593_)) {
            f = 0.96f;
        }
        entity.m_19920_(g, travelVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        Vec3 vec3 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_6147_()) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        entity.m_20256_(vec3.m_82542_(f, (double)0.8f, f));
        Vec3 vec32 = entity.m_20994_(fallSpeed, falling, entity.m_20184_());
        entity.m_20256_(vec32);
        if (entity.f_19862_ && entity.m_20229_(vec32.f_82479_, vec32.f_82480_ + (double)0.6f - entity.m_20186_() + e, vec32.f_82481_)) {
            entity.m_20334_(vec32.f_82479_, (double)0.3f, vec32.f_82481_);
        }
    }

    default public void doSplashEffect(Entity entity, Random random) {
        double e;
        double d;
        Entity vehicle = entity.m_20160_() && entity.m_6688_() != null ? entity.m_6688_() : entity;
        float f = vehicle == entity ? 0.2f : 0.9f;
        Vec3 vec3 = vehicle.m_20184_();
        float g = Mth.m_14116_((float)((float)(vec3.f_82479_ * vec3.f_82479_ * (double)0.2f + vec3.f_82480_ * vec3.f_82480_ + vec3.f_82481_ * vec3.f_82481_ * (double)0.2f))) * f;
        if (g > 1.0f) {
            g = 1.0f;
        }
        if ((double)g < 0.25) {
            entity.m_5496_(entity.m_5509_(), g, 1.0f + (random.nextFloat() - random.nextFloat()) * 0.4f);
        } else {
            entity.m_5496_(entity.m_5508_(), g, 1.0f + (random.nextFloat() - random.nextFloat()) * 0.4f);
        }
        float h = Mth.m_14107_((double)entity.m_20186_());
        int i = 0;
        while ((float)i < 1.0f + entity.m_20205_() * 20.0f) {
            d = (random.nextDouble() * 2.0 - 1.0) * (double)entity.m_20205_();
            e = (random.nextDouble() * 2.0 - 1.0) * (double)entity.m_20205_();
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_() + d, (double)(h + 1.0f), entity.m_20189_() + e, vec3.f_82479_, vec3.f_82480_ - random.nextDouble() * (double)0.2f, vec3.f_82481_);
            ++i;
        }
        i = 0;
        while ((float)i < 1.0f + entity.m_20205_() * 20.0f) {
            d = (random.nextDouble() * 2.0 - 1.0) * (double)entity.m_20205_();
            e = (random.nextDouble() * 2.0 - 1.0) * (double)entity.m_20205_();
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, entity.m_20185_() + d, (double)(h + 1.0f), entity.m_20189_() + e, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            ++i;
        }
    }
}

