/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface PollinatedFluid {
    public static final Direction[] DEFAULT_INTERACTIONS = (Direction[])Arrays.stream(Direction.values()).filter(direction -> direction != Direction.DOWN).toArray(Direction[]::new);

    public ResourceLocation getStillTextureName();

    public ResourceLocation getFlowingTextureName();

    @Nullable
    default public ResourceLocation getOverlayTextureName() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getFogColor(Camera camera, ClientLevel level, Holder<Biome> biome, float partialTicks) {
        return ((Biome)biome.m_203334_()).m_47561_();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void applyFog(GameRenderer renderer, Camera camera, float distance, float partialTicks) {
        Entity entity = camera.m_90592_();
        float g = 192.0f;
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            g *= Math.max(0.25f, localPlayer.m_108639_());
            Holder holder = localPlayer.f_19853_.m_204166_(localPlayer.m_142538_());
            if (Biome.m_204183_((Holder)holder) == Biome.BiomeCategory.SWAMP) {
                g *= 0.85f;
            }
        }
        RenderSystem.m_157445_((float)-8.0f);
        RenderSystem.m_157443_((float)(g * 0.5f));
    }

    default public Optional<SoundEvent> getEmptySound() {
        return Optional.of(SoundEvents.f_11778_);
    }

    default public Direction[] getInteractionDirections() {
        return DEFAULT_INTERACTIONS;
    }

    @Nullable
    default public BlockState getInteractionState(Level level, FluidState fluidState, BlockPos pos, BlockPos neighborPos) {
        return null;
    }

    default public void playInteractionEffect(Level level, FluidState fluidState, BlockPos pos) {
        level.m_46796_(1501, pos, 0);
    }
}

