/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.item;

import gg.moonflower.pollen.api.entity.PollinatedBoat;
import gg.moonflower.pollen.api.entity.PollinatedBoatType;
import gg.moonflower.pollen.api.item.TabFiller;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PollinatedBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private static final Map<PollinatedBoatType, Item> BOAT_ITEMS = new ConcurrentHashMap<PollinatedBoatType, Item>();
    private static final DispenseItemBehavior DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double offset;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double x = source.m_7096_() + (double)((float)direction.m_122429_() * 1.125f);
            double y = source.m_7098_() + (double)((float)direction.m_122430_() * 1.125f);
            double z = source.m_7094_() + (double)((float)direction.m_122431_() * 1.125f);
            BlockPos blockPos = source.m_7961_().m_142300_(direction);
            if (level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
                offset = 1.0;
            } else {
                if (!level.m_8055_(blockPos).m_60795_() || !level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(source, stack);
                }
                offset = 0.0;
            }
            PollinatedBoat boat = new PollinatedBoat((Level)level, x, y + offset, z);
            boat.setPollenType(((PollinatedBoatItem)stack.m_41720_()).getType().get());
            boat.m_146922_(direction.m_122435_());
            level.m_7967_((Entity)boat);
            stack.m_41774_(1);
            return stack;
        }
    };
    private final Supplier<PollinatedBoatType> type;

    public PollinatedBoatItem(Supplier<PollinatedBoatType> type, Item.Properties properties) {
        super(properties);
        this.type = type;
        BOAT_ITEMS.put(type.get(), this);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_BEHAVIOR);
    }

    @Nullable
    public static Item getBoatItem(PollinatedBoatType type) {
        return BOAT_ITEMS.get(type);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        BlockHitResult hitResult = PollinatedBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            Vec3 vec3 = player.m_20252_(1.0f);
            List list = level.m_6249_((Entity)player, player.m_142469_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
            if (!list.isEmpty()) {
                Vec3 eyePos = player.m_20299_(1.0f);
                for (Entity entity : list) {
                    AABB box = entity.m_142469_().m_82400_((double)entity.m_6143_());
                    if (!box.m_82390_(eyePos)) continue;
                    return InteractionResultHolder.m_19098_((Object)itemStack);
                }
            }
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                PollinatedBoat boat = new PollinatedBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
                boat.setPollenType(this.type.get());
                boat.m_146922_(player.m_146908_());
                if (!level.m_45756_((Entity)boat, boat.m_142469_().m_82400_(-0.1))) {
                    return InteractionResultHolder.m_19100_((Object)itemStack);
                }
                if (!level.m_5776_()) {
                    level.m_7967_((Entity)boat);
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_41389_(category)) {
            TabFiller.insert(new ItemStack((ItemLike)this), false, items, stack -> stack.m_41720_() instanceof BoatItem || stack.m_41720_() instanceof PollinatedBoatItem);
        }
    }

    public Supplier<PollinatedBoatType> getType() {
        return this.type;
    }
}

