/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.injectables.annotations.PlatformOnly;
import gg.moonflower.pollen.api.item.TabFiller;
import gg.moonflower.pollen.api.item.forge.SpawnEggItemBaseImpl;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.content.DispenseItemBehaviorRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class SpawnEggItemBase<T extends EntityType<? extends Mob>>
extends SpawnEggItem {
    private static final DispenseItemBehavior DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
            try {
                type.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
            }
            catch (Exception var6) {
                LogManager.getLogger().error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)var6);
                return ItemStack.f_41583_;
            }
            stack.m_41774_(1);
            return stack;
        }
    };
    private final boolean addToMisc;
    private final Supplier<T> type;

    public SpawnEggItemBase(Supplier<T> type, int backgroundColor, int spotColor, Item.Properties builder) {
        this(type, backgroundColor, spotColor, false, builder);
    }

    @Deprecated
    public SpawnEggItemBase(Supplier<T> type, int backgroundColor, int spotColor, boolean addToMisc, Item.Properties builder) {
        super(Platform.isForge() ? null : (EntityType)type.get(), backgroundColor, spotColor, builder);
        this.type = type;
        this.addToMisc = addToMisc;
        if (Platform.isForge()) {
            SpawnEggItemBase.registerSpawnEgg(this, type);
        }
        DispenseItemBehaviorRegistry.register((ItemLike)this, DISPENSE_BEHAVIOR);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @PlatformOnly(value={"forge"})
    @ExpectPlatform.Transformed
    public static void registerSpawnEgg(SpawnEggItem item, Supplier<? extends EntityType<?>> type) {
        void var1_1;
        SpawnEggItemBaseImpl.registerSpawnEgg(item, var1_1);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) || this.addToMisc && group == CreativeModeTab.f_40753_) {
            TabFiller.insertNamed(new ItemStack((ItemLike)this), false, items, stack -> stack.m_41720_() instanceof SpawnEggItem);
        }
    }

    public EntityType<?> m_43228_(@Nullable CompoundTag nbt) {
        CompoundTag compoundnbt;
        if (!Platform.isForge()) {
            return super.m_43228_(nbt);
        }
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (compoundnbt = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return (EntityType)EntityType.m_20632_((String)compoundnbt.m_128461_("id")).orElseGet(this.type);
        }
        return (EntityType)this.type.get();
    }
}

