/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.pollen.api.block.PollinatedStandingSignBlock;
import gg.moonflower.pollen.api.block.PollinatedWallSignBlock;
import gg.moonflower.pollen.api.item.PollinatedSignItem;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.WrapperPollinatedRegistry;
import gg.moonflower.pollen.api.registry.content.SignRegistry;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class PollinatedBlockRegistry
extends WrapperPollinatedRegistry<Block> {
    private final PollinatedRegistry<Item> itemRegistry;

    PollinatedBlockRegistry(PollinatedRegistry<Block> blockRegistry, PollinatedRegistry<Item> itemRegistry) {
        super(blockRegistry);
        this.itemRegistry = itemRegistry;
    }

    public <R extends Block> Supplier<R> registerWithItem(String id, Supplier<R> block, Item.Properties properties) {
        return this.registerWithItem(id, block, (R object) -> new BlockItem(object, properties));
    }

    public <R extends Block> Supplier<R> registerWithItem(String id, Supplier<R> block, Function<R, Item> itemFactory) {
        Supplier register = this.register(id, block);
        this.itemRegistry.register(id, () -> (Item)itemFactory.apply((Block)register.get()));
        return register;
    }

    public Pair<Supplier<PollinatedStandingSignBlock>, Supplier<PollinatedWallSignBlock>> registerSign(String id, Material material, MaterialColor color) {
        return this.registerSign(id, BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), new Item.Properties().m_41487_(16).m_41491_(CreativeModeTab.f_40750_));
    }

    public Pair<Supplier<PollinatedStandingSignBlock>, Supplier<PollinatedWallSignBlock>> registerSign(String id, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        WoodType type = SignRegistry.register(new ResourceLocation(this.modId, id));
        Supplier<PollinatedStandingSignBlock> standing = this.register(id + "_sign", () -> new PollinatedStandingSignBlock(blockProperties, type));
        Supplier<PollinatedWallSignBlock> wall = this.register(id + "_wall_sign", () -> new PollinatedWallSignBlock(blockProperties.m_60916_((Block)standing.get()), type));
        this.itemRegistry.register(id + "_sign", () -> new PollinatedSignItem(itemProperties, (Block)standing.get(), (Block)wall.get()));
        return Pair.of(standing, wall);
    }
}

