/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import com.mojang.serialization.Codec;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.WrapperPollinatedRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import org.jetbrains.annotations.Nullable;

public class PollinatedEntityRegistry
extends WrapperPollinatedRegistry<EntityType<?>> {
    private final PollinatedRegistry<MemoryModuleType<?>> memoryModuleTypeRegistry;
    private final PollinatedRegistry<SensorType<?>> sensorTypeRegistry;
    private final PollinatedRegistry<Schedule> scheduleRegistry;
    private final PollinatedRegistry<Activity> activityRegistry;

    PollinatedEntityRegistry(PollinatedRegistry<EntityType<?>> entityRegistry) {
        super(entityRegistry);
        this.memoryModuleTypeRegistry = PollinatedEntityRegistry.create(Registry.f_122871_, entityRegistry.getModId());
        this.sensorTypeRegistry = PollinatedEntityRegistry.create(Registry.f_122872_, entityRegistry.getModId());
        this.scheduleRegistry = PollinatedEntityRegistry.create(Registry.f_122873_, entityRegistry.getModId());
        this.activityRegistry = PollinatedEntityRegistry.create(Registry.f_122874_, entityRegistry.getModId());
    }

    @Override
    protected void onRegister(Platform mod) {
        super.onRegister(mod);
        this.memoryModuleTypeRegistry.onRegister(mod);
        this.sensorTypeRegistry.onRegister(mod);
        this.scheduleRegistry.onRegister(mod);
        this.activityRegistry.onRegister(mod);
    }

    public <R> Supplier<MemoryModuleType<R>> registerMemoryModuleType(String id) {
        return this.registerMemoryModuleType(id, null);
    }

    public <R> Supplier<MemoryModuleType<R>> registerMemoryModuleType(String id, @Nullable Codec<R> codec) {
        return this.memoryModuleTypeRegistry.register(id, () -> new MemoryModuleType(Optional.ofNullable(codec)));
    }

    public <R extends Sensor<?>> Supplier<SensorType<R>> registerSensorType(String id, Supplier<R> supplier) {
        return this.sensorTypeRegistry.register(id, () -> new SensorType(supplier));
    }

    public Supplier<Schedule> registerSchedule(String id, Consumer<ScheduleBuilder> builder) {
        return this.scheduleRegistry.register(id, () -> {
            Schedule schedule = new Schedule();
            builder.accept(new ScheduleBuilder(schedule));
            return schedule;
        });
    }

    public Supplier<Activity> registerActivity(String id) {
        return this.activityRegistry.register(id, () -> new Activity(this.activityRegistry.getModId() + ":" + id));
    }

    public PollinatedRegistry<MemoryModuleType<?>> getMemoryModuleTypeRegistry() {
        return this.memoryModuleTypeRegistry;
    }

    public PollinatedRegistry<SensorType<?>> getSensorTypeRegistry() {
        return this.sensorTypeRegistry;
    }

    public PollinatedRegistry<Schedule> getScheduleRegistry() {
        return this.scheduleRegistry;
    }

    public PollinatedRegistry<Activity> getActivityRegistry() {
        return this.activityRegistry;
    }
}

