/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.resource.condition.forge.PollinatedResourceConditionImpl;
import gg.moonflower.pollen.api.util.NumberCompareMode;
import gg.moonflower.pollen.core.resource.condition.ConfigResourceCondition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public interface PollinatedResourceCondition {
    public boolean test(JsonObject var1) throws JsonParseException;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider and(PollinatedResourceConditionProvider ... values) {
        return PollinatedResourceConditionImpl.and(values);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider FALSE() {
        return PollinatedResourceConditionImpl.FALSE();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider TRUE() {
        return PollinatedResourceConditionImpl.TRUE();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider not(PollinatedResourceConditionProvider value) {
        return PollinatedResourceConditionImpl.not(value);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider or(PollinatedResourceConditionProvider ... values) {
        return PollinatedResourceConditionImpl.or(values);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider blockExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.blockExists(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider itemExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.itemExists(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider fluidExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.fluidExists(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider itemTagPopulated(TagKey<Item> tag) {
        return PollinatedResourceConditionImpl.itemTagPopulated(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider blockTagPopulated(TagKey<Block> tag) {
        return PollinatedResourceConditionImpl.blockTagPopulated(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider fluidTagPopulated(TagKey<Fluid> tag) {
        return PollinatedResourceConditionImpl.fluidTagPopulated(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider allModsLoaded(String ... modIds) {
        return PollinatedResourceConditionImpl.allModsLoaded(modIds);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider anyModsLoaded(String ... modIds) {
        return PollinatedResourceConditionImpl.anyModsLoaded(modIds);
    }

    public static PollinatedResourceConditionProvider config(String modId, PollinatedConfigType type, String key, Object value) {
        return new ConfigResourceCondition.SimpleProvider(modId, type, key, value);
    }

    public static PollinatedResourceConditionProvider config(String modId, PollinatedConfigType type, String key, Number value, NumberCompareMode compareMode) {
        return new ConfigResourceCondition.NumberProvider(modId, type, key, value, compareMode);
    }
}

