/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition.forge;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.platform.Platform;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class TagPopulatedCondition<T>
implements ICondition {
    private final ResourceKey<? extends Registry<T>> registry;
    private final TagKey<T> tag;

    public TagPopulatedCondition(ResourceKey<? extends Registry<T>> registry, ResourceLocation tag) {
        this.registry = registry;
        this.tag = TagKey.m_203882_(registry, (ResourceLocation)tag);
    }

    public boolean test(ICondition.IContext context) {
        return this.test();
    }

    @Deprecated
    public boolean test() {
        return Platform.getRegistryAccess().flatMap(access -> access.m_6632_(this.registry)).stream().anyMatch(registry -> registry.m_203658_(this.tag));
    }

    public String toString() {
        return this.registry.getRegistryName() + "_tag_populated(\"" + this.tag + "\")";
    }

    public record Serializer<T>(ResourceLocation name, Function<ResourceLocation, TagPopulatedCondition<T>> factory) implements IConditionSerializer<TagPopulatedCondition<T>>
    {
        public void write(JsonObject json, TagPopulatedCondition value) {
            json.addProperty("tag", value.tag.toString());
        }

        public TagPopulatedCondition<T> read(JsonObject json) {
            return this.factory.apply(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag")));
        }

        public ResourceLocation getID() {
            return this.name;
        }
    }
}

