/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import gg.moonflower.pollen.api.sync.SyncedDataKey;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class DataComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<SyncedDataKey<?>, Object> values = new HashMap();
    protected final Set<Integer> dirtyValues = ConcurrentHashMap.newKeySet();

    protected DataComponent() {
    }

    public <T> T getValue(SyncedDataKey<T> key) {
        return (T)this.values.computeIfAbsent(key, k -> k.getDefaultValueSupplier().get());
    }

    public <T> void setValue(SyncedDataKey<T> key, T value) {
        T oldValue = this.getValue(key);
        this.values.put(key, value);
        if (!Objects.equals(oldValue, value)) {
            this.dirtyValues.add(SyncedDataManager.getId(key));
        }
    }

    public boolean shouldSyncWith(Entity provider, Entity entity) {
        return this.values.keySet().stream().map(key -> provider == entity && key.getSyncStrategy().isSyncEntity() || key.getSyncStrategy().isSyncTracking()).reduce(false, (a, b) -> a != false || b != false);
    }

    public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory) {
        return this.values.keySet().stream().map(SyncedDataKey::isPersistent).reduce(false, (a, b) -> a != false || b != false);
    }

    public void copyForRespawn(DataComponent original, boolean lossless) {
        CompoundTag tag = new CompoundTag();
        original.writeToNbt(tag, lossless ? NbtWriteMode.COPY : NbtWriteMode.RESPAWN);
        this.readFromNbt(tag);
    }

    public void clean() {
        this.dirtyValues.clear();
    }

    public boolean isDirty() {
        return !this.dirtyValues.isEmpty();
    }

    public void readFromNbt(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            Tag tag = nbt.m_128423_(key);
            try {
                ResourceLocation name = new ResourceLocation(key);
                SyncedDataKey<?> syncedDataKey = SyncedDataManager.byName(name);
                if (syncedDataKey == null) {
                    throw new IllegalStateException("Unknown synced data key: " + name);
                }
                this.values.put(syncedDataKey, this.readWithCodec(syncedDataKey, tag));
            }
            catch (Exception e) {
                LOGGER.error("Failed to decode " + key + " from NBT: " + tag, (Throwable)e);
            }
        }
    }

    public void writeToNbt(CompoundTag nbt, NbtWriteMode mode) {
        for (Map.Entry<SyncedDataKey<?>, Object> entry : this.values.entrySet()) {
            SyncedDataKey<?> key = entry.getKey();
            if (mode == NbtWriteMode.SAVE && !key.isSave() || mode == NbtWriteMode.RESPAWN && !key.isPersistent()) continue;
            this.writeWithCodec(key).ifPresent(tag -> nbt.m_128365_(key.getKey().toString(), tag));
        }
    }

    protected void writePacketData(FriendlyByteBuf buf, int[] ids) {
        buf.m_130130_(ids.length);
        for (int i : ids) {
            buf.m_130130_(i);
            SyncedDataKey<?> key = SyncedDataManager.byId(i);
            CompoundTag tag = new CompoundTag();
            this.writeWithCodec(key).ifPresent(data -> tag.m_128365_("a", (Tag)data));
            buf.m_130079_(tag);
        }
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            SyncedDataKey<?> key = SyncedDataManager.byId(buf.m_130242_());
            CompoundTag tag = buf.m_130260_();
            if (tag != null && tag.m_128441_("a")) {
                this.values.put(key, this.readWithCodec(key, tag.m_128423_("a")));
            }
            buf.m_130079_(tag);
        }
    }

    protected <T> T readWithCodec(SyncedDataKey<T> key, Tag data) {
        DataResult dataResult = key.getCodec().parse((DynamicOps)NbtOps.f_128958_, (Object)data);
        if (dataResult.error().isPresent() || !dataResult.result().isPresent()) {
            LOGGER.error("Failed to decode " + key.getKey() + " from NBT: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + data);
            return key.getDefaultValueSupplier().get();
        }
        return dataResult.result().get();
    }

    protected <T> Optional<Tag> writeWithCodec(SyncedDataKey<T> key) {
        if (!this.values.containsKey(key)) {
            return Optional.empty();
        }
        T value = this.getValue(key);
        DataResult dataResult = key.getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, value);
        if (dataResult.error().isPresent() || !dataResult.result().isPresent()) {
            LOGGER.error("Failed to encode " + key.getKey() + " to NBT: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + value);
            return Optional.empty();
        }
        return dataResult.result();
    }

    public static enum NbtWriteMode {
        COPY,
        SAVE,
        RESPAWN;

    }
}

