/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class SyncedDataKey<T> {
    private final ResourceLocation key;
    private final Codec<T> codec;
    private final Supplier<T> defaultValueSupplier;
    private final boolean save;
    private final boolean persistent;
    private final SyncStrategy syncStrategy;

    private SyncedDataKey(ResourceLocation key, Codec<T> codec, Supplier<T> defaultValueSupplier, boolean save, boolean persistent, SyncStrategy syncStrategy) {
        this.key = key;
        this.codec = codec;
        this.defaultValueSupplier = defaultValueSupplier;
        this.save = save;
        this.persistent = persistent;
        this.syncStrategy = syncStrategy;
    }

    public static <T> Builder<T> builder(ResourceLocation id, Codec<T> codec, Supplier<T> defaultValueSupplier) {
        return new Builder<T>(id, codec, defaultValueSupplier);
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public Supplier<T> getDefaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public boolean isSave() {
        return this.save;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public SyncStrategy getSyncStrategy() {
        return this.syncStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncedDataKey that = (SyncedDataKey)o;
        return this.key.equals((Object)that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "SyncedDataKey{key=" + this.key + ", save=" + this.save + ", persistent=" + this.persistent + ", syncStrategy=" + this.syncStrategy + "}";
    }

    public static enum SyncStrategy {
        NONE(false, false),
        ENTITY(true, false),
        TRACKING(false, true),
        TRACKING_AND_SELF(true, true);

        private final boolean syncEntity;
        private final boolean syncTracking;

        private SyncStrategy(boolean syncEntity, boolean syncTracking) {
            this.syncEntity = syncEntity;
            this.syncTracking = syncTracking;
        }

        public boolean isSyncEntity() {
            return this.syncEntity;
        }

        public boolean isSyncTracking() {
            return this.syncTracking;
        }
    }

    public static class Builder<T> {
        private final ResourceLocation id;
        private final Codec<T> codec;
        private final Supplier<T> defaultValueSupplier;
        private boolean save = false;
        private boolean persistent = true;
        private SyncStrategy syncStrategy = SyncStrategy.TRACKING_AND_SELF;

        private Builder(ResourceLocation id, Codec<T> codec, Supplier<T> defaultValueSupplier) {
            this.id = id;
            this.codec = codec;
            this.defaultValueSupplier = defaultValueSupplier;
        }

        public SyncedDataKey<T> build() {
            return new SyncedDataKey<T>(this.id, this.codec, this.defaultValueSupplier, this.save, this.persistent, this.syncStrategy);
        }

        public Builder<T> saveToFile() {
            this.save = true;
            return this;
        }

        public Builder<T> resetOnDeath() {
            this.persistent = false;
            return this;
        }

        public Builder<T> syncStrategy(SyncStrategy syncStrategy) {
            this.syncStrategy = syncStrategy;
            return this;
        }
    }
}

