/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.molangcompiler.api.MolangCompiler;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public final class JSONTupleParser {
    private JSONTupleParser() {
    }

    public static <T> T[] insert(T[] a, T[] b) {
        T[] expanded = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, expanded, a.length, b.length);
        return expanded;
    }

    public static <T> T[] remove(T[] array, T remove) {
        for (int i = 0; i < array.length; ++i) {
            if (!remove.equals(array[i])) continue;
            System.arraycopy(array, i + 1, array, i, array.length - i - 1);
            array = Arrays.copyOf(array, array.length - 1);
        }
        return array;
    }

    public static <T> T[] getArray(JsonObject json, String name, T[] array, int minSize, Function<String, T> getter) {
        if (!json.has(name)) {
            return array;
        }
        JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)name);
        if (jsonArray.size() < minSize) {
            throw new JsonSyntaxException("Expected " + name + " to have at least " + minSize + "elements");
        }
        if (array.length != jsonArray.size()) {
            array = Arrays.copyOf(array, jsonArray.size());
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = getter.apply(GsonHelper.m_13805_((JsonElement)jsonArray.get(i), (String)(name + "[" + i + "]")));
        }
        return array;
    }

    public static float[] getFloat(JsonObject json, String name, int length, @Nullable Supplier<float[]> defaultValue) throws JsonSyntaxException {
        JsonPrimitive valuePrimitive;
        if (!json.has(name) && defaultValue != null) {
            return defaultValue.get();
        }
        if (!json.has(name)) {
            throw new JsonSyntaxException("Expected " + name + " to be a JsonArray or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
        }
        if (json.get(name).isJsonPrimitive() && json.getAsJsonPrimitive(name).isString()) {
            throw new JsonSyntaxException("Molang expressions are not supported");
        }
        if (json.get(name).isJsonArray()) {
            JsonArray vectorJson = json.getAsJsonArray(name);
            if (vectorJson.size() != 1 && vectorJson.size() != length) {
                throw new JsonParseException("Expected 1 or " + length + " " + name + " values, was " + vectorJson.size());
            }
            float[] values = new float[length];
            if (vectorJson.size() == 1) {
                Arrays.fill(values, GsonHelper.m_13888_((JsonElement)vectorJson.get(0), (String)name));
            } else {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = GsonHelper.m_13888_((JsonElement)vectorJson.get(i), (String)(name + "[" + i + "]"));
                }
            }
            return values;
        }
        if (json.get(name).isJsonPrimitive() && (valuePrimitive = json.getAsJsonPrimitive(name)).isNumber()) {
            float[] values = new float[length];
            Arrays.fill(values, valuePrimitive.getAsFloat());
            return values;
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonArray or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MolangExpression[] getExpression(JsonObject json, String name, int length, @Nullable Supplier<MolangExpression[]> defaultValue) throws JsonSyntaxException {
        try {
            if (!json.has(name) && defaultValue != null) {
                return defaultValue.get();
            }
            if (!json.has(name)) {
                throw new JsonSyntaxException("Expected " + name + " to be a JsonArray or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
            }
            if (json.get(name).isJsonArray()) {
                JsonArray vectorJson = json.getAsJsonArray(name);
                if (vectorJson.size() != 1 && vectorJson.size() != length) {
                    throw new JsonParseException("Expected 1 or " + length + " " + name + " values, was " + vectorJson.size());
                }
                Object[] values = new MolangExpression[length];
                if (vectorJson.size() == 1) {
                    JsonElement vectorElement = vectorJson.get(0);
                    if (!vectorElement.isJsonPrimitive()) {
                        throw new JsonSyntaxException("Expected " + name + " to be a Float or String, was " + GsonHelper.m_13883_((JsonElement)vectorElement));
                    }
                    JsonPrimitive vectorPrimitive = vectorElement.getAsJsonPrimitive();
                    if (vectorPrimitive.isString()) {
                        Arrays.fill(values, MolangCompiler.compile(vectorPrimitive.getAsString()));
                        return values;
                    } else {
                        if (!vectorPrimitive.isNumber()) throw new JsonSyntaxException("Expected " + name + " to be a Float or String, was " + GsonHelper.m_13883_((JsonElement)vectorElement));
                        Arrays.fill(values, MolangExpression.of(vectorPrimitive.getAsFloat()));
                    }
                    return values;
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        JsonElement vectorElement = vectorJson.get(i);
                        if (!vectorElement.isJsonPrimitive()) {
                            throw new JsonSyntaxException("Expected " + name + "[" + i + "] to be a Float or String, was " + GsonHelper.m_13883_((JsonElement)vectorElement));
                        }
                        JsonPrimitive vectorPrimitive = vectorElement.getAsJsonPrimitive();
                        if (vectorPrimitive.isString()) {
                            values[i] = MolangCompiler.compile(vectorPrimitive.getAsString());
                            continue;
                        }
                        if (!vectorPrimitive.isNumber()) throw new JsonSyntaxException("Expected " + name + "[" + i + "] to be a Float or String, was " + GsonHelper.m_13883_((JsonElement)vectorElement));
                        values[i] = MolangExpression.of(vectorPrimitive.getAsFloat());
                    }
                }
                return values;
            }
            if (!json.get(name).isJsonPrimitive()) throw new JsonSyntaxException("Expected " + name + " to be a JsonArray or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
            JsonPrimitive valuePrimitive = json.getAsJsonPrimitive(name);
            if (valuePrimitive.isNumber()) {
                Object[] values = new MolangExpression[length];
                Arrays.fill(values, MolangExpression.of(valuePrimitive.getAsFloat()));
                return values;
            }
            if (!valuePrimitive.isString()) throw new JsonSyntaxException("Expected " + name + " to be a JsonArray or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
            Object[] values = new MolangExpression[length];
            Arrays.fill(values, MolangCompiler.compile(valuePrimitive.getAsString()));
            return values;
        }
        catch (MolangException e) {
            throw new JsonParseException("Failed to compile MoLang expression", (Throwable)e);
        }
    }

    public static MolangExpression getExpression(JsonObject json, String name, @Nullable Supplier<MolangExpression> defaultValue) throws JsonSyntaxException {
        try {
            if (!json.has(name) && defaultValue != null) {
                return defaultValue.get();
            }
            if (!json.has(name)) {
                throw new JsonSyntaxException("Expected " + name + " to be a Float or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
            }
            if (json.get(name).isJsonPrimitive()) {
                JsonPrimitive valuePrimitive = json.getAsJsonPrimitive(name);
                if (valuePrimitive.isNumber()) {
                    return MolangExpression.of(valuePrimitive.getAsFloat());
                }
                if (valuePrimitive.isString()) {
                    return MolangCompiler.compile(valuePrimitive.getAsString());
                }
            }
        }
        catch (MolangException e) {
            throw new JsonParseException("Failed to compile MoLang expression", (Throwable)e);
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Float or JsonPrimitive, was " + GsonHelper.m_13883_((JsonElement)json));
    }
}

