/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class QuickMoveHelper {
    private final List<Action> actions = new ArrayList<Action>();

    private static boolean mergeItemStack(AbstractContainerMenu menu, ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        boolean flag = false;
        int i = startIndex;
        if (reverse) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(reverse ? i < startIndex : i >= endIndex)) {
                Slot slot = menu.m_38853_(i);
                ItemStack itemstack = slot.m_7993_();
                if (slot.m_5857_(stack) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_5866_(stack), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverse ? endIndex - 1 : startIndex;
            while (!(!reverse ? i >= endIndex : i < startIndex)) {
                Slot slot1 = menu.m_38853_(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    if (stack.m_41613_() > slot1.m_5866_(stack)) {
                        slot1.m_5852_(stack.m_41620_(slot1.m_5866_(stack)));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public QuickMoveHelper add(int fromStart, int fromSize, int toStart, int toSize, boolean reverse) {
        this.actions.add(new Action(fromStart, fromSize, toStart, toSize, reverse));
        return this;
    }

    public ItemStack quickMoveStack(AbstractContainerMenu menu, Player player, int slotId) {
        ItemStack oldStack = ItemStack.f_41583_;
        Slot slot = menu.m_38853_(slotId);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            oldStack = slotItem.m_41777_();
            for (Action action : this.actions) {
                if (slotId < action.fromStart || slotId >= action.fromEnd || QuickMoveHelper.mergeItemStack(menu, slotItem, action.toStart, action.toEnd, action.reverse)) continue;
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == oldStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItem);
        }
        return oldStack;
    }

    public static class Action {
        private final int fromStart;
        private final int fromEnd;
        private final int toStart;
        private final int toEnd;
        private final boolean reverse;

        public Action(int fromStart, int fromSize, int toStart, int toSize, boolean reverse) {
            this.fromStart = fromStart;
            this.fromEnd = fromStart + fromSize;
            this.toStart = toStart;
            this.toEnd = toStart + toSize;
            this.reverse = reverse;
        }
    }
}

