/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import gg.moonflower.pollen.core.client.entitlement.type.DeveloperHalo;
import gg.moonflower.pollen.core.client.entitlement.type.Halo;
import gg.moonflower.pollen.core.client.entitlement.type.ModelCosmetic;
import gg.moonflower.pollen.core.client.screen.button.EntitlementEntry;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class Entitlement {
    private ResourceLocation registryName;
    private Component displayName;

    protected abstract Entitlement copyData();

    public final Entitlement copy() {
        Entitlement entitlement = this.copyData();
        entitlement.setRegistryName(this.getRegistryName().m_135815_());
        entitlement.setDisplayName(this.getDisplayName());
        return entitlement;
    }

    public abstract void updateSettings(JsonObject var1);

    public void addEntries(Consumer<EntitlementEntry> entryConsumer) {
    }

    public boolean hasSettings() {
        return !this.saveSettings().entrySet().isEmpty();
    }

    public abstract JsonObject saveSettings();

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public final void setRegistryName(String registryName) {
        Validate.isTrue((this.registryName == null ? 1 : 0) != 0);
        this.registryName = new ResourceLocation("pollen", registryName);
    }

    public final void setDisplayName(Component displayName) {
        Validate.isTrue((this.displayName == null ? 1 : 0) != 0);
        this.displayName = displayName;
    }

    public abstract Type getType();

    public static enum Type {
        COSMETIC(ModelCosmetic.CODEC),
        HALO(Halo.CODEC),
        DEVELOPER_HALO(DeveloperHalo.CODEC);

        private final Codec<? extends Entitlement> codec;

        private Type(Codec<? extends Entitlement> codec) {
            this.codec = codec;
        }

        public Codec<? extends Entitlement> codec() {
            return this.codec;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().toLowerCase(Locale.ROOT).equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

