/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.icu.impl.Pair;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import gg.moonflower.pollen.api.event.events.client.render.AddRenderLayersEvent;
import gg.moonflower.pollen.api.event.events.entity.EntityEvents;
import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.core.Pollen;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.ModelEntitlement;
import gg.moonflower.pollen.core.client.entitlement.TexturedEntitlement;
import gg.moonflower.pollen.core.client.profile.ProfileManager;
import gg.moonflower.pollen.core.client.render.layer.PollenCosmeticLayer;
import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.network.play.ServerboundUpdateSettingsPacket;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class EntitlementManager {
    private static final Map<String, Entitlement> ENTITLEMENTS = new HashMap<String, Entitlement>();
    private static final Map<UUID, EntitlementData> PLAYER_ENTITLEMENTS = new HashMap<UUID, EntitlementData>();
    private static final Logger LOGGER = LogManager.getLogger();

    private EntitlementManager() {
    }

    private static EntitlementData getData(UUID id) {
        return PLAYER_ENTITLEMENTS.computeIfAbsent(id, EntitlementData::new);
    }

    public static void init() {
        AddRenderLayersEvent.EVENT.register(context -> {
            for (String skin : context.getSkins()) {
                PlayerRenderer renderer = context.getSkin(skin);
                if (renderer == null) continue;
                renderer.m_115326_(new PollenCosmeticLayer(context.getSkin(skin)));
            }
        });
        ResourceRegistry.registerReloadListener(PackType.CLIENT_RESOURCES, new PollinatedPreparableReloadListener(){

            @Override
            public ResourceLocation getPollenId() {
                return new ResourceLocation("pollen", "entitlements");
            }

            public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                ProfileManager.getProfile(Minecraft.m_91087_().m_91094_().m_92548_().getId());
                return stage.m_6769_(null);
            }
        });
    }

    public static CompletableFuture<Void> reload(boolean force, PreparableReloadListener.PreparationBarrier stage) {
        return force ? ProfileManager.getProfile(Minecraft.m_91087_().m_91094_().m_92548_().getId()).thenCompose(__ -> stage.m_6769_(null)) : stage.m_6769_(null);
    }

    public static void clearCache() {
        PLAYER_ENTITLEMENTS.clear();
    }

    public static void clearCache(UUID id) {
        PLAYER_ENTITLEMENTS.remove(id);
    }

    public static Stream<Entitlement> getAllEntitlements() {
        return ENTITLEMENTS.values().stream();
    }

    public static Stream<Entitlement> getEntitlements(UUID id) {
        Map entitlementMap = EntitlementManager.getEntitlementsFuture(id).getNow(Collections.emptyMap());
        return entitlementMap.isEmpty() ? Stream.empty() : entitlementMap.values().stream();
    }

    public static CompletableFuture<Map<String, Entitlement>> getEntitlementsFuture(UUID id) {
        return EntitlementManager.getData(id).getFuture();
    }

    public static <T extends Entitlement> void updateEntitlementSettings(UUID id, String entitlementId, Consumer<T> action) {
        if (Pollen.CLIENT_CONFIG.disableMoonflowerProfiles.get().booleanValue()) {
            return;
        }
        ((CompletableFuture)EntitlementManager.getEntitlementsFuture(id).thenApplyAsync(map -> {
            if (!map.containsKey(entitlementId)) {
                return null;
            }
            Entitlement entitlement = (Entitlement)map.get(entitlementId);
            JsonObject oldSettings = entitlement.saveSettings();
            action.accept(entitlement);
            JsonObject json = entitlement.saveSettings();
            HashSet<String> unchangedElements = new HashSet<String>(json.size() / 2);
            for (Map.Entry entry : json.entrySet()) {
                if (!oldSettings.has((String)entry.getKey()) || !((JsonElement)entry.getValue()).equals(oldSettings.get((String)entry.getKey()))) continue;
                unchangedElements.add((String)entry.getKey());
            }
            unchangedElements.forEach(arg_0 -> ((JsonObject)json).remove(arg_0));
            if (!json.entrySet().isEmpty() && Minecraft.m_91087_().m_91403_() != null) {
                PollenMessages.PLAY.sendToServer(new ServerboundUpdateSettingsPacket(entitlementId, json));
            }
            return Pair.of((Object)entitlement, (Object)json);
        }, (Executor)Minecraft.m_91087_())).thenAcceptAsync(pair -> {
            if (pair == null || ((JsonObject)pair.second).entrySet().isEmpty()) {
                return;
            }
            try {
                ((Entitlement)pair.first).updateSettings(ProfileManager.CONNECTION.updateSettings(id, entitlementId, (JsonObject)pair.second));
            }
            catch (IOException e) {
                throw new CompletionException("Failed to update entitlement settings for " + entitlementId, e);
            }
        }, (Executor)HttpUtil.f_13936_);
    }

    static {
        EntityEvents.LEAVE.register((entity, level) -> {
            if (level.m_5776_() && entity instanceof Player && Minecraft.m_91087_().f_91074_ != entity) {
                PLAYER_ENTITLEMENTS.remove(entity.m_142081_());
            }
        });
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> PLAYER_ENTITLEMENTS.keySet().removeIf(id -> player != null && !player.m_142081_().equals(id)));
    }

    private static class EntitlementData {
        private static final long CACHE_TIME = TimeUnit.HOURS.toMillis(1L);
        private final UUID id;
        private volatile CompletableFuture<Map<String, Entitlement>> future;
        private volatile long expireTime;

        private EntitlementData(UUID id) {
            this.id = id;
            this.expireTime = 0L;
        }

        public synchronized CompletableFuture<Map<String, Entitlement>> getFuture() {
            if (Pollen.CLIENT_CONFIG.disableMoonflowerProfiles.get().booleanValue()) {
                return CompletableFuture.completedFuture(Collections.emptyMap());
            }
            if (!(this.future == null || this.future.isDone() && System.currentTimeMillis() >= this.expireTime)) {
                return this.future;
            }
            this.future = ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    return ProfileManager.CONNECTION.getEntitlementSettings(this.id);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, (Executor)HttpUtil.f_13936_).thenCompose(map -> CompletableFuture.allOf((CompletableFuture[])map.keySet().stream().filter(entitlementId -> !ENTITLEMENTS.containsKey(entitlementId)).map(entitlementId -> CompletableFuture.supplyAsync(() -> {
                try {
                    return ProfileManager.CONNECTION.getEntitlement((String)entitlementId);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to retrieve entitlement: " + entitlementId, (Throwable)e);
                    return null;
                }
            }, (Executor)HttpUtil.f_13936_).thenAcceptAsync(entitlement -> {
                if (entitlement != null) {
                    ENTITLEMENTS.put((String)entitlementId, (Entitlement)entitlement);
                } else {
                    map.remove(entitlementId);
                }
            }, (Executor)Minecraft.m_91087_())).toArray(CompletableFuture[]::new)).thenApply(__ -> map))).thenApplyAsync(map -> {
                Map<String, Entitlement> entitlementMap = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    Entitlement entitlement = ENTITLEMENTS.get(entry.getKey()).copy();
                    entitlement.updateSettings((JsonObject)entry.getValue());
                    return entitlement;
                }));
                this.expireTime = System.currentTimeMillis() + CACHE_TIME;
                Minecraft.m_91087_().m_6937_(() -> {
                    if (entitlementMap.values().stream().anyMatch(entitlement -> entitlement instanceof ModelEntitlement)) {
                        GeometryModelManager.reload(false);
                    }
                    if (entitlementMap.values().stream().anyMatch(entitlement -> entitlement instanceof TexturedEntitlement)) {
                        GeometryTextureManager.reload(false);
                    }
                });
                return entitlementMap;
            }, (Executor)Minecraft.m_91087_())).exceptionally(e -> {
                if (!(e instanceof ProfileNotFoundException || e instanceof CompletionException && e.getCause() instanceof ProfileNotFoundException)) {
                    LOGGER.error("Failed to retrieve entitlements for " + this.id, e);
                }
                this.expireTime = System.currentTimeMillis() + CACHE_TIME;
                return new HashMap();
            });
            return this.future;
        }
    }
}

