/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement.type;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.RenderableCosmetic;
import gg.moonflower.pollen.core.client.screen.button.ArrayEntry;
import gg.moonflower.pollen.core.client.screen.button.EntitlementEntry;
import gg.moonflower.pollen.core.client.screen.button.ToggleEntry;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractHalo
extends Entitlement
implements RenderableCosmetic {
    private boolean emissive;
    private Visibility visibility;
    private Display display;

    @Override
    public void updateSettings(JsonObject settings) {
        if (settings.has("emissive")) {
            this.setEmissive(GsonHelper.m_13912_((JsonObject)settings, (String)"emissive"));
        }
        if (settings.has("visibility")) {
            this.setVisibility(Visibility.byName(GsonHelper.m_13906_((JsonObject)settings, (String)"visibility")));
        }
        if (settings.has("display")) {
            this.setDisplay(Display.byName(GsonHelper.m_13906_((JsonObject)settings, (String)"display")));
        }
    }

    @Override
    public JsonObject saveSettings() {
        JsonObject settings = new JsonObject();
        settings.addProperty("emissive", Boolean.valueOf(this.emissive));
        settings.addProperty("visibility", this.visibility.name().toLowerCase(Locale.ROOT));
        settings.addProperty("display", this.display.name().toLowerCase(Locale.ROOT));
        return settings;
    }

    @Override
    public void addEntries(Consumer<EntitlementEntry> entryConsumer) {
        entryConsumer.accept(new ArrayEntry<Visibility>((Component)new TextComponent("Visibility"), this, v -> {
            this.visibility = v;
        }, this.visibility, Visibility.values()));
        entryConsumer.accept(new ArrayEntry<Display>((Component)new TextComponent("Display"), this, v -> {
            this.display = v;
        }, this.display, Display.values()));
        entryConsumer.accept(new ToggleEntry((Component)new TextComponent("Emissive"), this, v -> {
            this.emissive = v;
        }, this.emissive));
    }

    @Nullable
    protected abstract HaloData getData();

    @Override
    @Nullable
    public ResourceLocation getModelKey() {
        HaloData data = this.getData();
        return data != null ? this.display.getter.apply(data) : null;
    }

    @Override
    public boolean isEnabled() {
        return this.visibility != Visibility.OFF;
    }

    @Override
    public float getAlpha() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || this.getVisibility() != Visibility.MOONLIGHT) {
            return 1.0f;
        }
        float brightness = level.m_104811_(Minecraft.m_91087_().m_91296_()) / 0.5f;
        return brightness * brightness;
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setEmissive(boolean emissive) {
        this.emissive = emissive;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public static enum Visibility {
        OFF,
        ON,
        MOONLIGHT;


        public static Visibility byName(String name) {
            for (Visibility type : Visibility.values()) {
                if (!name.equals(type.name().toLowerCase(Locale.ROOT))) continue;
                return type;
            }
            return OFF;
        }
    }

    public static enum Display {
        DEFAULT(HaloData::getDefaultModelKey),
        HORIZONTAL(HaloData::getHorizontalModelKey),
        VERTICAL(HaloData::getVerticalModelKey);

        private final Function<HaloData, ResourceLocation> getter;

        private Display(Function<HaloData, ResourceLocation> getter) {
            this.getter = getter;
        }

        public static Display byName(String name) {
            for (Display type : Display.values()) {
                if (!name.equals(type.name().toLowerCase(Locale.ROOT))) continue;
                return type;
            }
            return DEFAULT;
        }
    }

    public static class HaloData {
        public static final Codec<HaloData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("modelUrl").forGetter(HaloData::getModelUrl), (App)Codec.STRING.fieldOf("defaultModelKey").forGetter(data -> data.getDefaultModelKey().m_135815_()), (App)Codec.STRING.fieldOf("horizontalModelKey").forGetter(data -> data.getHorizontalModelKey().m_135815_()), (App)Codec.STRING.fieldOf("verticalModelKey").forGetter(data -> data.getVerticalModelKey().m_135815_()), (App)GeometryModelTextureTable.CODEC.fieldOf("textureTable").forGetter(HaloData::getTextureTable)).apply((Applicative)instance, HaloData::new));
        private final String modelUrl;
        private final ResourceLocation defaultModelKey;
        private final ResourceLocation horizontalModelKey;
        private final ResourceLocation verticalModelKey;
        private final GeometryModelTextureTable textureTable;

        public HaloData(String modelUrl, String defaultModelKey, String horizontalModelKey, String verticalModelKey, GeometryModelTextureTable textureTable) {
            this.modelUrl = modelUrl;
            this.defaultModelKey = new ResourceLocation("pollen", defaultModelKey);
            this.horizontalModelKey = new ResourceLocation("pollen", horizontalModelKey);
            this.verticalModelKey = new ResourceLocation("pollen", verticalModelKey);
            this.textureTable = textureTable;
        }

        public String getModelUrl() {
            return this.modelUrl;
        }

        public ResourceLocation getDefaultModelKey() {
            return this.defaultModelKey;
        }

        public ResourceLocation getHorizontalModelKey() {
            return this.horizontalModelKey;
        }

        public ResourceLocation getVerticalModelKey() {
            return this.verticalModelKey;
        }

        public GeometryModelTextureTable getTextureTable() {
            return this.textureTable;
        }
    }
}

