/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.screen.EntitlementsList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class EntitlementListScreen
extends Screen {
    private static final Component NO_COSMETICS = new TranslatableComponent("options.pollen.entitlementList.none");
    private static final Component RELOAD = new TranslatableComponent("options.pollen.entitlementList.reload");
    private final Screen lastScreen;
    private final CompletableFuture<Map<String, Entitlement>> entitlementsFuture;
    private EntitlementsList list;

    public EntitlementListScreen(Screen screen) {
        super((Component)new TranslatableComponent("options.pollen.entitlementList.title"));
        this.lastScreen = screen;
        this.entitlementsFuture = EntitlementManager.getEntitlementsFuture(Minecraft.m_91087_().m_91094_().m_92548_().getId());
    }

    protected void m_7856_() {
        this.list = new EntitlementsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.entitlementsFuture.thenAcceptAsync(map -> this.list.add(this, (Entitlement[])map.values().stream().filter(Entitlement::hasSettings).sorted(Comparator.comparing(entitlement -> entitlement.getDisplayName().getString())).toArray(Entitlement[]::new)), (Executor)this.f_96541_);
        this.m_7787_((GuiEventListener)this.list);
        if (this.f_96541_.m_91094_().m_92548_().getId() != null) {
            int refreshWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)RELOAD) + 32;
            Button refreshButton = new Button(this.f_96543_ - refreshWidth - 6, 6, refreshWidth, 20, RELOAD, button -> {
                EntitlementManager.clearCache(this.f_96541_.m_91094_().m_92548_().getId());
                this.f_96541_.m_91152_((Screen)new EntitlementListScreen(this.lastScreen));
            });
            if (!this.entitlementsFuture.isDone()) {
                refreshButton.f_93623_ = false;
                this.entitlementsFuture.thenRunAsync(() -> {
                    refreshButton.f_93623_ = true;
                }, (Executor)this.f_96541_);
            }
            this.m_142416_((GuiEventListener)refreshButton);
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.lastScreen)));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        EntitlementListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        if (this.entitlementsFuture.isDone() && this.entitlementsFuture.join().isEmpty()) {
            EntitlementListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_COSMETICS, (int)(this.f_96543_ / 2), (int)(32 + this.f_96544_ / 4), (int)0xFFFFFF);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    @Nullable
    public static List<FormattedCharSequence> tooltipAt(EntitlementsList arg, int x, int y) {
        Optional<AbstractWidget> optional = arg.getMouseOver(x, y);
        if (optional.isPresent() && optional.get() instanceof TooltipAccessor) {
            return ((TooltipAccessor)optional.get()).m_141932_();
        }
        return null;
    }
}

