/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.screen.button;

import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class EntitlementEntry {
    private final Component caption;
    private final Entitlement entitlement;
    private List<FormattedCharSequence> toolTip;

    protected EntitlementEntry(Component caption, Entitlement entitlement) {
        this.caption = caption;
        this.entitlement = entitlement;
        this.toolTip = null;
    }

    public abstract AbstractWidget createButton(int var1, int var2, int var3);

    public abstract void updateButton(AbstractWidget var1);

    public abstract void save();

    protected Entitlement getEntitlement() {
        return this.entitlement;
    }

    protected Component getCaption() {
        return this.caption;
    }

    public void setTooltip(@Nullable List<FormattedCharSequence> toolTip) {
        this.toolTip = toolTip;
    }

    public Optional<List<FormattedCharSequence>> getTooltip() {
        return Optional.ofNullable(this.toolTip);
    }

    protected Component pixelValueLabel(int value) {
        return new TranslatableComponent("options.pixel_value", new Object[]{this.getCaption(), value});
    }

    protected Component percentValueLabel(double percentage) {
        return new TranslatableComponent("options.percent_value", new Object[]{this.getCaption(), (int)(percentage * 100.0)});
    }

    protected Component percentAddValueLabel(int doubleValue) {
        return new TranslatableComponent("options.percent_add_value", new Object[]{this.getCaption(), doubleValue});
    }

    protected Component genericValueLabel(Component valueMessage) {
        return new TranslatableComponent("options.generic_value", new Object[]{this.getCaption(), valueMessage});
    }

    protected Component genericValueLabel(int value) {
        return this.genericValueLabel((Component)new TextComponent(Integer.toString(value)));
    }
}

