/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.event;

import gg.moonflower.pollen.api.event.PollinatedEvent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollinatedEventImpl<T>
extends PollinatedEvent<T> {
    private final Function<T[], T> factory;
    private final Lock lock = new ReentrantLock();
    private T[] handlers;

    public PollinatedEventImpl(Class<? super T> type, Function<T[], T> factory) {
        this.factory = factory;
        this.handlers = (Object[])Array.newInstance(type, 0);
        this.invoker = this.factory.apply((T[][])this.handlers);
    }

    @Override
    public void register(T listener) {
        Objects.requireNonNull(listener, "Tried to register a null listener");
        this.lock.lock();
        try {
            this.handlers = Arrays.copyOf(this.handlers, this.handlers.length + 1);
            this.handlers[this.handlers.length - 1] = listener;
            this.invoker = this.factory.apply((T[][])this.handlers);
        }
        finally {
            this.lock.unlock();
        }
    }
}

