/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge.compat.jei;

import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.api.crafting.grindstone.PollenGrindstoneRecipe;
import gg.moonflower.pollen.api.crafting.grindstone.PollenShapelessGrindstoneRecipe;
import gg.moonflower.pollen.core.mixin.forge.client.RecipeManagerAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PollenRecipeMaker {
    private PollenRecipeMaker() {
    }

    public static List<PollenGrindstoneRecipe> getGrindstoneRecipes(IRecipeCategory<PollenGrindstoneRecipe> category, IIngredientManager ingredientManager) {
        List<PollenGrindstoneRecipe> recipes = PollenRecipeMaker.getRecipes(category, PollenRecipeTypes.GRINDSTONE_TYPE.get());
        Collection ingredients = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValues();
        for (ItemStack ingredient : ingredients) {
            ResourceLocation id;
            if (!ingredient.m_41792_() || (id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)ingredient.m_41720_())) == null) continue;
            Stream inputs = enchantments.stream().filter(enchantment -> !enchantment.m_6589_()).flatMap(enchantment -> IntStream.rangeClosed(enchantment.m_44702_(), enchantment.m_6586_()).mapToObj(level -> {
                HashMap<Enchantment, Integer> enchantmentsMap = new HashMap<Enchantment, Integer>(1);
                enchantmentsMap.put((Enchantment)enchantment, level);
                ItemStack input = ingredient.m_41720_() == Items.f_42517_ ? new ItemStack((ItemLike)Items.f_42690_) : ingredient.m_41777_();
                EnchantmentHelper.m_44865_(enchantmentsMap, (ItemStack)input);
                return input;
            }));
            recipes.add(new PollenShapelessGrindstoneRecipe(new ResourceLocation(id.m_135827_(), "disenchant_" + id.m_135815_()), "", ingredient, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43921_(inputs)}), -1));
        }
        return recipes;
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getRecipes(@Nullable IRecipeCategory<T> category, RecipeType<T> type) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection == null) {
            return Collections.emptyList();
        }
        return PollenRecipeMaker.getRecipes(connection.m_105141_(), type).stream().filter(recipe -> !recipe.m_5598_()).filter(recipe -> category == null || category.isHandled(recipe)).collect(Collectors.toList());
    }

    private static <C extends Container, T extends Recipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, RecipeType<T> recipeType) {
        return ((RecipeManagerAccessor)recipeManager).invokeByType(recipeType).values();
    }
}

