/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.event.events.entity.ModifyGravityEvent;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private int captureAirSupply;

    @Shadow
    protected abstract int m_7302_(int var1);

    @Shadow
    public abstract boolean m_6040_();

    @Shadow
    public abstract void m_21043_(LivingEntity var1, boolean var2);

    @Shadow
    protected abstract boolean m_6129_();

    @Shadow
    public abstract boolean m_203441_(FluidState var1);

    private LivingEntityMixin(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    public void captureState(CallbackInfo ci) {
        this.captureAirSupply = this.m_20146_();
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z", shift=At.Shift.BEFORE)})
    public void tickFluidDrowning(CallbackInfo ci) {
        if (this.m_6084_()) {
            FluidBehaviorRegistry.get(arg_0 -> ((LivingEntityMixin)this).m_204029_(arg_0)).forEach(behavior -> {
                LivingEntity livingEntity = (LivingEntity)this;
                if (!behavior.shouldEntityDrown(livingEntity)) {
                    return;
                }
                if (!(this.m_6040_() || MobEffectUtil.m_19588_((LivingEntity)livingEntity) || this instanceof Player && ((Player)livingEntity).m_150110_().f_35934_)) {
                    this.m_20301_(this.captureAirSupply);
                    this.m_20301_(this.m_7302_(this.m_20146_()));
                    if (this.m_20146_() == -20) {
                        this.m_20301_(0);
                        Vec3 vec3 = this.m_20184_();
                        ParticleOptions particle = behavior.getDrowningParticles(livingEntity);
                        if (particle != null) {
                            for (int i = 0; i < 8; ++i) {
                                double f = this.f_19796_.nextDouble() - this.f_19796_.nextDouble();
                                double g = this.f_19796_.nextDouble() - this.f_19796_.nextDouble();
                                double h = this.f_19796_.nextDouble() - this.f_19796_.nextDouble();
                                this.f_19853_.m_7106_(particle, this.m_20185_() + f, this.m_20186_() + g, this.m_20189_() + h, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                            }
                        }
                        this.m_6469_(DamageSource.f_19312_, behavior.getDrowningDamage(livingEntity));
                    }
                }
                if (!this.f_19853_.m_5776_() && this.m_20159_() && this.m_20202_() != null && !behavior.canVehicleTraverse(livingEntity, this.m_20202_())) {
                    this.m_8127_();
                }
            });
        }
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    public void updateCustomFluid(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo ci) {
        FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.m_204036_((TagKey)tag) == 0.0).forEach(tag -> FluidBehaviorRegistry.doFluidPushing((TagKey<Fluid>)tag, this));
    }

    @ModifyVariable(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidJumpThreshold()D", shift=At.Shift.BEFORE), ordinal=0)
    public boolean modifyInWater(boolean value) {
        return value || FluidBehaviorRegistry.getFluids().stream().anyMatch(tag -> this.m_204036_((TagKey)tag) > 0.0);
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void travelInCustomFluid(Vec3 travelVector, CallbackInfo ci, double fallSpeed) {
        if (this.m_6129_() && !this.m_203441_(this.f_19853_.m_6425_(this.m_142538_()))) {
            FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.m_204036_((TagKey)tag) > 0.0).forEach(tag -> {
                PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((TagKey<Fluid>)tag));
                behavior.applyPhysics((LivingEntity)this, travelVector, fallSpeed, this.m_20184_().f_82480_ <= 0.0);
                ci.cancel();
            });
            if (ci.isCancelled()) {
                this.m_21043_((LivingEntity)this, this instanceof FlyingAnimal);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        TickEvents.LIVING_POST.invoker().tick((LivingEntity)this);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;", shift=At.Shift.BEFORE))
    public double modifyGravity(double gravity) {
        return ModifyGravityEvent.EVENT.invoker().modifyGravity((LivingEntity)this, gravity);
    }
}

