/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.client;

import gg.moonflower.pollen.core.extensions.LevelRendererExtension;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererTicker;
import gg.moonflower.pollen.pinwheel.api.client.render.TickableBlockRenderer;
import gg.moonflower.pollen.pinwheel.core.client.DataContainerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin
extends Level
implements BlockRendererTicker {
    @Shadow
    @Final
    private Minecraft f_104565_;
    @Unique
    private final Map<BlockPos, BlockState> pendingUpdates = new HashMap<BlockPos, BlockState>();
    @Unique
    private final Map<BlockPos, BlockState> updates = new HashMap<BlockPos, BlockState>();
    @Unique
    private final DataContainerImpl dataContainer = new DataContainerImpl((BlockGetter)((ClientLevel)this));

    private ClientLevelMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, Holder<DimensionType> dimensionType, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l) {
        super(writableLevelData, resourceKey, dimensionType, supplier, bl, bl2, l);
    }

    @Override
    public void scheduleBlockRendererTick(BlockPos pos, BlockState state) {
        this.pendingUpdates.put(pos.m_7949_(), state);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.updates.clear();
        this.updates.putAll(this.pendingUpdates);
        this.pendingUpdates.clear();
        this.m_46473_().m_6180_("pollenTickBlockRenderers");
        ((LevelRendererExtension)this.f_104565_.f_91060_).pollen_getTickingBlockRenderers().forEach(pos -> {
            BlockState state = this.m_8055_((BlockPos)pos);
            for (BlockRenderer renderer : BlockRendererRegistry.get(state.m_60734_())) {
                if (!(renderer instanceof TickableBlockRenderer)) continue;
                BlockState oldState = this.updates.remove(pos);
                if (oldState != null) {
                    renderer.receiveUpdate(this, (BlockPos)pos, oldState, state, this.dataContainer.get((BlockPos)pos));
                }
                ((TickableBlockRenderer)renderer).tick(this, (BlockPos)pos, this.dataContainer.get((BlockPos)pos));
            }
        });
        this.m_46473_().m_6182_("pollenUpdateBlockRenderers");
        this.updates.forEach((pos, state) -> {
            List<BlockRenderer> renderers = BlockRendererRegistry.get(state.m_60734_());
            for (BlockRenderer renderer : renderers) {
                renderer.receiveUpdate(this, (BlockPos)pos, (BlockState)state, this.m_8055_((BlockPos)pos), this.dataContainer.get((BlockPos)pos));
            }
        });
        this.m_46473_().m_7238_();
    }
}

