/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix4f;
import gg.moonflower.pollen.api.client.render.PollenDimensionSpecialEffects;
import gg.moonflower.pollen.core.client.render.PollenDimensionRenderContextImpl;
import gg.moonflower.pollen.core.extensions.LevelRendererExtension;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererDispatcher;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin
implements LevelRendererExtension {
    @Shadow
    private int f_109477_;
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;
    @Unique
    private PoseStack captureMatrixStack;
    @Unique
    private float capturePartialTicks;
    @Unique
    private Camera captureCamera;
    @Unique
    private Matrix4f captureProjection;
    @Unique
    private final PollenDimensionSpecialEffects.RenderContext renderContext = new PollenDimensionRenderContextImpl(() -> this.f_109477_, () -> Float.valueOf(this.capturePartialTicks), () -> this.captureCamera, () -> this.f_109465_, () -> this.captureMatrixStack, () -> this.captureProjection);

    @Inject(method={"renderLevel"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;globalBlockEntities:Ljava/util/Set;", shift=At.Shift.BEFORE, ordinal=0)})
    public void renderBlockRenders(PoseStack matrixStack, float partialTicks, long finishTimeNano, boolean drawBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmap, Matrix4f projection, CallbackInfo ci) {
        Vec3 vec3 = camera.m_90583_();
        double x = vec3.m_7096_();
        double y = vec3.m_7098_();
        double z = vec3.m_7094_();
        this.pollen_getBlockRenderers().forEach(pos -> {
            int u;
            BlockState state = this.f_109465_.m_8055_(pos);
            List<BlockRenderer> renderers = BlockRendererRegistry.get(state.m_60734_());
            if (renderers.isEmpty()) {
                return;
            }
            MultiBufferSource.BufferSource buffer = this.f_109464_.m_110104_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)pos.m_123341_() - x, (double)pos.m_123342_() - y, (double)pos.m_123343_() - z);
            SortedSet sortedSet = (SortedSet)this.f_109409_.get(pos.m_121878_());
            if (sortedSet != null && !sortedSet.isEmpty() && (u = ((BlockDestructionProgress)sortedSet.last()).m_139988_()) >= 0) {
                PoseStack.Pose pose = matrixStack.m_85850_();
                SheetedDecalTextureGenerator vertexConsumer = new SheetedDecalTextureGenerator(this.f_109464_.m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(u)), pose.m_85861_(), pose.m_85864_());
                buffer = arg_0 -> this.lambda$renderBlockRenders$6((VertexConsumer)vertexConsumer, arg_0);
            }
            BlockRendererDispatcher.render((LevelReader)this.f_109465_, matrixStack, (MultiBufferSource)buffer, camera, renderers, pos, LevelRenderer.m_109537_((BlockAndTintGetter)this.f_109465_, (BlockState)state, (BlockPos)pos), OverlayTexture.f_118083_, partialTicks);
            matrixStack.m_85849_();
        });
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    public void renderLevel(PoseStack matrixStack, float partialTicks, long finishTimeNano, boolean drawBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmap, Matrix4f projection, CallbackInfo ci) {
        this.captureMatrixStack = matrixStack;
        this.capturePartialTicks = partialTicks;
        this.captureCamera = camera;
        this.captureProjection = projection;
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        PollenDimensionSpecialEffects.Renderer renderer;
        DimensionSpecialEffects specialEffects = this.f_109465_.m_104583_();
        if (specialEffects instanceof PollenDimensionSpecialEffects && (renderer = ((PollenDimensionSpecialEffects)specialEffects).getCloudRenderer()) != null) {
            renderer.render(this.renderContext);
            ci.cancel();
        }
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderSnowAndRain(LightTexture lightmap, float partialTicks, double x, double y, double z, CallbackInfo ci) {
        PollenDimensionSpecialEffects.Renderer renderer;
        DimensionSpecialEffects specialEffects = this.f_109465_.m_104583_();
        if (specialEffects instanceof PollenDimensionSpecialEffects && (renderer = ((PollenDimensionSpecialEffects)specialEffects).getWeatherRenderer()) != null) {
            renderer.render(this.renderContext);
            ci.cancel();
        }
    }

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickRain(Camera camera, CallbackInfo ci) {
        PollenDimensionSpecialEffects.Renderer renderer;
        DimensionSpecialEffects specialEffects = this.f_109465_.m_104583_();
        if (specialEffects instanceof PollenDimensionSpecialEffects && (renderer = ((PollenDimensionSpecialEffects)specialEffects).getWeatherParticleRenderer()) != null) {
            renderer.render(this.renderContext);
            ci.cancel();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderSky(PoseStack poseStack, Matrix4f projectionMatrix, float f, Camera camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        PollenDimensionSpecialEffects.Renderer renderer;
        DimensionSpecialEffects specialEffects = this.f_109465_.m_104583_();
        if (specialEffects instanceof PollenDimensionSpecialEffects && (renderer = ((PollenDimensionSpecialEffects)specialEffects).getSkyRenderer()) != null) {
            renderer.render(this.renderContext);
            ci.cancel();
        }
    }

    private /* synthetic */ VertexConsumer lambda$renderBlockRenders$6(VertexConsumer vertexConsumer, RenderType renderType) {
        VertexConsumer vertexConsumer2 = this.f_109464_.m_110104_().m_6299_(renderType);
        return renderType.m_110405_() ? VertexMultiConsumer.m_86168_((VertexConsumer)vertexConsumer, (VertexConsumer)vertexConsumer2) : vertexConsumer2;
    }
}

