/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.forge.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LiquidBlockRenderer.class})
public class LiquidBlockRendererMixin {
    @Unique
    private final Map<Fluid, TextureAtlasSprite[]> customFluidSprites = new HashMap<Fluid, TextureAtlasSprite[]>();
    @Unique
    private final Map<FluidState, BlockState> fluidStateCache = new WeakHashMap<FluidState, BlockState>();
    @Unique
    private BlockAndTintGetter captureLevel;
    @Unique
    private FluidState captureFluid;
    @Unique
    private BlockPos capturePos;

    @Inject(method={"setupSprites"}, at={@At(value="TAIL")})
    public void setupSprites(CallbackInfo ci) {
        this.customFluidSprites.clear();
        this.fluidStateCache.clear();
        for (Fluid fluid : Registry.f_122822_) {
            if (!(fluid instanceof PollinatedFluid)) continue;
            PollinatedFluid pollinatedFluid = (PollinatedFluid)fluid;
            Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
            this.customFluidSprites.put(fluid, new TextureAtlasSprite[]{(TextureAtlasSprite)atlas.apply(pollinatedFluid.getStillTextureName()), (TextureAtlasSprite)atlas.apply(pollinatedFluid.getFlowingTextureName()), pollinatedFluid.getOverlayTextureName() != null ? (TextureAtlasSprite)atlas.apply(pollinatedFluid.getOverlayTextureName()) : null});
        }
    }

    @Inject(method={"tesselate"}, at={@At(value="HEAD")})
    public void captureFluid(BlockAndTintGetter lightReader, BlockPos pos, VertexConsumer vertexBuilder, BlockState state, FluidState fluidState, CallbackInfoReturnable<Boolean> cir) {
        this.captureLevel = lightReader;
        this.captureFluid = fluidState;
        this.capturePos = pos;
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public boolean modifyIsLava(boolean value) {
        return value || this.customFluidSprites.containsKey(this.captureFluid.m_76152_());
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public TextureAtlasSprite[] modifySprites(TextureAtlasSprite[] value) {
        return this.customFluidSprites.getOrDefault(this.captureFluid.m_76152_(), value);
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public int modifyColor(int value) {
        return this.customFluidSprites.containsKey(this.captureFluid.m_76152_()) ? Minecraft.m_91087_().m_91298_().m_92577_(this.fluidStateCache.computeIfAbsent(this.captureFluid, FluidState::m_76188_), this.captureLevel, this.capturePos, 0) : value;
    }
}

