/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.login;

import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.api.network.packet.login.SimplePollinatedLoginPacket;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import gg.moonflower.pollen.core.network.login.PollenClientLoginPacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundSyncPlayerDataKeysPacket
extends SimplePollinatedLoginPacket<PollenClientLoginPacketHandler> {
    private final Map<ResourceLocation, Integer> mappings;

    public ClientboundSyncPlayerDataKeysPacket() {
        this.mappings = SyncedDataManager.getIds().collect(Collectors.toMap(id -> SyncedDataManager.byId(id).getKey(), id -> id));
    }

    public ClientboundSyncPlayerDataKeysPacket(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        this.mappings = new HashMap<ResourceLocation, Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.mappings.put(buf.m_130281_(), buf.m_130242_());
        }
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130130_(this.mappings.size());
        for (Map.Entry<ResourceLocation, Integer> entry : this.mappings.entrySet()) {
            buf.m_130085_(entry.getKey());
            buf.m_130130_(entry.getValue().intValue());
        }
    }

    @Override
    public void processPacket(PollenClientLoginPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleSyncPlayerDataKeysPacket(this, ctx);
    }

    public Map<ResourceLocation, Integer> getMappings() {
        return this.mappings;
    }
}

