/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.play;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.network.play.PollenClientPlayPacketHandler;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundUpdateSettingsPacket
implements PollinatedPacket<PollenClientPlayPacketHandler> {
    private final UUID player;
    private final String entitlement;
    private final JsonObject settings;

    public ClientboundUpdateSettingsPacket(Player player, String entitlement, JsonObject settings) {
        this.player = player.m_142081_();
        this.entitlement = entitlement;
        this.settings = settings;
    }

    public ClientboundUpdateSettingsPacket(FriendlyByteBuf buf) throws IOException {
        this.player = buf.m_130259_();
        this.entitlement = buf.m_130277_();
        try {
            this.settings = new JsonParser().parse(buf.m_130277_()).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) throws IOException {
        buf.m_130077_(this.player);
        buf.m_130070_(this.entitlement);
        buf.m_130070_(this.settings.toString());
    }

    @Override
    public void processPacket(PollenClientPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleUpdateSettingsPacket(this, ctx);
    }

    public UUID getPlayer() {
        return this.player;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public JsonObject getSettings() {
        return this.settings;
    }
}

