/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.test;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import gg.moonflower.pollen.core.PollenTest;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class TestFluid
extends FlowingFluid
implements PollinatedFluid {
    private static final ResourceLocation STILL = new ResourceLocation("pollen", "block/void");
    private static final ResourceLocation FLOW = new ResourceLocation("pollen", "block/void_flow");

    @Override
    public ResourceLocation getStillTextureName() {
        return STILL;
    }

    @Override
    public ResourceLocation getFlowingTextureName() {
        return FLOW;
    }

    @Override
    public int getFogColor(Camera camera, ClientLevel level, Holder<Biome> biome, float partialTicks) {
        return 921104;
    }

    @Override
    public void applyFog(GameRenderer renderer, Camera camera, float distance, float partialTicks) {
        RenderSystem.m_157443_((float)1.0f);
        RenderSystem.m_157445_((float)0.2f);
    }

    public Fluid m_5615_() {
        return (Fluid)PollenTest.FLOWING_TEST_FLUID.get();
    }

    public Fluid m_5613_() {
        return (Fluid)PollenTest.TEST_FLUID.get();
    }

    public Item m_6859_() {
        return PollenTest.TEST_BUCKET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7450_(Level level, BlockPos pos, FluidState state, Random random) {
    }

    public Optional<SoundEvent> m_142520_() {
        return Optional.of(SoundEvents.f_11783_);
    }

    @Override
    public Optional<SoundEvent> getEmptySound() {
        return Optional.of(SoundEvents.f_11780_);
    }

    protected boolean m_6760_() {
        return true;
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    public int m_6719_(LevelReader level) {
        return 4;
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)PollenTest.TEST.get().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(TestFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == this.m_5613_() || fluid == this.m_5615_();
    }

    public int m_6713_(LevelReader level) {
        return 1;
    }

    public int m_6718_(LevelReader level) {
        return 40;
    }

    public boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.m_205067_(PollenTest.TEST_TAG);
    }

    protected float m_6752_() {
        return 100.0f;
    }

    @Override
    @Nullable
    public BlockState getInteractionState(Level level, FluidState fluidState, BlockPos pos, BlockPos neighborPos) {
        return level.m_8055_(neighborPos).m_60713_(Blocks.f_50090_) ? Blocks.f_50268_.m_49966_() : null;
    }

    public static class Source
    extends TestFluid {
        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends TestFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

