/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import gg.moonflower.pollen.pinwheel.core.client.animation.DeprecatedLocalAnimationLoader;
import gg.moonflower.pollen.pinwheel.core.client.animation.LocalAnimationLoader;
import gg.moonflower.pollen.pinwheel.core.client.util.DynamicReloader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public final class AnimationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Reloader RELOADER = new Reloader();
    private static final DynamicReloader DYNAMIC_RELOADER = new DynamicReloader();
    private static final Set<BackgroundLoader<Map<ResourceLocation, AnimationData>>> LOADERS = new HashSet<BackgroundLoader<Map<ResourceLocation, AnimationData>>>();
    private static final Map<ResourceLocation, AnimationData> ANIMATIONS = new HashMap<ResourceLocation, AnimationData>();

    private AnimationManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        ResourceRegistry.registerReloadListener(PackType.CLIENT_RESOURCES, RELOADER);
        AnimationManager.addLoader(new DeprecatedLocalAnimationLoader());
        AnimationManager.addLoader(new LocalAnimationLoader());
    }

    public static void addLoader(BackgroundLoader<Map<ResourceLocation, AnimationData>> loader) {
        LOADERS.add(loader);
    }

    public static CompletableFuture<?> reload(boolean showLoadingScreen) {
        return DYNAMIC_RELOADER.reload(showLoadingScreen);
    }

    public static AnimationData getAnimation(ResourceLocation location) {
        return ANIMATIONS.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown animation with key '{}'", (Object)location);
            return AnimationData.EMPTY;
        });
    }

    public static boolean isReloading() {
        return DYNAMIC_RELOADER.isReloading();
    }

    static {
        DYNAMIC_RELOADER.addListener(RELOADER);
    }

    private static class Reloader
    implements PollinatedPreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap animationData = new HashMap();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(animationLoader -> animationLoader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(pairs -> {
                for (Map.Entry entry : pairs.entrySet()) {
                    if (animationData.put((ResourceLocation)entry.getKey(), (AnimationData)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate animation: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + animationData.size() + " animations.");
                ANIMATIONS.clear();
                ANIMATIONS.putAll(animationData);
            }, gameExecutor);
        }

        @Override
        public ResourceLocation getPollenId() {
            return new ResourceLocation("pollen", "animation_manager");
        }
    }
}

