/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import gg.moonflower.pollen.api.platform.Platform;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class GeometryCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Path CACHE_FOLDER = Paths.get(Minecraft.m_91087_().f_91069_.toURI()).resolve("pollen-cache");
    private static final Object METADATA_LOCK = new Object();
    private static final Object IO_LOCK = new Object();
    private static final Path CACHE_METADATA_LOCATION = CACHE_FOLDER.resolve("cache.json");
    private static final int METADATA_WRITE_TIME = 5000;
    private static volatile JsonObject CACHE_METADATA = new JsonObject();
    private static volatile long nextWriteTime = Long.MAX_VALUE;

    private GeometryCache() {
    }

    private static synchronized void writeMetadata() {
        LOGGER.debug("Writing cache metadata to file.");
        try (FileOutputStream os = new FileOutputStream(CACHE_METADATA_LOCATION.toFile());){
            if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
            }
            IOUtils.write((String)GSON.toJson((JsonElement)CACHE_METADATA), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write cache metadata", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isCached(String url, @Nullable String hash, Path imageFile) {
        if (!Files.exists(imageFile, new LinkOption[0])) return false;
        if (hash == null) {
            return true;
        }
        String key = DigestUtils.md5Hex((String)url);
        if (CACHE_METADATA.has(key) && CACHE_METADATA.get(key).isJsonPrimitive() && CACHE_METADATA.get(key).getAsJsonPrimitive().isString()) {
            if (hash.equalsIgnoreCase(CACHE_METADATA.get(key).getAsString())) return true;
            if (Platform.isProduction()) return false;
            LOGGER.warn("Hash for '" + url + "' did not match. Expected " + hash + ", got " + CACHE_METADATA.get(key).getAsString());
            return false;
        }
        try (FileInputStream stream = new FileInputStream(imageFile.toFile());){
            String fileCache = DigestUtils.md5Hex((InputStream)stream);
            Object object = METADATA_LOCK;
            synchronized (object) {
                CACHE_METADATA.addProperty(key, fileCache);
                nextWriteTime = System.currentTimeMillis() + 5000L;
            }
            if (!hash.equalsIgnoreCase(fileCache)) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read image '" + url + "'", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Path getPath(String url, @Nullable String hash, Function<String, InputStream> fetcher) {
        Path imageFile = CACHE_FOLDER.resolve(DigestUtils.md5Hex((String)url));
        if (GeometryCache.isCached(url, hash, imageFile)) {
            return imageFile;
        }
        InputStream fetchedStream = fetcher.apply(url);
        if (fetchedStream == null) {
            block21: {
                if (hash == null) {
                    try {
                        Object object;
                        if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                            object = IO_LOCK;
                            synchronized (object) {
                                Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                            }
                        }
                        if (Files.exists(imageFile, new LinkOption[0])) break block21;
                        object = IO_LOCK;
                        synchronized (object) {
                            Files.createFile(imageFile, new FileAttribute[0]);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to create empty file '" + imageFile + "' for '" + url + "'", (Throwable)e);
                    }
                }
            }
            return null;
        }
        try {
            Object e = IO_LOCK;
            synchronized (e) {
                if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                }
                Files.copy(fetchedStream, imageFile, StandardCopyOption.REPLACE_EXISTING);
            }
            e = imageFile;
            return e;
        }
        catch (Exception e) {
            LOGGER.error("Failed to write image '" + url + "' to '" + imageFile + "'", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fetchedStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Path getPath(String url, long timeout, TimeUnit unit, Function<String, InputStream> fetcher) {
        InputStream fetchedStream;
        Path imageFile = CACHE_FOLDER.resolve(DigestUtils.md5Hex((String)url));
        String key = DigestUtils.md5Hex((String)url);
        if (GeometryCache.isCached(url, null, imageFile) && CACHE_METADATA.has(key) && CACHE_METADATA.get(key).isJsonPrimitive() && CACHE_METADATA.get(key).getAsJsonPrimitive().isNumber()) {
            long now = System.currentTimeMillis();
            long expirationDate = CACHE_METADATA.get(key).getAsLong();
            if (expirationDate - now > 0L) {
                return imageFile;
            }
        }
        if ((fetchedStream = fetcher.apply(url)) == null) {
            try {
                Object object;
                if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                    object = IO_LOCK;
                    synchronized (object) {
                        Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                    }
                }
                if (!Files.exists(imageFile, new LinkOption[0])) {
                    object = IO_LOCK;
                    synchronized (object) {
                        Files.createFile(imageFile, new FileAttribute[0]);
                    }
                }
                object = METADATA_LOCK;
                synchronized (object) {
                    CACHE_METADATA.addProperty(key, (Number)(System.currentTimeMillis() + unit.toMillis(timeout)));
                    nextWriteTime = System.currentTimeMillis() + 5000L;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create empty file '" + imageFile + "' for '" + url + "'", (Throwable)e);
            }
            return null;
        }
        try {
            Object e = IO_LOCK;
            synchronized (e) {
                if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                }
                Files.copy(fetchedStream, imageFile, StandardCopyOption.REPLACE_EXISTING);
            }
            e = METADATA_LOCK;
            synchronized (e) {
                CACHE_METADATA.addProperty(key, (Number)(System.currentTimeMillis() + unit.toMillis(timeout)));
                nextWriteTime = System.currentTimeMillis() + 5000L;
            }
            e = imageFile;
            return e;
        }
        catch (Exception e) {
            LOGGER.error("Failed to write image '" + url + "'", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fetchedStream);
        }
        return null;
    }

    static {
        if (Files.exists(CACHE_METADATA_LOCATION, new LinkOption[0])) {
            LOGGER.debug("Reading cache metadata from file.");
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(CACHE_METADATA_LOCATION.toFile()));){
                CACHE_METADATA = new JsonParser().parse((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load cache metadata", (Throwable)e);
            }
        }
        TickEvents.CLIENT_POST.register(() -> {
            if (nextWriteTime == Long.MAX_VALUE) {
                return;
            }
            if (System.currentTimeMillis() - nextWriteTime > 0L) {
                nextWriteTime = Long.MAX_VALUE;
                Util.m_183991_().execute(GeometryCache::writeMetadata);
            }
        });
    }
}

