/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.pollen.core.mixin.client.AgeableListModelAccessor;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BedrockGeometryModel;
import gg.moonflower.pollen.pinwheel.core.client.geometry.JavaModelConverter;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public interface GeometryModel {
    public static final GeometryModel EMPTY = new GeometryModel(){

        @Override
        public void render(String material, GeometryModelTexture texture, PoseStack matrixStack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        }

        @Override
        public void resetTransformation() {
        }

        @Override
        public void copyAngles(@Nullable String parent, ModelPart modelPart) {
        }

        @Override
        public Optional<ModelPart> getModelPart(String part) {
            return Optional.empty();
        }

        @Override
        public ModelPart[] getChildRenderers(String part) {
            return new ModelPart[0];
        }

        @Override
        public ModelPart[] getModelParts() {
            return new ModelPart[0];
        }

        @Override
        public String[] getParentModelKeys() {
            return new String[0];
        }

        @Override
        public String[] getMaterialKeys() {
            return new String[0];
        }

        @Override
        public float getTextureWidth() {
            return 16.0f;
        }

        @Override
        public float getTextureHeight() {
            return 16.0f;
        }
    };

    public static GeometryModel create(GeometryModelData data) {
        return new BedrockGeometryModel(data.getDescription().getTextureWidth(), data.getDescription().getTextureHeight(), data.getBones());
    }

    public static GeometryModel create(int textureWidth, int textureHeight, GeometryModelData.Bone ... bones) {
        return new BedrockGeometryModel(textureWidth, textureHeight, bones);
    }

    public static GeometryModel create(int textureWidth, int textureHeight, ModelPart ... bones) {
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert(bones));
    }

    public static GeometryModel create(int textureWidth, int textureHeight, ListModel<?> model) {
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert((ModelPart[])Iterables.toArray((Iterable)model.m_6195_(), ModelPart.class)));
    }

    public static GeometryModel create(int textureWidth, int textureHeight, AgeableListModel<?> model) {
        AgeableListModelAccessor accessor = (AgeableListModelAccessor)model;
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert((ModelPart[])Iterables.toArray((Iterable)Iterables.concat(accessor.invokeHeadParts(), accessor.invokeBodyParts()), ModelPart.class)));
    }

    public void render(String var1, GeometryModelTexture var2, PoseStack var3, VertexConsumer var4, int var5, int var6, float var7, float var8, float var9, float var10);

    public void resetTransformation();

    public void copyAngles(@Nullable String var1, ModelPart var2);

    public Optional<ModelPart> getModelPart(String var1);

    public ModelPart[] getChildRenderers(String var1);

    public ModelPart[] getModelParts();

    public String[] getParentModelKeys();

    public String[] getMaterialKeys();

    public float getTextureWidth();

    public float getTextureHeight();

    default public VertexConsumer getBuffer(MultiBufferSource buffer, GeometryAtlasTexture atlas, GeometryModelTexture texture, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> renderTypeConsumer) {
        return atlas.getSprite(texture.getLocation()).m_118381_(buffer.m_6299_(texture.getLayer().getRenderType(texture, atlas, renderTypeConsumer)));
    }
}

