/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.google.common.collect.ImmutableMap;
import gg.moonflower.pollen.core.Pollen;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ArmorStandModel;
import net.minecraft.client.model.BatModel;
import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.CodModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.DolphinModel;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EndermiteModel;
import net.minecraft.client.model.EvokerFangsModel;
import net.minecraft.client.model.FoxModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.HoglinModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.LeashKnotModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.LlamaSpitModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.PufferfishBigModel;
import net.minecraft.client.model.PufferfishMidModel;
import net.minecraft.client.model.PufferfishSmallModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.SalmonModel;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.ShulkerBulletModel;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.TropicalFishModelA;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.TurtleModel;
import net.minecraft.client.model.VexModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.ZombieVillagerModel;
import net.minecraft.client.model.dragon.DragonHeadModel;
import net.minecraft.client.model.geom.ModelPart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class VanillaModelMapping {
    private static final Map<Class<? extends Model>, Map<String, String>> MAPPING = new HashMap<Class<? extends Model>, Map<String, String>>();
    private static final Logger LOGGER = LogManager.getLogger();

    private VanillaModelMapping() {
    }

    @ApiStatus.Internal
    public static void load() {
    }

    private static void add(Class<? extends Model> clazz, String ... mapping) {
        ImmutableMap.Builder mappingBuilder = ImmutableMap.builder();
        Field[] fields = (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isSynthetic() && ModelPart.class.isAssignableFrom(field.getType())).toArray(Field[]::new);
        if (Pollen.TESTS_ENABLED && fields.length != mapping.length) {
            throw new IllegalStateException("Incorrect mapping configuration for " + clazz.getName() + ". Expected " + fields.length + " fields, got " + mapping.length);
        }
        for (int i = 0; i < mapping.length; ++i) {
            mappingBuilder.put((Object)mapping[i], (Object)fields[i].getName());
        }
        if (MAPPING.put(clazz, (Map<String, String>)mappingBuilder.build()) != null) {
            throw new RuntimeException("Duplicate mappings for " + clazz.getName());
        }
    }

    @Nullable
    private static String getInternal(Class<? extends Model> clazz, String name) {
        if (!MAPPING.containsKey(clazz)) {
            return null;
        }
        return MAPPING.get(clazz).get(name);
    }

    @Nullable
    public static String get(Class<? extends Model> clazz, String name) {
        Class<? extends Model> parent = clazz;
        while (Model.class.isAssignableFrom(parent)) {
            String field = VanillaModelMapping.getInternal(parent, name);
            if (field != null) {
                return field;
            }
            if (!Model.class.isAssignableFrom(parent.getSuperclass())) break;
            parent = parent.getSuperclass();
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(name, name);
        MAPPING.put(clazz, fields);
        return name;
    }

    static {
        VanillaModelMapping.add(DragonHeadModel.class, "head", "jaw");
        VanillaModelMapping.add(ArmorStandModel.class, "bodyStick1", "bodyStick2", "shoulderStick", "basePlate");
        VanillaModelMapping.add(BatModel.class, "root", "head", "body", "rightWing", "leftWing", "rightWingTip", "leftWingTip");
        VanillaModelMapping.add(BeeModel.class, "bone", "rightWing", "leftWing", "frontLeg", "midLeg", "backLeg", "stinger", "leftAntenna", "rightAntenna");
        VanillaModelMapping.add(BlazeModel.class, "root", "head");
        VanillaModelMapping.add(BoatModel.class, "leftPaddle", "rightPaddle", "waterPatch");
        VanillaModelMapping.add(BookModel.class, "root", "leftLid", "rightLid", "leftPages", "rightPages", "flipPage1", "flipPage2");
        VanillaModelMapping.add(ChestedHorseModel.class, "leftChest", "rightChest");
        VanillaModelMapping.add(ChickenModel.class, "head", "body", "rightLeg", "leftLeg", "rightWing", "leftWing", "beak", "redThing");
        VanillaModelMapping.add(CodModel.class, "root", "tailFin");
        VanillaModelMapping.add(CreeperModel.class, "root", "head", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg");
        VanillaModelMapping.add(DolphinModel.class, "root", "body", "tail", "tailFin");
        VanillaModelMapping.add(ElytraModel.class, "rightWing", "leftWing");
        VanillaModelMapping.add(EndermiteModel.class, "root");
        VanillaModelMapping.add(EvokerFangsModel.class, "root", "base", "upperJaw", "lowerJaw");
        VanillaModelMapping.add(FoxModel.class, "head", "body", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg", "tail");
        VanillaModelMapping.add(GhastModel.class, "root");
        VanillaModelMapping.add(GuardianModel.class, "root", "head", "eye");
        VanillaModelMapping.add(HoglinModel.class, "head", "rightEar", "leftEar", "body", "rightFrontLeg", "leftFrontLeg", "rightHindLeg", "leftHindLeg", "mane");
        VanillaModelMapping.add(HorseModel.class, "body", "headParts", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg", "rightHindBabyLeg", "leftHindBabyLeg", "rightFrontBabyLeg", "leftFrontBabyLeg", "tail");
        VanillaModelMapping.add(HumanoidModel.class, "head", "hat", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
        VanillaModelMapping.add(IllagerModel.class, "root", "head", "hat", "arms", "leftLeg", "rightLeg", "rightArm", "leftArm");
        VanillaModelMapping.add(IronGolemModel.class, "root", "head", "rightArm", "leftArm", "rightLeg", "leftLeg");
        VanillaModelMapping.add(LavaSlimeModel.class, "root");
        VanillaModelMapping.add(LeashKnotModel.class, "root", "knot");
        VanillaModelMapping.add(LlamaModel.class, "head", "body", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg", "rightChest", "leftChest");
        VanillaModelMapping.add(LlamaSpitModel.class, "root");
        VanillaModelMapping.add(MinecartModel.class, "root");
        VanillaModelMapping.add(OcelotModel.class, "leftHindLeg", "rightHindLeg", "leftFrontLeg", "rightFrontLeg", "tail1", "tail2", "head", "body");
        VanillaModelMapping.add(ParrotModel.class, "root", "body", "tail", "leftWing", "rightWing", "head", "feather", "legLeft", "legRight");
        VanillaModelMapping.add(PhantomModel.class, "root", "leftWingBase", "leftWingTip", "rightWingBase", "rightWingTip", "tailBase", "tailTip");
        VanillaModelMapping.add(PiglinModel.class, "rightEar", "leftEar");
        VanillaModelMapping.add(PlayerModel.class, "leftSleeve", "rightSleeve", "leftPants", "rightPants", "jacket", "cloak", "ear");
        VanillaModelMapping.add(PufferfishBigModel.class, "root", "leftBlueFin", "rightBlueFin");
        VanillaModelMapping.add(PufferfishMidModel.class, "root", "leftBlueFin", "rightBlueFin");
        VanillaModelMapping.add(PufferfishSmallModel.class, "root", "leftFin", "rightFin");
        VanillaModelMapping.add(QuadrupedModel.class, "head", "body", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg");
        VanillaModelMapping.add(RabbitModel.class, "leftRearFoot", "rightRearFoot", "leftHaunch", "rightHaunch", "body", "leftFrontLeg", "rightFrontLeg", "head", "rightEar", "leftEar", "tail", "nose");
        VanillaModelMapping.add(RavagerModel.class, "root", "head", "mouth", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg", "neck");
        VanillaModelMapping.add(SalmonModel.class, "root", "bodyBack");
        VanillaModelMapping.add(ShieldModel.class, "root", "plate", "handle");
        VanillaModelMapping.add(ShulkerBulletModel.class, "root", "main");
        VanillaModelMapping.add(ShulkerModel.class, "base", "lid", "head");
        VanillaModelMapping.add(SilverfishModel.class, "root");
        VanillaModelMapping.add(SkullModel.class, "root", "head");
        VanillaModelMapping.add(SlimeModel.class, "root");
        VanillaModelMapping.add(SnowGolemModel.class, "root", "upperBody", "head", "leftArm", "rightArm");
        VanillaModelMapping.add(SpiderModel.class, "root", "head", "rightHindLeg", "leftHindLeg", "rightMiddleHindLeg", "leftMiddleHindLeg", "rightMiddleFrontLeg", "leftMiddleFrontLeg", "rightFrontLeg", "leftFrontLeg");
        VanillaModelMapping.add(SquidModel.class, "root");
        VanillaModelMapping.add(StriderModel.class, "root", "rightLeg", "leftLeg", "body", "rightBottomBristle", "rightMiddleBristle", "rightTopBristle", "leftTopBristle", "leftMiddleBristle", "leftBottomBristle");
        VanillaModelMapping.add(TridentModel.class, "root");
        VanillaModelMapping.add(TropicalFishModelA.class, "root", "tail");
        VanillaModelMapping.add(TropicalFishModelB.class, "root", "tail");
        VanillaModelMapping.add(TurtleModel.class, "eggBelly");
        VanillaModelMapping.add(VexModel.class, "leftWing", "rightWing");
        VanillaModelMapping.add(VillagerModel.class, "root", "head", "hat", "hatRim", "rightLeg", "leftLeg", "nose");
        VanillaModelMapping.add(WitherBossModel.class, "root", "centerHead", "rightHead", "leftHead", "ribcage", "tail");
        VanillaModelMapping.add(WolfModel.class, "head", "realHead", "body", "rightHindLeg", "leftHindLeg", "rightFrontLeg", "leftFrontLeg", "tail", "realTail", "upperBody");
        VanillaModelMapping.add(ZombieVillagerModel.class, "hatRim");
    }
}

