/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.animation;

import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationParser;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocalAnimationLoader
implements BackgroundLoader<Map<ResourceLocation, AnimationData>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String folder;

    public LocalAnimationLoader() {
        this.folder = "pinwheel/animations/";
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, AnimationData>> reload(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, AnimationData> animationData = new HashMap<ResourceLocation, AnimationData>();
            try {
                for (ResourceLocation animationLocation : resourceManager.m_6540_(this.folder, name -> name.endsWith(".json"))) {
                    try {
                        Resource resource = resourceManager.m_142591_(animationLocation);
                        try {
                            AnimationData[] animations;
                            for (AnimationData animation : animations = AnimationParser.parse(new InputStreamReader(resource.m_6679_()))) {
                                ResourceLocation id = new ResourceLocation(animationLocation.m_135827_(), animation.getName());
                                if (animationData.put(id, animation) == null) continue;
                                LOGGER.warn("Duplicate animation: " + id);
                            }
                        }
                        finally {
                            if (resource == null) continue;
                            resource.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load animation: " + animationLocation.m_135827_() + ":" + animationLocation.m_135815_().substring(this.folder.length(), animationLocation.m_135815_().length() - 5), (Throwable)e);
                    }
                }
            }
            catch (ResourceLocationException e) {
                LOGGER.error("Failed to load animations from: " + this.folder, (Throwable)e);
            }
            return animationData;
        }, backgroundExecutor);
    }
}

