/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.geometry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModelPart;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BedrockGeometryModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BoneModelPart
extends ModelPart
implements AnimatedModelPart {
    private static final Vector4f TRANSFORM_VECTOR = new Vector4f();
    private static final Vector3f NORMAL_VECTOR = new Vector3f();
    private final BedrockGeometryModel parent;
    private final GeometryModelData.Bone bone;
    private final Set<BoneModelPart> children;
    private final Map<String, ObjectList<Quad>> quads;
    private final ObjectList<Polygon> polygons;
    private final Matrix4f copyPosition;
    private final Matrix3f copyNormal;
    private final AnimatedModelPart.AnimationPose animationPose;
    private boolean copyVanilla;

    public BoneModelPart(BedrockGeometryModel parent, GeometryModelData.Bone bone) {
        super(Collections.emptyList(), Collections.emptyMap());
        this.parent = parent;
        this.bone = bone;
        this.children = new HashSet<BoneModelPart>();
        this.quads = new Object2ObjectArrayMap();
        this.polygons = new ObjectArrayList();
        this.copyPosition = new Matrix4f();
        this.copyNormal = new Matrix3f();
        this.animationPose = new AnimatedModelPart.AnimationPose();
        this.resetTransform(false);
        Arrays.stream(bone.getCubes()).forEach(this::addCube);
        GeometryModelData.PolyMesh polyMesh = bone.getPolyMesh();
        if (polyMesh != null) {
            this.addPolyMesh(polyMesh);
        }
    }

    private static void addVertex(VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, Matrix4f matrix4f, Vertex vertex) {
        TRANSFORM_VECTOR.m_123602_(vertex.x, vertex.y, vertex.z, 1.0f);
        TRANSFORM_VECTOR.m_123607_(matrix4f);
        builder.m_5954_(TRANSFORM_VECTOR.m_123601_(), TRANSFORM_VECTOR.m_123615_(), TRANSFORM_VECTOR.m_123616_(), red, green, blue, alpha, vertex.u, vertex.v, packedOverlay, packedLight, NORMAL_VECTOR.m_122239_(), NORMAL_VECTOR.m_122260_(), NORMAL_VECTOR.m_122269_());
    }

    private void addCube(GeometryModelData.Cube cube) {
        boolean mirror;
        boolean empty = true;
        for (Direction direction : Direction.values()) {
            if (cube.getUV(direction) == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return;
        }
        Vector3f origin = cube.getOrigin();
        Vector3f size = cube.getSize();
        float x = origin.m_122239_() / 16.0f;
        float y = origin.m_122260_() / 16.0f;
        float z = origin.m_122269_() / 16.0f;
        float sizeX = size.m_122239_() / 16.0f;
        float sizeY = size.m_122260_() / 16.0f;
        float sizeZ = size.m_122269_() / 16.0f;
        float inflate = (cube.isOverrideInflate() ? cube.getInflate() : this.bone.getInflate()) / 16.0f;
        float x1 = x + sizeX;
        float y1 = y + sizeY;
        float z1 = z + sizeZ;
        if ((x -= inflate) == (x1 += inflate) && (y -= inflate) == (y1 += inflate) && (z -= inflate) == (z1 += inflate)) {
            return;
        }
        boolean bl = mirror = cube.isOverrideMirror() ? cube.isMirror() : this.bone.isMirror();
        if (mirror) {
            float f3 = x1;
            x1 = x;
            x = f3;
        }
        Vector3f rotation = cube.getRotation();
        Vector3f pivot = cube.getPivotX();
        float rotationX = rotation.m_122239_();
        float rotationY = rotation.m_122260_();
        float rotationZ = rotation.m_122269_();
        float pivotX = pivot.m_122239_() / 16.0f;
        float pivotY = -pivot.m_122260_() / 16.0f;
        float pivotZ = pivot.m_122269_() / 16.0f;
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_((double)pivotX, (double)pivotY, (double)pivotZ);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(rotationZ));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotationY));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(rotationX));
        matrixStack.m_85837_((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        PoseStack.Pose entry = matrixStack.m_85850_();
        Matrix4f matrix4f = entry.m_85861_();
        Matrix3f matrix3f = entry.m_85864_();
        if (y != y1) {
            if (x != x1) {
                this.addFace(cube, matrix4f, matrix3f, x1, y1, z, x, y1, z, x, y, z, x1, y, z, Direction.NORTH);
                this.addFace(cube, matrix4f, matrix3f, x, y1, z1, x1, y1, z1, x1, y, z1, x, y, z1, Direction.SOUTH);
            }
            if (z != z1) {
                this.addFace(cube, matrix4f, matrix3f, x, y1, z, x, y1, z1, x, y, z1, x, y, z, Direction.EAST);
                this.addFace(cube, matrix4f, matrix3f, x1, y1, z1, x1, y1, z, x1, y, z, x1, y, z1, Direction.WEST);
            }
        }
        if (x != x1 && z != z1) {
            this.addFace(cube, matrix4f, matrix3f, x, y, z1, x1, y, z1, x1, y, z, x, y, z, Direction.DOWN);
            this.addFace(cube, matrix4f, matrix3f, x1, y1, z1, x, y1, z1, x, y1, z, x1, y1, z, Direction.UP);
        }
    }

    private void addPolyMesh(GeometryModelData.PolyMesh polyMesh) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m_27624_();
        for (GeometryModelData.Poly poly : polyMesh.getPolys()) {
            Vertex[] vertices = new Vertex[polyMesh.getPolyType().getVertices()];
            Vector3f[] normals = new Vector3f[polyMesh.getPolyType().getVertices()];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = this.getVertex(polyMesh, poly, matrix4f, i);
                normals[i] = polyMesh.getNormals()[poly.getNormals()[i]].m_122281_();
                normals[i].m_122263_(1.0f, -1.0f, 1.0f);
            }
            this.polygons.add((Object)new Polygon(vertices, normals));
        }
    }

    private Vertex getVertex(GeometryModelData.PolyMesh polyMesh, GeometryModelData.Poly poly, Matrix4f matrix4f, int index) {
        Vector3f position = polyMesh.getPositions()[poly.getPositions()[index]];
        Vec2 uv = polyMesh.getUvs()[poly.getUVs()[index]];
        return new Vertex(matrix4f, position.m_122239_(), -position.m_122260_(), position.m_122269_(), polyMesh.isNormalizedUvs() ? uv.f_82470_ : uv.f_82470_ / this.parent.getTextureWidth(), 1.0f - (polyMesh.isNormalizedUvs() ? uv.f_82471_ : uv.f_82471_ / this.parent.getTextureHeight()));
    }

    private void addFace(GeometryModelData.Cube cube, Matrix4f matrix4f, Matrix3f matrix3f, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, Direction face) {
        GeometryModelData.CubeUV uv = cube.getUV(face);
        if (uv != null) {
            this.quads.computeIfAbsent(uv.getMaterialInstance(), __ -> new ObjectArrayList()).add((Object)new Quad(new Vertex[]{new Vertex(matrix4f, x0, -y0, z0, (uv.getU() + uv.getUSize()) / this.parent.getTextureWidth(), uv.getV() / this.parent.getTextureHeight()), new Vertex(matrix4f, x1, -y1, z1, uv.getU() / this.parent.getTextureWidth(), uv.getV() / this.parent.getTextureHeight()), new Vertex(matrix4f, x2, -y2, z2, uv.getU() / this.parent.getTextureWidth(), (uv.getV() + uv.getVSize()) / this.parent.getTextureHeight()), new Vertex(matrix4f, x3, -y3, z3, (uv.getU() + uv.getUSize()) / this.parent.getTextureWidth(), (uv.getV() + uv.getVSize()) / this.parent.getTextureHeight())}, matrix3f, uv.getMaterialInstance(), cube.isOverrideMirror() ? cube.isMirror() : this.bone.isMirror(), face.m_122424_()));
        }
    }

    void addChild(BoneModelPart part) {
        this.children.add(part);
    }

    public void resetTransform(boolean resetChildren) {
        Vector3f rotation = this.bone.getRotation();
        Vector3f pivot = this.bone.getPivot();
        this.f_104203_ = (float)Math.PI / 180 * rotation.m_122239_();
        this.f_104204_ = (float)Math.PI / 180 * rotation.m_122260_();
        this.f_104205_ = (float)Math.PI / 180 * rotation.m_122269_();
        this.f_104200_ = pivot.m_122239_();
        this.f_104201_ = -pivot.m_122260_();
        this.f_104202_ = pivot.m_122269_();
        this.copyPosition.m_27624_();
        this.copyNormal.m_8180_();
        this.animationPose.reset();
        if (resetChildren) {
            this.children.forEach(boneModelPart -> boneModelPart.resetTransform(true));
        }
        this.copyVanilla = false;
    }

    public void m_104306_(PoseStack matrixStack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_104306_(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
        if (!(!this.f_104207_ || !(alpha > 0.0f) || this.quads.isEmpty() && this.polygons.isEmpty() && this.children.isEmpty())) {
            matrixStack.m_85836_();
            this.m_104299_(matrixStack);
            if (this.copyVanilla) {
                matrixStack.m_85837_((double)(-this.f_104200_ / 16.0f), (double)(-this.f_104201_ / 16.0f), (double)(-this.f_104202_ / 16.0f));
            }
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            Matrix3f matrix3f = matrixStack.m_85850_().m_85864_();
            Collection quads = (Collection)this.quads.get(this.parent.getActiveMaterial());
            if (quads != null) {
                for (Quad quad : quads) {
                    NORMAL_VECTOR.m_122245_(-quad.normal.m_122239_(), quad.normal.m_122260_(), -quad.normal.m_122269_());
                    NORMAL_VECTOR.m_122249_(matrix3f);
                    for (Vertex vertex : quad.vertices) {
                        BoneModelPart.addVertex(builder, packedLight, packedOverlay, red, green, blue, alpha, matrix4f, vertex);
                    }
                }
            }
            if ("poly_mesh.texture".equals(this.parent.getActiveMaterial())) {
                for (Polygon polygon : this.polygons) {
                    for (int i = 0; i < 4; ++i) {
                        int index = Mth.m_14045_((int)i, (int)0, (int)(polygon.vertices.length - 1));
                        Vertex vertex = polygon.vertices[index];
                        Vector3f normal = polygon.normals[index];
                        NORMAL_VECTOR.m_122245_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
                        NORMAL_VECTOR.m_122249_(matrix3f);
                        BoneModelPart.addVertex(builder, packedLight, packedOverlay, red, green, blue, alpha, matrix4f, vertex);
                    }
                }
            }
            for (ModelPart part : this.children) {
                part.m_104306_(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
            }
            matrixStack.m_85849_();
        }
    }

    public void m_104315_(ModelPart part) {
        this.copyPosition.m_27624_();
        this.copyNormal.m_8180_();
        PoseStack matrixStack = new PoseStack();
        part.m_104299_(matrixStack);
        this.copyPosition.m_27644_(matrixStack.m_85850_().m_85861_());
        this.copyNormal.m_8178_(matrixStack.m_85850_().m_85864_());
        this.copyVanilla = !BoneModelPart.class.isAssignableFrom(part.getClass());
    }

    public void m_104299_(PoseStack matrixStack) {
        matrixStack.m_85850_().m_85861_().m_27644_(this.copyPosition);
        matrixStack.m_85850_().m_85864_().m_8178_(this.copyNormal);
        matrixStack.m_85837_((double)((this.animationPose.getPosition().m_122239_() + this.f_104200_) / 16.0f), (double)((-this.animationPose.getPosition().m_122260_() + this.f_104201_) / 16.0f), (double)((this.animationPose.getPosition().m_122269_() + this.f_104202_) / 16.0f));
        if (this.animationPose.getScale().hashCode() != 1333788672) {
            matrixStack.m_85841_(this.animationPose.getScale().m_122239_(), this.animationPose.getScale().m_122260_(), this.animationPose.getScale().m_122269_());
        }
        if (this.f_104205_ + this.animationPose.getRotation().m_122269_() != 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122227_.m_122270_(this.f_104205_ + (float)((double)(this.animationPose.getRotation().m_122269_() / 180.0f) * Math.PI)));
        }
        if (this.f_104204_ + this.animationPose.getRotation().m_122260_() != 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(this.f_104204_ + (float)((double)(this.animationPose.getRotation().m_122260_() / 180.0f) * Math.PI)));
        }
        if (this.f_104203_ + this.animationPose.getRotation().m_122239_() != 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122270_(this.f_104203_ + (float)((double)(this.animationPose.getRotation().m_122239_() / 180.0f) * Math.PI)));
        }
        matrixStack.m_85837_((double)(-this.f_104200_ / 16.0f), (double)(-this.f_104201_ / 16.0f), (double)(-this.f_104202_ / 16.0f));
    }

    public GeometryModelData.Bone getBone() {
        return this.bone;
    }

    @Override
    public AnimatedModelPart.AnimationPose getAnimationPose() {
        return this.animationPose;
    }

    @Override
    public GeometryModelData.Locator[] getLocators() {
        return this.bone.getLocators();
    }

    private static class Vertex {
        private final float x;
        private final float y;
        private final float z;
        private final float u;
        private final float v;

        private Vertex(Matrix4f matrix4f, float x, float y, float z, float u, float v) {
            TRANSFORM_VECTOR.m_123602_(x, y, z, 1.0f);
            TRANSFORM_VECTOR.m_123607_(matrix4f);
            this.x = TRANSFORM_VECTOR.m_123601_();
            this.y = TRANSFORM_VECTOR.m_123615_();
            this.z = TRANSFORM_VECTOR.m_123616_();
            this.u = u;
            this.v = v;
        }
    }

    private static class Polygon {
        private final Vertex[] vertices;
        private final Vector3f[] normals;

        public Polygon(Vertex[] vertices, Vector3f[] normals) {
            this.vertices = vertices;
            this.normals = normals;
        }
    }

    private static class Quad {
        private final Vertex[] vertices;
        private final Vector3f normal;
        private final String material;

        public Quad(Vertex[] vertices, Matrix3f normal, String material, boolean mirror, Direction direction) {
            this.vertices = vertices;
            this.material = material;
            if (mirror) {
                int i = vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex vertex = vertices[j];
                    vertices[j] = vertices[i - 1 - j];
                    vertices[i - 1 - j] = vertex;
                }
            }
            this.normal = direction.m_122432_();
            if (mirror) {
                this.normal.m_122263_(-1.0f, 1.0f, 1.0f);
            }
            this.normal.m_122249_(normal);
        }
    }
}

