/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.texture;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.pinwheel.api.client.FileCache;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GeometryTextureSpriteUploader
extends SimplePreparableReloadListener<TextureAtlas.Preparations>
implements GeometryAtlasTexture,
AutoCloseable {
    public static final ResourceLocation ATLAS_LOCATION = new ResourceLocation("pollen", "textures/atlas/geometry.png");
    private static final Logger LOGGER = LogManager.getLogger();
    private final TextureAtlas textureAtlas = new TextureAtlas(ATLAS_LOCATION);
    private final Set<GeometryModelTexture> textures = new HashSet<GeometryModelTexture>();
    private String[] hashTables = new String[0];

    public GeometryTextureSpriteUploader(TextureManager textureManager) {
        textureManager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    private void beginStitch(long startTime, Stopwatch stopwatch) {
        stopwatch.start();
    }

    private void endStitch(Stopwatch stopwatch) {
        stopwatch.stop();
        LOGGER.debug("Took " + stopwatch + " to process " + this.textures.size() + " geometry textures");
    }

    @Override
    public ResourceLocation getAtlasLocation() {
        return ATLAS_LOCATION;
    }

    @Override
    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.textureAtlas.m_118316_(location);
    }

    protected TextureAtlas.Preparations prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        try (OnlineRepository onlineRepository = new OnlineRepository(this.hashTables);){
            profiler.m_7242_();
            profiler.m_6180_("stitching");
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            this.beginStitch(System.currentTimeMillis(), stopwatch);
            TextureAtlas.Preparations sheetData = this.textureAtlas.m_118307_((ResourceManager)new OnlineResourceManager(resourceManager, onlineRepository, this.textures.stream().filter(texture -> texture.getType() == GeometryModelTexture.Type.ONLINE).collect(Collectors.toSet())), this.textures.stream().filter(texture -> texture.getType() == GeometryModelTexture.Type.LOCATION || texture.getType() == GeometryModelTexture.Type.ONLINE).map(GeometryModelTexture::getLocation).distinct(), profiler, Minecraft.m_91087_().f_91066_.f_92027_);
            this.endStitch(stopwatch);
            profiler.m_7238_();
            profiler.m_7241_();
            TextureAtlas.Preparations preparations = sheetData;
            return preparations;
        }
    }

    protected void apply(TextureAtlas.Preparations sheetData, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("upload");
        this.textureAtlas.m_118312_(sheetData);
        profiler.m_7238_();
        profiler.m_7241_();
    }

    @Override
    public void close() {
        this.textureAtlas.m_118329_();
    }

    public GeometryTextureSpriteUploader setTextures(Map<ResourceLocation, GeometryModelTextureTable> textures, String[] hashTables) {
        this.textures.clear();
        this.textures.addAll(textures.values().stream().flatMap(table -> table.getTextures().stream().flatMap(Arrays::stream)).collect(Collectors.toSet()));
        this.hashTables = hashTables;
        return this;
    }

    private static class OnlineRepository
    implements AutoCloseable {
        private final ExecutorService executor = FileCache.createOnlineWorker();
        private final FileCache hashedCache;
        private final FileCache cache;
        private final Map<String, CompletableFuture<Path>> resources;

        private OnlineRepository(String[] hashTableUrls) {
            this.hashedCache = FileCache.hashed(this.executor, hashTableUrls);
            this.cache = FileCache.timed(this.executor, 1L, TimeUnit.DAYS);
            this.resources = new HashMap<String, CompletableFuture<Path>>();
        }

        public CompletableFuture<Path> requestResource(String url, boolean cache, boolean ignoreMissing) {
            return this.resources.computeIfAbsent(url, key -> cache ? this.hashedCache.requestResource(url, ignoreMissing) : this.cache.requestResource(url, ignoreMissing));
        }

        @Override
        public void close() {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Took more than 10 seconds to terminate online worker");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to terminate online worker", (Throwable)e);
            }
        }
    }

    private static class OnlineResourceManager
    implements ResourceManager {
        private final ResourceManager parent;
        private final OnlineRepository repository;
        private final Set<String> uncached;
        private final Map<String, Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>>> onlineLocations;

        private OnlineResourceManager(ResourceManager parent, OnlineRepository repository, Set<GeometryModelTexture> onlineTextures) {
            this.parent = parent;
            this.repository = repository;
            this.uncached = onlineTextures.stream().filter(texture -> !texture.canCache()).map(GeometryModelTexture::getData).collect(Collectors.toSet());
            this.onlineLocations = onlineTextures.stream().map(GeometryModelTexture::getData).distinct().collect(Collectors.toMap(url -> url, this::updateCache));
        }

        @Nullable
        private static String parseUrl(ResourceLocation location) {
            String[] parts = location.m_135815_().split("/");
            if (parts[parts.length - 1].startsWith("base32")) {
                return new String(new Base32().decode(parts[parts.length - 1].substring(6).toUpperCase(Locale.ROOT).replaceAll("_", "=")));
            }
            return null;
        }

        @Nullable
        private static InputStream read(CompletableFuture<Path> pathFuture) {
            try {
                Path path = pathFuture.join();
                return path == null ? null : new FileInputStream(path.toFile());
            }
            catch (Exception e) {
                LOGGER.error("Took too long to fetch texture data", (Throwable)e);
                return null;
            }
        }

        private Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>> updateCache(String url) {
            String extension = FilenameUtils.getExtension((String)url);
            String[] urlParts = url.split("." + extension);
            String metadataUrl = urlParts.length <= 1 ? url + ".mcmeta" : urlParts[0] + extension + ".mcmeta" + urlParts[1];
            CompletableFuture<Path> texturePath = this.repository.requestResource(url, !this.uncached.contains(url), false);
            CompletionStage metadataPath = this.repository.requestResource(metadataUrl, false, true).thenApplyAsync(path -> {
                JsonObject jsonObject;
                InputStream stream = OnlineResourceManager.read(CompletableFuture.completedFuture(path));
                if (stream == null) {
                    return null;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    jsonObject = GsonHelper.m_13859_((Reader)bufferedreader);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                bufferedreader.close();
                return jsonObject;
            }, (Executor)Util.m_183992_());
            return Pair.of(texturePath, (Object)metadataPath);
        }

        public Set<String> m_7187_() {
            return this.parent.m_7187_();
        }

        public Resource m_142591_(ResourceLocation resourceLocation) throws IOException {
            String url = OnlineResourceManager.parseUrl(new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().substring(9, resourceLocation.m_135815_().length() - 4)));
            if (url != null) {
                if (!this.onlineLocations.containsKey(url)) {
                    throw new IOException("Failed to fetch texture data from '" + url + "'");
                }
                Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>> files = this.onlineLocations.get(url);
                InputStream textureStream = OnlineResourceManager.read((CompletableFuture)files.getLeft());
                if (textureStream == null) {
                    throw new IOException("Failed to fetch texture data from '" + url + "'");
                }
                return new OnlineResource(url, resourceLocation, textureStream, (JsonObject)((CompletableFuture)files.getRight()).join());
            }
            return this.parent.m_142591_(resourceLocation);
        }

        public boolean m_7165_(ResourceLocation resourceLocation) {
            return resourceLocation.m_135815_().startsWith("base32") || this.parent.m_7165_(resourceLocation);
        }

        public List<Resource> m_7396_(ResourceLocation resourceLocation) throws IOException {
            return this.parent.m_7396_(resourceLocation);
        }

        public Collection<ResourceLocation> m_6540_(String path, Predicate<String> filter) {
            return this.parent.m_6540_(path, filter);
        }

        public Stream<PackResources> m_7536_() {
            return this.parent.m_7536_();
        }

        private static class OnlineResource
        implements Resource {
            private final String url;
            private final ResourceLocation textureLocation;
            private final InputStream stream;
            private final JsonObject metadataJson;

            private OnlineResource(String url, ResourceLocation textureLocation, InputStream stream, @Nullable JsonObject metadataJson) {
                this.url = url;
                this.textureLocation = textureLocation;
                this.stream = stream;
                this.metadataJson = metadataJson;
            }

            public ResourceLocation m_7843_() {
                return this.textureLocation;
            }

            public InputStream m_6679_() {
                return this.stream;
            }

            public boolean m_142564_() {
                return this.metadataJson != null;
            }

            @Nullable
            public <T> T m_5507_(MetadataSectionSerializer<T> serializer) {
                if (this.metadataJson == null) {
                    return null;
                }
                String s = serializer.m_7991_();
                return (T)(this.metadataJson.has(s) ? serializer.m_6322_(GsonHelper.m_13930_((JsonObject)this.metadataJson, (String)s)) : null);
            }

            public String m_7816_() {
                return "pollen_online";
            }

            public void close() throws IOException {
                this.stream.close();
            }

            public String toString() {
                return "OnlineResource{url='" + this.url + "', textureLocation=" + this.textureLocation + "}";
            }
        }
    }
}

