/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.common.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.math.Vector3f;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Geometry110Parser {
    private Geometry110Parser() {
    }

    public static GeometryModelData[] parseModel(JsonElement json) throws JsonParseException {
        GeometryModelData[] geometryModelDataArray;
        JsonObject jsonObject = json.getAsJsonObject();
        GeometryModelData data = null;
        for (Map.Entry entry : jsonObject.entrySet()) {
            GeometryModelData.Bone[] bones;
            if (!((String)entry.getKey()).startsWith("geometry.")) continue;
            if (data != null) {
                throw new JsonSyntaxException("1.8.0 does not allow multiple geometry definitions per file.");
            }
            JsonObject object = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
            GeometryModelData.Description description = Geometry110Parser.parseDescription(((String)entry.getKey()).substring(9), object);
            if (object.has("bones")) {
                HashSet<String> usedNames = new HashSet<String>();
                JsonArray bonesJson = GsonHelper.m_13933_((JsonObject)object, (String)"bones");
                bones = new GeometryModelData.Bone[bonesJson.size()];
                for (int j = 0; j < bones.length; ++j) {
                    bones[j] = Geometry110Parser.parseBone(GsonHelper.m_13918_((JsonElement)bonesJson.get(j), (String)("bones[" + j + "]")));
                    if (usedNames.add(bones[j].getName())) continue;
                    throw new JsonSyntaxException("Duplicate bone: " + bones[j].getName());
                }
            } else {
                bones = new GeometryModelData.Bone[]{};
            }
            data = new GeometryModelData(description, bones);
        }
        if (data != null) {
            GeometryModelData[] geometryModelDataArray2 = new GeometryModelData[1];
            geometryModelDataArray = geometryModelDataArray2;
            geometryModelDataArray2[0] = data;
        } else {
            geometryModelDataArray = new GeometryModelData[]{};
        }
        return geometryModelDataArray;
    }

    private static GeometryModelData.Description parseDescription(String identifier, JsonObject json) throws JsonParseException {
        float visibleBoundsWidth = GsonHelper.m_13820_((JsonObject)json, (String)"visible_bounds_width", (float)0.0f);
        float visibleBoundsHeight = GsonHelper.m_13820_((JsonObject)json, (String)"visible_bounds_height", (float)0.0f);
        float[] visibleBoundsOffset = JSONTupleParser.getFloat(json, "visible_bounds_offset", 3, () -> new float[3]);
        int textureWidth = GsonHelper.m_13824_((JsonObject)json, (String)"texturewidth", (int)256);
        int textureHeight = GsonHelper.m_13824_((JsonObject)json, (String)"textureheight", (int)256);
        boolean preserveModelPose2588 = GsonHelper.m_13855_((JsonObject)json, (String)"preserve_model_pose", (boolean)false);
        if (textureWidth == 0) {
            throw new JsonSyntaxException("Texture width must not be zero");
        }
        if (textureHeight == 0) {
            throw new JsonSyntaxException("Texture height must not be zero");
        }
        return new GeometryModelData.Description(identifier, visibleBoundsWidth, visibleBoundsHeight, new Vector3f(visibleBoundsOffset[0], visibleBoundsOffset[1], visibleBoundsOffset[2]), textureWidth, textureHeight, preserveModelPose2588);
    }

    private static GeometryModelData.Bone parseBone(JsonObject json) throws JsonParseException {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        boolean reset2588 = GsonHelper.m_13855_((JsonObject)json, (String)"reset", (boolean)false);
        boolean neverRender2588 = GsonHelper.m_13855_((JsonObject)json, (String)"neverrender", (boolean)false);
        String parent = GsonHelper.m_13851_((JsonObject)json, (String)"parent", null);
        float[] pivot = JSONTupleParser.getFloat(json, "pivot", 3, () -> new float[3]);
        float[] rotation = JSONTupleParser.getFloat(json, "rotation", 3, () -> new float[3]);
        boolean mirror = GsonHelper.m_13855_((JsonObject)json, (String)"mirror", (boolean)false);
        float inflate = GsonHelper.m_13820_((JsonObject)json, (String)"inflate", (float)0.0f);
        boolean debug = GsonHelper.m_13855_((JsonObject)json, (String)"debug", (boolean)false);
        GeometryModelData.Cube[] cubes = json.has("cubes") ? Geometry110Parser.parseCubes(json) : new GeometryModelData.Cube[]{};
        GeometryModelData.Locator[] locators = json.has("locators") ? Geometry110Parser.parseLocators(json) : new GeometryModelData.Locator[]{};
        return new GeometryModelData.Bone(name, reset2588, neverRender2588, parent, new Vector3f(pivot[0], pivot[1], pivot[2]), new Vector3f(rotation[0], rotation[1], rotation[2]), new Vector3f(), mirror, inflate, debug, cubes, locators, null);
    }

    private static GeometryModelData.Cube[] parseCubes(JsonObject json) {
        JsonArray cubesJson = GsonHelper.m_13933_((JsonObject)json, (String)"cubes");
        GeometryModelData.Cube[] cubes = new GeometryModelData.Cube[cubesJson.size()];
        for (int i = 0; i < cubesJson.size(); ++i) {
            cubes[i] = Geometry110Parser.parseCube(GsonHelper.m_13918_((JsonElement)cubesJson.get(i), (String)("cubes[" + i + "]")));
        }
        return cubes;
    }

    static GeometryModelData.Locator[] parseLocators(JsonObject json) {
        JsonObject locatorsJson = GsonHelper.m_13930_((JsonObject)json, (String)"locators");
        return (GeometryModelData.Locator[])locatorsJson.entrySet().stream().map(entry -> {
            String locatorIdentifier = (String)entry.getKey();
            float[] locatorPosition = JSONTupleParser.getFloat(locatorsJson, locatorIdentifier, 3, () -> new float[3]);
            return new GeometryModelData.Locator(locatorIdentifier, new Vector3f(locatorPosition[0], locatorPosition[1], locatorPosition[2]));
        }).toArray(GeometryModelData.Locator[]::new);
    }

    private static GeometryModelData.Cube parseCube(JsonObject json) throws JsonParseException {
        JsonObject cubeJson = json.getAsJsonObject();
        float[] origin = JSONTupleParser.getFloat(cubeJson, "origin", 3, () -> new float[3]);
        float[] size = JSONTupleParser.getFloat(cubeJson, "size", 3, () -> new float[3]);
        float[] rotation = JSONTupleParser.getFloat(cubeJson, "rotation", 3, () -> new float[3]);
        float[] pivot = JSONTupleParser.getFloat(cubeJson, "pivot", 3, () -> new float[]{origin[0] + size[0] / 2.0f, origin[1] + size[1] / 2.0f, origin[2] + size[2] / 2.0f});
        boolean overrideInflate = cubeJson.has("inflate");
        float inflate = GsonHelper.m_13820_((JsonObject)cubeJson, (String)"inflate", (float)0.0f);
        boolean overrideMirror = cubeJson.has("mirror");
        boolean mirror = GsonHelper.m_13855_((JsonObject)cubeJson, (String)"mirror", (boolean)false);
        GeometryModelData.CubeUV[] uv = Geometry110Parser.parseUV(cubeJson, size);
        if (uv.length != Direction.values().length) {
            throw new JsonParseException("Expected uv to be of size " + Direction.values().length + ", was " + uv.length);
        }
        return new GeometryModelData.Cube(new Vector3f(origin[0], origin[1], origin[2]), new Vector3f(size[0], size[1], size[2]), new Vector3f(rotation[0], rotation[1], rotation[2]), new Vector3f(pivot[0], pivot[1], pivot[2]), overrideInflate, inflate, overrideMirror, mirror, uv);
    }

    static GeometryModelData.CubeUV[] parseUV(JsonObject cubeJson, float[] size) {
        if (!cubeJson.has("uv")) {
            return new GeometryModelData.CubeUV[6];
        }
        GeometryModelData.CubeUV[] uvs = new GeometryModelData.CubeUV[6];
        float[] uv = JSONTupleParser.getFloat(cubeJson, "uv", 2, () -> new float[2]);
        uvs[Direction.NORTH.m_122411_()] = new GeometryModelData.CubeUV(uv[0] + size[2], uv[1] + size[2], size[0], size[1], "texture");
        uvs[Direction.EAST.m_122411_()] = new GeometryModelData.CubeUV(uv[0], uv[1] + size[2], size[2], size[1], "texture");
        uvs[Direction.SOUTH.m_122411_()] = new GeometryModelData.CubeUV(uv[0] + size[0] + size[2] * 2.0f, uv[1] + size[2], size[0], size[1], "texture");
        uvs[Direction.WEST.m_122411_()] = new GeometryModelData.CubeUV(uv[0] + size[0] + size[2], uv[1] + size[2], size[2], size[1], "texture");
        uvs[Direction.UP.m_122411_()] = new GeometryModelData.CubeUV(uv[0] + size[2], uv[1], size[0], size[2], "texture");
        uvs[Direction.DOWN.m_122411_()] = new GeometryModelData.CubeUV(uv[0] + size[0] + size[2], uv[1], size[0], size[2], "texture");
        return uvs;
    }
}

