/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.magnetsystem;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.addons.oddities.block.be.MagnetBlockEntity;
import vazkii.quark.addons.oddities.magnetsystem.DefaultMoveActions;
import vazkii.quark.addons.oddities.module.MagnetsModule;
import vazkii.quark.api.IMagnetMoveAction;
import vazkii.quark.api.IMagnetTracker;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.ModuleLoader;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="quark")
public class MagnetSystem {
    private static final HashSet<Block> magnetizableBlocks = new HashSet();
    private static final HashMap<Block, IMagnetMoveAction> BLOCK_MOVE_ACTIONS = new HashMap();

    public static IMagnetMoveAction getMoveAction(Block block) {
        return BLOCK_MOVE_ACTIONS.get(block);
    }

    public static LazyOptional<IMagnetTracker> getCapability(Level world) {
        return world.getCapability(QuarkCapabilities.MAGNET_TRACKER_CAPABILITY);
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(MagnetsModule.class)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            MagnetSystem.getCapability(event.world).ifPresent(IMagnetTracker::clear);
        } else {
            if (magnetizableBlocks.isEmpty()) {
                MagnetSystem.loadMagnetizableBlocks(event.world);
            }
            MagnetSystem.getCapability(event.world).ifPresent(magnetTracker -> {
                for (BlockPos pos : magnetTracker.getTrackedPositions()) {
                    magnetTracker.actOnForces(pos);
                }
                magnetTracker.clear();
            });
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void tick(TickEvent.ClientTickEvent event) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(MagnetsModule.class)) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            magnetizableBlocks.clear();
        }
    }

    public static void applyForce(Level world, BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        MagnetSystem.getCapability(world).ifPresent(magnetTracker -> magnetTracker.applyForce(pos, magnitude, pushing, dir, distance, origin));
    }

    public static PushReaction getPushAction(MagnetBlockEntity magnet, BlockPos pos, BlockState state, Direction moveDir) {
        Level world = magnet.m_58904_();
        if (world != null && MagnetSystem.isBlockMagnetic(state)) {
            BlockPos targetLocation = pos.m_142300_(moveDir);
            BlockState stateAtTarget = world.m_8055_(targetLocation);
            if (stateAtTarget.m_60795_()) {
                return PushReaction.IGNORE;
            }
            if (stateAtTarget.m_60811_() == PushReaction.DESTROY) {
                return PushReaction.DESTROY;
            }
        }
        return PushReaction.BLOCK;
    }

    public static boolean isBlockMagnetic(BlockState state) {
        Block block = state.m_60734_();
        if ((block == Blocks.f_50039_ || block == Blocks.f_50032_) && ((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
            return false;
        }
        return block != MagnetsModule.magnet && (magnetizableBlocks.contains(block) || BLOCK_MOVE_ACTIONS.containsKey(block) || block instanceof IMagnetMoveAction);
    }

    private static void loadMagnetizableBlocks(Level world) {
        RecipeManager manager = world.m_7465_();
        if (!manager.m_44051_().isEmpty()) {
            Collection recipes = manager.m_44051_();
            HashMultimap recipeDigestion = HashMultimap.create();
            for (Recipe recipe : recipes) {
                if (recipe == null || recipe.m_8043_() == null || recipe.m_7527_() == null) continue;
                Item out = recipe.m_8043_().m_41720_();
                NonNullList ingredients = recipe.m_7527_();
                for (Ingredient ingredient : ingredients) {
                    for (ItemStack inStack : ingredient.m_43908_()) {
                        recipeDigestion.put((Object)inStack.m_41720_(), (Object)out);
                    }
                }
            }
            List magneticDerivationList = MiscUtil.massRegistryGet(MagnetsModule.magneticDerivationList, ForgeRegistries.ITEMS);
            List magneticWhitelist = MiscUtil.massRegistryGet(MagnetsModule.magneticWhitelist, ForgeRegistries.ITEMS);
            List magneticBlacklist = MiscUtil.massRegistryGet(MagnetsModule.magneticBlacklist, ForgeRegistries.ITEMS);
            Streams.concat((Stream[])new Stream[]{magneticDerivationList.stream(), magneticWhitelist.stream()}).filter(i -> i instanceof BlockItem).map(i -> ((BlockItem)i).m_40614_()).forEach(magnetizableBlocks::add);
            HashSet scanned = Sets.newHashSet(magneticDerivationList);
            ArrayList magnetizableToScan = Lists.newArrayList(magneticDerivationList);
            while (!magnetizableToScan.isEmpty()) {
                Item scan = (Item)magnetizableToScan.remove(0);
                if (!recipeDigestion.containsKey((Object)scan)) continue;
                for (Item candidate : recipeDigestion.get((Object)scan)) {
                    if (scanned.contains(candidate)) continue;
                    scanned.add(candidate);
                    magnetizableToScan.add(candidate);
                    if (!(candidate instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)candidate;
                    if (magneticBlacklist.contains(candidate)) continue;
                    magnetizableBlocks.add(blockItem.m_40614_());
                }
            }
        }
    }

    static {
        DefaultMoveActions.addActions(BLOCK_MOVE_ACTIONS);
    }
}

