/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi;

import com.google.common.collect.Lists;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiResourcePackSource;
import com.yungnickyoung.minecraft.paxi.mixin.accessor.FolderRepositorySourceAccessor;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public class PaxiFileResourcePackProvider
extends FolderRepositorySource {
    private static final FileFilter PACK_FILTER = file -> {
        boolean isValidPackZip = file.isFile() && file.getName().endsWith(".zip");
        boolean isValidPackFolder = file.isDirectory() && new File(file, "pack.mcmeta").isFile();
        return isValidPackZip || isValidPackFolder;
    };
    private File ordering;
    public List<String> orderedPaxiPacks = new ArrayList<String>();

    public PaxiFileResourcePackProvider(File packsFolder, File ordering) {
        super(packsFolder, PaxiResourcePackSource.PACK_SOURCE_PAXI);
        this.ordering = ordering;
    }

    public PaxiFileResourcePackProvider(File packsFolder) {
        super(packsFolder, PaxiResourcePackSource.PACK_SOURCE_PAXI);
    }

    public void m_7686_(Consumer<Pack> profileAdder, Pack.PackConstructor factory) {
        File[] packs;
        if (!((FolderRepositorySourceAccessor)((Object)this)).getFolder().isDirectory()) {
            ((FolderRepositorySourceAccessor)((Object)this)).getFolder().mkdirs();
        }
        if (this.ordering != null && !this.ordering.isFile()) {
            PackOrdering emptyPackOrdering = new PackOrdering(new String[0]);
            try {
                JSON.createJsonFileFromObject((Path)this.ordering.toPath(), (Object)emptyPackOrdering);
            }
            catch (IOException e) {
                PaxiCommon.LOGGER.error("Unable to create default pack ordering file! This shouldn't happen.");
                PaxiCommon.LOGGER.error(e.toString());
            }
        }
        if ((packs = this.loadPacksFromFiles()) != null) {
            for (File file : packs) {
                String packName = file.getName();
                Pack resourcePackProfile = Pack.m_10430_((String)packName, (boolean)true, this.createResourcePack(file), (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.TOP, (PackSource)PaxiResourcePackSource.PACK_SOURCE_PAXI);
                if (resourcePackProfile == null) continue;
                profileAdder.accept(resourcePackProfile);
            }
        }
    }

    private File[] loadPacksFromFiles() {
        if (this.ordering != null) {
            PackOrdering packOrdering = null;
            try {
                packOrdering = (PackOrdering)JSON.loadObjectFromJsonFile((Path)this.ordering.toPath(), PackOrdering.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                PaxiCommon.LOGGER.error("Error loading Paxi datapack datapack_load_order.json file: {}", (Object)e.toString());
            }
            if (packOrdering == null) {
                PaxiCommon.LOGGER.error("Unable to load datapack_load_order.json! Is it proper JSON formatting? Ignoring load order...");
                return ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
            }
            if (packOrdering.getOrderedPackNames() == null) {
                PaxiCommon.LOGGER.error("Unable to find entry with name 'loadOrder' in datapack_load_order.json! Ignoring load order...");
                return ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
            }
            List<File> orderedPacks = this.filesFromNames(packOrdering.getOrderedPackNames(), PACK_FILTER);
            orderedPacks.forEach(file -> this.orderedPaxiPacks.add(file.getName()));
            File[] allPacks = ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
            ArrayList leftoverPacks = allPacks == null ? Lists.newArrayList() : Arrays.stream(allPacks).filter(file -> !orderedPacks.contains(file)).collect(Collectors.toList());
            return (File[])Stream.of(orderedPacks, leftoverPacks).flatMap(Collection::stream).toArray(File[]::new);
        }
        return ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
    }

    private List<File> filesFromNames(String[] packFileNames, FileFilter filter) {
        ArrayList<File> packFiles = new ArrayList<File>();
        for (String fileName : packFileNames) {
            File packFile = new File(((FolderRepositorySourceAccessor)((Object)this)).getFolder(), fileName);
            if (!packFile.exists()) {
                PaxiCommon.LOGGER.error("Unable to find pack with name {} specified in datapack_load_order.json! Skipping...", (Object)fileName);
                continue;
            }
            if (filter != null && !filter.accept(packFile)) continue;
            packFiles.add(packFile);
        }
        return packFiles;
    }

    private Supplier<PackResources> createResourcePack(File file) {
        return file.isDirectory() ? () -> new FolderPackResources(file) : () -> new FilePackResources(file);
    }

    private static class PackOrdering {
        @SerializedName(value="loadOrder")
        private String[] orderedPackNames;

        public PackOrdering(String[] orderedPackNames) {
            this.orderedPackNames = orderedPackNames;
        }

        public String[] getOrderedPackNames() {
            return this.orderedPackNames;
        }
    }
}

