/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.mojang.datafixers.util.Pair;
import com.stal111.valhelsia_structures.common.block.DungeonDoorLeafBlock;
import com.stal111.valhelsia_structures.common.block.entity.DungeonDoorBlockEntity;
import com.stal111.valhelsia_structures.common.block.properties.DungeonDoorPart;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.core.init.ModBlockEntities;
import com.stal111.valhelsia_structures.core.init.ModBlocks;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class DungeonDoorBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DungeonDoorPart> PART = ModBlockStateProperties.DUNGEON_DOOR_PART;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape OPEN_SHAPE = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape OPEN_SHAPE_MIRRORED = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0);
    private final Map<Direction, VoxelShape> shapesCache = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)SHAPE);
    private final EnumMap<Direction, Pair<VoxelShape, VoxelShape>> openShapesCache;

    public DungeonDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)DungeonDoorPart.MIDDLE_1))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.openShapesCache = this.buildOpenShapes();
    }

    private EnumMap<Direction, Pair<VoxelShape, VoxelShape>> buildOpenShapes() {
        EnumMap<Direction, Pair<VoxelShape, VoxelShape>> map = new EnumMap<Direction, Pair<VoxelShape, VoxelShape>>(Direction.class);
        VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)OPEN_SHAPE).forEach((direction, shape) -> map.put((Direction)direction, (Pair<VoxelShape, VoxelShape>)Pair.of((Object)shape, (Object)VoxelShapeHelper.rotateShapeHorizontal((VoxelShape)OPEN_SHAPE_MIRRORED, (Direction)direction))));
        return map;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.m_61143_(PART) == DungeonDoorPart.MIDDLE_1 ? new DungeonDoorBlockEntity(pos, state) : null;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        DungeonDoorPart part = (DungeonDoorPart)((Object)state.m_61143_(PART));
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        if (open && part.isMiddle()) {
            return Shapes.m_83040_();
        }
        if (open) {
            return part.isRight() ? (VoxelShape)this.openShapesCache.get(direction).getSecond() : (VoxelShape)this.openShapesCache.get(direction).getFirst();
        }
        return this.shapesCache.get(direction);
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        if (!this.canPlace(context)) {
            return null;
        }
        for (Position position : Position.values()) {
            for (int i = 0; i < 4; ++i) {
                BlockPos offsetPos = pos.m_6630_(i);
                if (position != Position.MIDDLE) {
                    offsetPos = position.offsetBlockPos(offsetPos, context.m_8125_(), true);
                }
                if (context.m_43725_().m_8055_(offsetPos).m_60629_(context)) continue;
                return null;
            }
        }
        boolean flag = context.m_43725_().m_6425_(pos).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(this.getMainBlock(currentPos, state), (Block)this, 1);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        for (Position position : Position.values()) {
            for (int i = 0; i < 4; ++i) {
                BlockPos offsetPos = pos.m_6630_(i);
                if (position != Position.MIDDLE) {
                    offsetPos = position.offsetBlockPos(offsetPos, (Direction)state.m_61143_((Property)FACING), false);
                }
                if (offsetPos == pos) continue;
                DungeonDoorPart part = DungeonDoorPart.valueOf(position + "_" + (i + 1));
                boolean flag = world.m_6425_(offsetPos).m_76152_() == Fluids.f_76193_;
                world.m_7731_(offsetPos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag)), 3);
            }
        }
    }

    public void m_7458_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull Random random) {
        this.breakDoor((LevelAccessor)level, pos, state, null, true);
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN) == false;
        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
        boolean canOpen = true;
        if (!level.m_5776_()) {
            for (Position position : Position.values()) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos offsetPos = this.getMainBlock(pos, state).m_6630_(i);
                    if (position != Position.MIDDLE) {
                        offsetPos = position.offsetBlockPos(offsetPos, (Direction)state.m_61143_((Property)FACING), false);
                        BlockPos leafPos = offsetPos.m_142300_((Direction)state.m_61143_((Property)FACING));
                        if (open) {
                            if (!level.m_8055_(leafPos).m_60629_(new BlockPlaceContext(player, hand, new ItemStack((ItemLike)ModBlocks.DUNGEON_DOOR.get()), hit))) {
                                canOpen = false;
                            }
                            map.put(leafPos, (BlockState)((BlockState)((BlockState)((DungeonDoorLeafBlock)ModBlocks.DUNGEON_DOOR_LEAF.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ModBlockStateProperties.MIRRORED, (Comparable)Boolean.valueOf(position == Position.RIGHT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_8055_(leafPos).m_60734_() == Blocks.f_49990_)));
                        } else {
                            map.put(leafPos, (Boolean)level.m_8055_(leafPos).m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
                        }
                    }
                    map.put(offsetPos, (BlockState)level.m_8055_(offsetPos).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
                }
            }
        }
        if (canOpen) {
            map.forEach((blockPos, blockState) -> level.m_7731_(blockPos, blockState, blockState == Blocks.f_50016_.m_49966_() ? 35 : 10));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        this.breakDoor((LevelAccessor)level, pos, state, player, false);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posDown = pos.m_7495_();
        BlockState stateDown = level.m_8055_(posDown);
        DungeonDoorPart part = (DungeonDoorPart)((Object)state.m_61143_(PART));
        if (part.isBottom()) {
            if ((part.isLeft() || part.isRight()) && !level.m_8055_(Position.getPositionFromPart(part).offsetBlockPos(pos, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), true)).m_60713_((Block)this)) {
                return false;
            }
            return stateDown.m_60783_((BlockGetter)level, posDown, Direction.UP);
        }
        if (((DungeonDoorPart)((Object)state.m_61143_(PART))).m_7912_().endsWith("3") && !level.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
            return false;
        }
        return stateDown.m_60713_((Block)this);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    private boolean canPlace(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (pos.m_123342_() > level.m_151558_() - 4) {
            return false;
        }
        for (Position position : Position.values()) {
            BlockPos posDown = pos.m_7495_();
            if (position != Position.MIDDLE) {
                posDown = position.offsetBlockPos(posDown, context.m_8125_(), true);
            }
            if (level.m_8055_(posDown).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) continue;
            return false;
        }
        return true;
    }

    private void breakDoor(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Player player, boolean dropMainBlock) {
        BlockPos mainPos = this.getMainBlock(pos, state);
        if (level.m_5776_() || player != null && !player.m_7500_()) {
            return;
        }
        for (Position position : Position.values()) {
            for (int k = 0; k < 4; ++k) {
                BlockState state1;
                BlockPos offsetPos = mainPos.m_6630_(k);
                if (position != Position.MIDDLE) {
                    BlockPos pos2;
                    BlockState offsetState;
                    offsetPos = position.offsetBlockPos(offsetPos, (Direction)state.m_61143_((Property)FACING), false);
                    if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && (offsetState = level.m_8055_(pos2 = offsetPos.m_142300_((Direction)state.m_61143_((Property)FACING)))).m_60734_() == ModBlocks.DUNGEON_DOOR_LEAF.get()) {
                        level.m_5898_(player, 2001, pos2, Block.m_49956_((BlockState)offsetState));
                        level.m_7731_(pos2, (Boolean)offsetState.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 35);
                    }
                }
                if ((state1 = level.m_8055_(offsetPos)).m_60734_() != ModBlocks.DUNGEON_DOOR.get()) continue;
                if (dropMainBlock && state1.m_61143_(PART) == DungeonDoorPart.MIDDLE_1) {
                    level.m_46961_(offsetPos, true);
                    continue;
                }
                level.m_5898_(player, 2001, offsetPos, Block.m_49956_((BlockState)state1));
                level.m_7731_(offsetPos, (Boolean)state1.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 35);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.DUNGEON_DOOR.get()), DungeonDoorBlockEntity::clientTick);
        }
        return null;
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    private BlockPos getMainBlock(BlockPos pos, BlockState state) {
        DungeonDoorPart part = (DungeonDoorPart)((Object)state.m_61143_(PART));
        if (!part.isMiddle()) {
            pos = Position.getPositionFromPart(part).offsetBlockPos(pos, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), true);
        }
        return pos.m_6625_(Integer.parseInt(String.valueOf(part.m_7912_().charAt(part.m_7912_().length() - 1))) - 1);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART, OPEN, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private static enum Position {
        LEFT(Direction.WEST),
        MIDDLE(null),
        RIGHT(Direction.EAST);

        private final Direction direction;

        private Position(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public static Position getPositionFromPart(DungeonDoorPart part) {
            return part.isLeft() ? LEFT : (part.isRight() ? RIGHT : MIDDLE);
        }

        public BlockPos offsetBlockPos(BlockPos pos, Direction direction, boolean opposite) {
            if (opposite) {
                return pos.m_142300_(Direction.m_122364_((double)(direction.m_122435_() + this.getDirection().m_122435_())).m_122424_());
            }
            return pos.m_142300_(Direction.m_122364_((double)(direction.m_122435_() + this.getDirection().m_122435_())));
        }
    }
}

