/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.collision;

import java.util.List;
import java.util.stream.Collectors;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.collision.CollisionHelper;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.WeaponHitBoxes;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.bettercombat.compatibility.PehkuiHelper;
import net.bettercombat.logic.TargetHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TargetFinder {
    public static TargetResult findAttackTargetResult(Player player, Entity cursorTarget, WeaponAttributes.Attack attack, double attackRange) {
        Vec3 origin = TargetFinder.getInitialTracingPoint(player);
        List<Entity> entities = TargetFinder.getInitialTargets(player, cursorTarget, attackRange);
        if (CompatibilityFlags.usePehkui) {
            attackRange *= (double)PehkuiHelper.getScale((Entity)player);
        }
        boolean isSpinAttack = attack.angle() > 180.0;
        Vec3 size = WeaponHitBoxes.createHitbox(attack.hitbox(), attackRange, isSpinAttack);
        OrientedBoundingBox obb = new OrientedBoundingBox(origin, size, player.m_146909_(), player.m_146908_());
        if (!isSpinAttack) {
            obb = obb.offsetAlongAxisZ(size.f_82481_ / 2.0);
        }
        obb.updateVertex();
        CollisionFilter collisionFilter = new CollisionFilter(obb);
        entities = collisionFilter.filter(entities);
        RadialFilter radialFilter = new RadialFilter(origin, obb.axisZ, attackRange, attack.angle());
        entities = radialFilter.filter(entities);
        return new TargetResult(entities, obb);
    }

    public static List<Entity> findAttackTargets(Player player, Entity cursorTarget, WeaponAttributes.Attack attack, double attackRange) {
        return TargetFinder.findAttackTargetResult((Player)player, (Entity)cursorTarget, (WeaponAttributes.Attack)attack, (double)attackRange).entities;
    }

    public static Vec3 getInitialTracingPoint(Player player) {
        double shoulderHeight = (double)player.m_20206_() * 0.15 * (double)player.m_6134_();
        return player.m_146892_().m_82492_(0.0, shoulderHeight, 0.0);
    }

    public static List<Entity> getInitialTargets(Player player, Entity cursorTarget, double attackRange) {
        AABB box = player.m_142469_().m_82400_(attackRange * (double)BetterCombat.config.target_search_range_multiplier + 1.0);
        List<Entity> entities = player.f_19853_.m_6249_((Entity)player, box, entity -> !entity.m_5833_() && entity.m_6087_()).stream().filter(entity -> {
            boolean result = entity != player && entity != cursorTarget && entity.m_6097_() && (BetterCombat.config.allow_attacking_mount || !entity.equals((Object)player.m_20202_())) && TargetHelper.getRelation(player, entity) == TargetHelper.Relation.HOSTILE;
            return result;
        }).collect(Collectors.toList());
        if (cursorTarget != null && cursorTarget.m_6097_()) {
            entities.add(cursorTarget);
        }
        return entities;
    }

    public static class CollisionFilter
    implements Filter {
        private OrientedBoundingBox obb;

        public CollisionFilter(OrientedBoundingBox obb) {
            this.obb = obb;
        }

        @Override
        public List<Entity> filter(List<Entity> entities) {
            return entities.stream().filter((? super T entity) -> this.obb.intersects(entity.m_142469_()) || this.obb.contains(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0))).collect(Collectors.toList());
        }
    }

    public static class RadialFilter
    implements Filter {
        private final Vec3 origin;
        private final Vec3 orientation;
        private final double attackRange;
        private final double attackAngle;

        public RadialFilter(Vec3 origin, Vec3 orientation, double attackRange, double attackAngle) {
            this.origin = origin;
            this.orientation = orientation;
            this.attackRange = attackRange;
            this.attackAngle = Mth.m_14008_((double)attackAngle, (double)0.0, (double)360.0);
        }

        @Override
        public List<Entity> filter(List<Entity> entities) {
            return entities.stream().filter((? super T entity) -> {
                double maxAngleDif = this.attackAngle / 2.0;
                Vec3 distanceVector = CollisionHelper.distanceVector(this.origin, entity.m_142469_());
                Vec3 positionVector = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(this.origin);
                return distanceVector.m_82553_() <= this.attackRange && (this.attackAngle == 0.0 || CollisionHelper.angleBetween(positionVector, this.orientation) <= maxAngleDif || CollisionHelper.angleBetween(distanceVector, this.orientation) <= maxAngleDif) && (BetterCombat.config.allow_attacking_thru_walls || RadialFilter.rayContainsNoObstacle(this.origin, this.origin.m_82549_(distanceVector)) || RadialFilter.rayContainsNoObstacle(this.origin, this.origin.m_82549_(positionVector)));
            }).collect(Collectors.toList());
        }

        private static boolean rayContainsNoObstacle(Vec3 start, Vec3 end) {
            Minecraft client = Minecraft.m_91087_();
            ClientLevel world = client.f_91073_;
            BlockHitResult hit = client.f_91073_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)client.f_91074_));
            return hit.m_6662_() != HitResult.Type.BLOCK;
        }
    }

    public static class TargetResult {
        public List<Entity> entities;
        public OrientedBoundingBox obb;

        public TargetResult(List<Entity> entities, OrientedBoundingBox obb) {
            this.entities = entities;
            this.obb = obb;
        }
    }

    public static interface Filter {
        public List<Entity> filter(List<Entity> var1);
    }
}

