/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ht.treechop.client.Client;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ChopIndicator
extends GuiComponent {
    private static final double IMAGE_SCALE = 1.0;

    public static void render(PoseStack poseStack, int windowWidth, int windowHeight) {
        BlockPos blockPos;
        Minecraft minecraft = Minecraft.m_91087_();
        HitResult mouseOver = minecraft.f_91077_;
        LocalPlayer player = minecraft.f_91074_;
        if (!((Boolean)ConfigHandler.CLIENT.showChoppingIndicators.get()).booleanValue()) {
            return;
        }
        if (Client.isChoppingIndicatorEnabled() && minecraft.f_91073_ != null && minecraft.f_91080_ == null && mouseOver != null && mouseOver.m_6662_() == HitResult.Type.BLOCK && mouseOver instanceof BlockHitResult && ChopUtil.playerWantsToChop((Player)minecraft.f_91074_, Client.getChopSettings()) && ChopIndicator.blockCanBeChopped(blockPos = ((BlockHitResult)mouseOver).m_82425_())) {
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Sprite.TEXTURE_PATH);
            int indicatorCenterX = windowWidth / 2 + (Integer)ConfigHandler.CLIENT.indicatorXOffset.get();
            int indicatorCenterY = windowHeight / 2 + (Integer)ConfigHandler.CLIENT.indicatorYOffset.get();
            Sprite sprite = ChopUtil.playerWantsToFell((Player)minecraft.f_91074_, Client.getChopSettings()) ? Sprite.CHOP_INDICATOR : Sprite.NO_FELL_INDICATOR;
            int imageWidth = (int)((double)sprite.width * 1.0);
            int imageHeight = (int)((double)sprite.height * 1.0);
            sprite.blit(poseStack, indicatorCenterX - imageWidth / 2, indicatorCenterY - imageHeight / 2, imageWidth, imageHeight);
            RenderSystem.m_69453_();
        }
    }

    private static boolean blockCanBeChopped(BlockPos pos) {
        boolean wantToChop;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ClientLevel level = minecraft.f_91073_;
        ClientChopSettings chopSettings = Client.getChopSettings();
        if (player == null || level == null) {
            return false;
        }
        boolean bl = wantToChop = ChopUtil.canChopWithTool(player.m_21205_()) && ChopUtil.playerWantsToChop((Player)minecraft.f_91074_, chopSettings);
        if (wantToChop) {
            if (ChopUtil.playerWantsToFell((Player)player, chopSettings)) {
                return Client.treeCache.getTree((Level)level, pos).isAProperTree(chopSettings.getTreesMustHaveLeaves());
            }
            return ChopUtil.isBlockALog((Level)level, pos);
        }
        return false;
    }
}

