/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import com.mojang.datafixers.util.Pair;
import ht.treechop.client.model.ModelUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.FaceShape;
import ht.treechop.common.util.Vector3;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ChoppedLogBakedModel
implements UnbakedModel,
BakedModel {
    private static TextureAtlasSprite defaultSprite;
    protected final ResourceLocation defaultTextureRL = new ResourceLocation("block/stripped_oak_log");

    protected TextureAtlasSprite getSpriteForBlockSide(BlockState blockState, Direction side, Random rand) {
        ModelResourceLocation modelLocation = BlockModelShaper.m_110895_((BlockState)blockState);
        return Minecraft.m_91087_().m_91304_().m_119422_(modelLocation).m_6840_(blockState, side, rand).stream().filter(Objects::nonNull).findFirst().map(BakedQuad::m_173410_).orElse(this.getDefaultSprite());
    }

    public Collection<ResourceLocation> m_7970_() {
        return Collections.emptyList();
    }

    public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> var1, Set<Pair<String, String>> var2) {
        return Collections.emptyList();
    }

    @Nullable
    public BakedModel m_7611_(ModelBakery modelBakery, Function<Material, TextureAtlasSprite> textureGetter, ModelState modelState, ResourceLocation modelId) {
        defaultSprite = textureGetter.apply(new Material(TextureAtlas.f_118259_, this.defaultTextureRL));
        return this;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState blockState, @Nullable Direction direction, Random randomSource) {
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getDefaultSprite();
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    protected TextureAtlasSprite getDefaultSprite() {
        return defaultSprite;
    }

    protected Stream<BakedQuad> getQuads(BlockState strippedState, ChoppedLogShape shape, int chops, Set<Direction> solidSides, Random random) {
        AABB box = shape.getBoundingBox(chops);
        float downY = (float)box.f_82289_;
        float upY = (float)box.f_82292_;
        float northZ = (float)box.f_82290_;
        float southZ = (float)box.f_82293_;
        float westX = (float)box.f_82288_;
        float eastX = (float)box.f_82291_;
        Vector3 topNorthEast = new Vector3(eastX, upY, northZ);
        Vector3 topNorthWest = new Vector3(westX, upY, northZ);
        Vector3 topSouthEast = new Vector3(eastX, upY, southZ);
        Vector3 topSouthWest = new Vector3(westX, upY, southZ);
        Vector3 bottomNorthEast = new Vector3(eastX, downY, northZ);
        Vector3 bottomNorthWest = new Vector3(westX, downY, northZ);
        Vector3 bottomSouthEast = new Vector3(eastX, downY, southZ);
        Vector3 bottomSouthWest = new Vector3(westX, downY, southZ);
        return Stream.concat(Stream.of(Triple.of((Object)bottomSouthEast, (Object)bottomNorthWest, (Object)Direction.DOWN), Triple.of((Object)topSouthEast, (Object)topNorthWest, (Object)Direction.UP), Triple.of((Object)topNorthEast, (Object)bottomNorthWest, (Object)Direction.NORTH), Triple.of((Object)topSouthEast, (Object)bottomSouthWest, (Object)Direction.SOUTH), Triple.of((Object)topSouthWest, (Object)bottomNorthWest, (Object)Direction.WEST), Triple.of((Object)topSouthEast, (Object)bottomNorthEast, (Object)Direction.EAST)).map(triple -> ModelUtil.makeQuad(this.getSpriteForBlockSide(strippedState, (Direction)triple.getRight(), random), (Vector3)triple.getLeft(), (Vector3)triple.getMiddle(), (Direction)triple.getRight(), null)), solidSides.stream().map(direction -> ModelUtil.makeQuad(this.getSpriteForBlockSide(strippedState, direction.m_122424_(), random), FaceShape.get(direction), direction.m_122424_(), null))).filter(Objects::nonNull);
    }
}

