/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.TreeChop;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.registry.ForgeModBlocks;
import ht.treechop.common.util.ChopUtil;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeChoppedLogBakedModel
extends ChoppedLogBakedModel
implements IDynamicBakedModel {
    public static ModelProperty<Set<Direction>> SOLID_SIDES = new ModelProperty();
    public static ModelProperty<BlockState> STRIPPED_BLOCK_STATE = new ModelProperty();
    public static ModelProperty<Integer> CHOP_COUNT = new ModelProperty();
    public static ModelProperty<ChoppedLogShape> CHOPPED_LOG_SHAPE = new ModelProperty();

    public static void overrideBlockStateModels(ModelBakeEvent event) {
        for (BlockState blockState : ((Block)ForgeModBlocks.CHOPPED_LOG.get()).m_49965_().m_61056_()) {
            ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            BakedModel existingModel = event.getModelManager().m_119422_(variantMRL);
            if (existingModel == event.getModelManager().m_119409_()) {
                TreeChop.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof ForgeChoppedLogBakedModel) {
                TreeChop.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            BakedModel customModel = new ForgeChoppedLogBakedModel().m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), null, null);
            event.getModelRegistry().put(variantMRL, customModel);
        }
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            builder.withInitial(SOLID_SIDES, entity.getShape().getSolidSides((BlockGetter)level, pos));
            builder.withInitial(STRIPPED_BLOCK_STATE, (Object)ChopUtil.getStrippedState(entity.getOriginalState()));
            builder.withInitial(CHOP_COUNT, (Object)entity.getChops());
            builder.withInitial(CHOPPED_LOG_SHAPE, (Object)entity.getShape());
        }
        return builder.build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        if (side == null && state != null) {
            Integer chops;
            ChoppedLogShape shape;
            BlockState strippedState = extraData.hasProperty(STRIPPED_BLOCK_STATE) ? (BlockState)extraData.getData(STRIPPED_BLOCK_STATE) : Blocks.f_50010_.m_49966_();
            Set<Direction> solidSides = (Set<Direction>)extraData.getData(SOLID_SIDES);
            if (solidSides == null) {
                solidSides = Collections.emptySet();
            }
            if ((shape = (ChoppedLogShape)((Object)extraData.getData(CHOPPED_LOG_SHAPE))) == null) {
                shape = ChoppedLogShape.PILLAR_Y;
            }
            if ((chops = (Integer)extraData.getData(CHOP_COUNT)) == null) {
                chops = 1;
            }
            return this.getQuads(strippedState, shape, chops, solidSides, rand).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

