/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.capabilities.ChopSettingsProvider;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ForgePacketHandler;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Common {
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        ForgePacketHandler.init();
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ConfigHandler.updateTags();
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        ServerPlayer agent;
        ServerLevel level;
        BlockPos pos;
        BlockState blockState;
        ItemStack tool;
        block6: {
            block5: {
                LevelAccessor levelAccessor;
                tool = event.getPlayer().m_21205_();
                blockState = event.getState();
                pos = event.getPos();
                if (event.isCanceled() || !((levelAccessor = event.getWorld()) instanceof ServerLevel)) break block5;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getPlayer();
                if (levelAccessor instanceof ServerPlayer && blockState.canHarvestBlock((BlockGetter)level, pos, (Player)(agent = (ServerPlayer)levelAccessor))) break block6;
            }
            return;
        }
        if (!ChopUtil.playerWantsToChop((Player)agent)) {
            return;
        }
        if (ChopUtil.chop(agent, level, pos, blockState, tool, event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ResourceLocation loc = new ResourceLocation("treechopchop_settings_capability");
        Entity entity = (Entity)event.getObject();
        if (entity instanceof FakePlayer) {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider(ConfigHandler.fakePlayerChopSettings.get()));
        } else {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider());
        }
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ChopSettingsCapability.class);
    }
}

