/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.block.BlockImitator;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.ChopUtil;
import ht.treechop.server.Server;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ChoppedLogBlock
extends BlockImitator
implements IChoppableBlock,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ChoppedLogBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60988_().m_60971_((blockState, level, pos) -> false));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static ChoppedLogShape getPlacementShape(Level level, BlockPos blockPos) {
        boolean DOWN = true;
        int UP = 2;
        int NORTH = 4;
        int SOUTH = 8;
        int WEST = 16;
        int EAST = 32;
        byte openSides = (byte)((ChoppedLogBlock.isBlockOpen(level, blockPos.m_7495_()) ? 1 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_7494_()) ? 2 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142127_()) ? 4 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142128_()) ? 8 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142125_()) ? 16 : 0) | (!ChopUtil.isBlockALog(level, blockPos.m_142126_()) ? 32 : 0));
        return ChoppedLogShape.forOpenSides(openSides);
    }

    @Override
    public BlockState getImitatedBlockState(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            return entity.getOriginalState();
        }
        return Blocks.f_49999_.m_49966_();
    }

    private static boolean isBlockOpen(Level level, BlockPos pos) {
        return level.m_46859_(pos) || ChopUtil.isBlockLeaves(level, pos);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        double scale = 0.0625;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            AABB box = entity.getShape().getBoundingBox(entity.getChops());
            return Shapes.m_83048_((double)(box.f_82288_ * 0.0625), (double)(box.f_82289_ * 0.0625), (double)(box.f_82290_ * 0.0625), (double)(box.f_82291_ * 0.0625), (double)(box.f_82292_ * 0.0625), (double)(box.f_82293_ * 0.0625));
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            return entity.getShape().getOcclusionShape();
        }
        return Shapes.m_83144_();
    }

    public boolean m_7923_(BlockState blockState) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    public int getNumChops(BlockGetter level, BlockPos pos, BlockState blockState) {
        int n;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MyEntity) {
            MyEntity entity = (MyEntity)blockEntity;
            n = entity.getChops();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public int getMaxNumChops(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return 7;
    }

    @Override
    public void chop(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState, int numChops, boolean felling) {
        int currentNumChops = blockState.m_60713_((Block)this) ? this.getNumChops((BlockGetter)level, pos, blockState) : 0;
        int newNumChops = Math.min(currentNumChops + numChops, ChopUtil.getMaxNumChops(level, pos, blockState));
        int numAddedChops = newNumChops - currentNumChops;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < numAddedChops; ++i) {
                ChoppedLogBlock.m_49874_((BlockState)this.m_49966_(), (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)tool).forEach(stack -> ChoppedLogBlock.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)stack));
            }
        }
        if (!felling) {
            if (numAddedChops > 0) {
                BlockEntity blockEntity;
                if (!blockState.m_60713_((Block)this)) {
                    BlockEntity blockEntity2;
                    BlockState newBlockState;
                    BlockState blockState2 = newBlockState = blockState.m_60713_((Block)this) ? blockState : this.getPlacementState(level, pos);
                    if (level.m_46597_(pos, newBlockState) && (blockEntity2 = level.m_7702_(pos)) instanceof MyEntity) {
                        MyEntity entity = (MyEntity)blockEntity2;
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            entity.setShape(ChoppedLogBlock.getPlacementShape(level, pos));
                            entity.setOriginalState(blockState);
                            List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)entity, (Entity)player, (ItemStack)tool);
                            entity.setDrops(drops);
                        }
                    }
                }
                if ((blockEntity = level.m_7702_(pos)) instanceof MyEntity) {
                    MyEntity entity = (MyEntity)blockEntity;
                    entity.setChops(newNumChops);
                    entity.m_6596_();
                }
            } else {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getPlacementState(context.m_43725_(), context.m_8083_());
    }

    private BlockState getPlacementState(Level level, BlockPos pos) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(this.shouldPlaceAsWaterlogged(level, pos)));
    }

    private boolean shouldPlaceAsWaterlogged(Level level, BlockPos pos) {
        Direction[] waterSourceDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
        return Arrays.stream(waterSourceDirections).filter(direction -> level.m_6425_(pos.m_141952_(direction.m_122436_())).m_76170_()).limit(2L).count() == 2L;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, side, neighborState, level, pos, neighborPos);
    }

    @Override
    public boolean m_7420_(BlockState blockState, BlockGetter level, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false && super.m_7420_(blockState, level, pos);
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState blockState, LootContext.Builder context) {
        Object object;
        if (((Boolean)ConfigHandler.COMMON.dropLootForChoppedBlocks.get()).booleanValue() && (object = context.m_78982_(LootContextParams.f_81462_)) instanceof MyEntity) {
            MyEntity entity = (MyEntity)((Object)object);
            return entity.drops;
        }
        return Collections.emptyList();
    }

    public float m_5880_(BlockState blockState, Player player, BlockGetter level, BlockPos pos) {
        return (float)Math.min(0.35, (double)this.getImitatedBlockState(level, pos).m_60625_(player, level, pos));
    }

    public static abstract class MyEntity
    extends BlockEntity {
        protected BlockState originalState = Blocks.f_49999_.m_49966_();
        protected List<ItemStack> drops = Collections.emptyList();
        private ChoppedLogShape shape = ChoppedLogShape.PILLAR_Y;
        private int chops = 1;

        public MyEntity(BlockPos pos, BlockState blockState) {
            super(TreeChop.platform.getChoppedLogBlockEntity(), pos, blockState);
        }

        public void setChops(int chops) {
            this.chops = chops;
        }

        public void setShape(ChoppedLogShape shape) {
            this.shape = shape;
        }

        public void setOriginalState(BlockState originalState) {
            this.originalState = originalState;
        }

        public void setDrops(List<ItemStack> drops) {
            this.drops = drops;
        }

        public int getChops() {
            return this.chops;
        }

        public ChoppedLogShape getShape() {
            return this.shape;
        }

        public BlockState getOriginalState() {
            return this.originalState;
        }

        public void m_183515_(@Nonnull CompoundTag tag) {
            super.m_183515_(tag);
            tag.m_128405_("OriginalState", Block.m_49956_((BlockState)this.getOriginalState()));
            tag.m_128405_("Chops", this.getChops());
            tag.m_128405_("Shape", this.getShape().ordinal());
            ListTag list = new ListTag();
            this.drops.stream().map(stack -> stack.m_41739_(new CompoundTag())).forEach(arg_0 -> list.add(arg_0));
            tag.m_128365_("Drops", (Tag)list);
        }

        public void m_142466_(@Nonnull CompoundTag tag) {
            super.m_142466_(tag);
            int stateId = tag.m_128451_("OriginalState");
            this.setOriginalState(stateId > 0 ? Block.m_49803_((int)stateId) : Blocks.f_49999_.m_49966_());
            this.setChops(tag.m_128451_("Chops"));
            this.setShape(ChoppedLogShape.values()[tag.m_128451_("Shape")]);
            ListTag list = tag.m_128437_("Drops", 10);
            this.drops = new LinkedList<ItemStack>();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag item = list.m_128728_(i);
                this.drops.add(ItemStack.m_41712_((CompoundTag)item));
            }
        }

        @Nonnull
        public CompoundTag m_5995_() {
            return this.m_187482_();
        }

        @Nullable
        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }

        public void m_6596_() {
            super.m_6596_();
            this.syncWithClients();
        }

        public void syncWithClients() {
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Server.instance().broadcast(serverLevel, this.f_58858_, new ServerUpdateChopsPacket(this.f_58858_, this.m_5995_()));
            }
        }

        public void m_142339_(Level level) {
            CompoundTag update;
            super.m_142339_(level);
            if (level.m_5776_() && (update = ServerUpdateChopsPacket.getPendingUpdate(level, this.f_58858_)) != null) {
                this.m_142466_(update);
            }
        }
    }
}

