/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.config.ListType;
import ht.treechop.common.config.Rounder;
import ht.treechop.common.config.item.ItemIdentifier;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.EntityChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.common.util.AxeAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ConfigHandler {
    public static final Lazy<ChopSettings> defaultChopSettings = new Lazy<ChopSettings>(() -> {
        ChopSettings chopSettings = new ChopSettings();
        Permissions permissions = ConfigHandler.getServerPermissions();
        chopSettings.forEach((field, value) -> {
            if (!permissions.isPermitted((SettingsField)((Object)((Object)field)), value)) {
                chopSettings.set((SettingsField)((Object)((Object)field)), field.getValues().stream().filter(candidate -> permissions.isPermitted(new Setting((SettingsField)((Object)((Object)field)), candidate))).findFirst().orElse(value));
            }
        });
        return chopSettings;
    });
    public static final Lazy<EntityChopSettings> fakePlayerChopSettings = new Lazy<EntityChopSettings>(() -> {
        EntityChopSettings chopSettings = new EntityChopSettings(){

            @Override
            public boolean isSynced() {
                return true;
            }
        };
        chopSettings.setChoppingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerChoppingEnabled.get()).setFellingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerFellingEnabled.get()).setTreesMustHaveLeaves((Boolean)ConfigHandler.COMMON.fakePlayerTreesMustHaveLeaves.get());
        return chopSettings;
    });
    public static Lazy<Boolean> removeBarkOnInteriorLogs = new Lazy<Boolean>(() -> {
        try {
            return (Boolean)ConfigHandler.CLIENT.removeBarkOnInteriorLogs.get();
        }
        catch (IllegalStateException e) {
            return false;
        }
    });
    public static Lazy<Map<Block, BlockState>> inferredStrippedStates = new Lazy<Map>(ConfigHandler::inferStrippedStates);
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void onReload() {
        fakePlayerChopSettings.reset();
        removeBarkOnInteriorLogs.reset();
        inferredStrippedStates.reset();
        ConfigHandler.updateTags();
    }

    public static void updateTags() {
        ConfigHandler.COMMON.itemsBlacklist.reset();
    }

    @NotNull
    private static Map<Block, BlockState> inferStrippedStates() {
        TagKey<Block> logTag = ConfigHandler.COMMON.blockTagForDetectingLogs.get();
        HashMap<Block, BlockState> map = new HashMap<Block, BlockState>();
        Registry.f_122824_.forEach(block -> {
            Block unstripped;
            if (block.m_204297_().m_203656_(logTag) && (unstripped = ConfigHandler.inferUnstripped(block)) != Blocks.f_50016_ && AxeAccessor.getStripped(unstripped) == null) {
                map.put(unstripped, block.m_49966_());
            }
        });
        return map;
    }

    private static Block inferUnstripped(Block block) {
        Pattern prefix = Pattern.compile("stripped_(.+)");
        Pattern suffix = Pattern.compile("(.+)_stripped$");
        ResourceLocation resource = Registry.f_122824_.m_7981_((Object)block);
        Block unstripped = ConfigHandler.inferUnstripped(resource, prefix);
        if (unstripped == Blocks.f_50016_) {
            unstripped = ConfigHandler.inferUnstripped(resource, suffix);
        }
        return unstripped;
    }

    private static Block inferUnstripped(ResourceLocation resource, Pattern pattern) {
        Matcher match;
        if (resource != null && (match = pattern.matcher(resource.m_135815_())).find()) {
            return (Block)Registry.f_122824_.m_7745_(new ResourceLocation(resource.m_135827_(), match.group(1)));
        }
        return Blocks.f_50016_;
    }

    private static Stream<Item> getItemsFromIdentifier(String stringId) {
        ItemIdentifier id = ItemIdentifier.from(stringId);
        return id.resolve();
    }

    public static boolean canChopWithItem(Item item) {
        if (ConfigHandler.COMMON.blacklistOrWhitelist.get() == ListType.BLACKLIST) {
            return !ConfigHandler.COMMON.itemsBlacklist.get().contains(item);
        }
        return ConfigHandler.COMMON.itemsBlacklist.get().contains(item);
    }

    public static Permissions getServerPermissions() {
        return new Permissions(ConfigHandler.COMMON.rawPermissions.stream().filter(settingAndConfig -> (Boolean)((ForgeConfigSpec.BooleanValue)settingAndConfig.getRight()).get()).map(Pair::getLeft).collect(Collectors.toSet()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enabled;
        protected final List<Pair<Setting, ForgeConfigSpec.BooleanValue>> rawPermissions = new LinkedList<Pair<Setting, ForgeConfigSpec.BooleanValue>>();
        public final Lazy<Set<Item>> itemsBlacklist = new Lazy<Set>(() -> ((List)ConfigHandler.COMMON.itemsToBlacklist.get()).stream().flatMap(ConfigHandler::getItemsFromIdentifier).collect(Collectors.toSet()));
        public final ForgeConfigSpec.BooleanValue dropLootForChoppedBlocks;
        public final ForgeConfigSpec.IntValue maxNumTreeBlocks;
        public final ForgeConfigSpec.IntValue maxNumLeavesBlocks;
        public final ForgeConfigSpec.BooleanValue breakLeaves;
        public final ForgeConfigSpec.BooleanValue ignorePersistentLeaves;
        public final ForgeConfigSpec.IntValue maxBreakLeavesDistance;
        protected final ForgeConfigSpec.ConfigValue<String> blockTagForDetectingLogsHandle;
        public final Lazy<TagKey<Block>> blockTagForDetectingLogs = new Lazy<TagKey>(() -> TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation((String)ConfigHandler.COMMON.blockTagForDetectingLogsHandle.get())));
        protected final ForgeConfigSpec.ConfigValue<String> blockTagForDetectingLeavesHandle;
        public final Lazy<TagKey<Block>> blockTagForDetectingLeaves = new Lazy<TagKey>(() -> TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation((String)ConfigHandler.COMMON.blockTagForDetectingLeavesHandle.get())));
        public final ForgeConfigSpec.EnumValue<ChopCountingAlgorithm> chopCountingAlgorithm;
        public final ForgeConfigSpec.EnumValue<Rounder> chopCountRounding;
        public final ForgeConfigSpec.BooleanValue canRequireMoreChopsThanBlocks;
        public final ForgeConfigSpec.DoubleValue logarithmicA;
        public final ForgeConfigSpec.DoubleValue linearM;
        public final ForgeConfigSpec.DoubleValue linearB;
        public final ForgeConfigSpec.EnumValue<ListType> blacklistOrWhitelist;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> itemsToBlacklist;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> itemsToOverride;
        public final ForgeConfigSpec.BooleanValue preventChoppingOnRightClick;
        public final ForgeConfigSpec.BooleanValue preventChopRecursion;
        public final ForgeConfigSpec.BooleanValue compatForProjectMMO;
        public final ForgeConfigSpec.BooleanValue compatForDynamicTrees;
        public final ForgeConfigSpec.BooleanValue fakePlayerChoppingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerFellingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerTreesMustHaveLeaves;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("permissions");
            this.enabled = builder.comment("Whether this mod is enabled or not").define("enabled", true);
            for (SettingsField field : SettingsField.values()) {
                String fieldName = field.getConfigKey();
                for (Object value : field.getValues()) {
                    String valueName = this.getPrettyValueName(value);
                    ForgeConfigSpec.BooleanValue configHandle = builder.define(fieldName + ".canBe" + valueName, true);
                    this.rawPermissions.add((Pair<Setting, ForgeConfigSpec.BooleanValue>)Pair.of((Object)new Setting(field, value), (Object)configHandle));
                }
            }
            builder.pop();
            builder.push("general");
            this.dropLootForChoppedBlocks = builder.comment("Whether to drop loot for blocks that have been chopped").define("loseLootForChoppedBlocks", true);
            builder.pop();
            builder.push("treeDetection");
            this.maxNumTreeBlocks = builder.comment("Maximum number of log blocks that can be detected to belong to one tree").defineInRange("maxTreeBlocks", 320, 1, 8096);
            this.maxNumLeavesBlocks = builder.comment("Maximum number of leaves blocks that can destroyed when a tree is felled").defineInRange("maxLeavesBlocks", 1024, 1, 8096);
            this.breakLeaves = builder.comment("Whether to destroy leaves when a tree is felled").define("breakLeaves", true);
            this.ignorePersistentLeaves = builder.comment("Whether non-decayable leaves are ignored when detecting leaves").define("ignorePersistentLeaves", true);
            this.maxBreakLeavesDistance = builder.comment("Maximum distance from log blocks to destroy non-standard leaves blocks (e.g. mushroom caps) when felling").defineInRange("maxBreakLeavesDistance", 7, 0, 16);
            this.blockTagForDetectingLogsHandle = builder.comment("The tag that blocks must have to be considered choppable (default: treechop:choppables)").define("blockTagForDetectingLogs", (Object)"treechop:choppables");
            this.blockTagForDetectingLeavesHandle = builder.comment("The tag that blocks must have to be considered leaves (default: treechop:leaves_like)").define("blockTagForDetectingLeaves", (Object)"treechop:leaves_like");
            builder.pop();
            builder.push("chopCounting");
            this.chopCountingAlgorithm = builder.comment("Method to use for computing the number of chops needed to fell a tree").defineEnum("algorithm", (Enum)ChopCountingAlgorithm.LOGARITHMIC);
            this.chopCountRounding = builder.comment("How to round the number of chops needed to fell a tree; this is more meaningful for smaller trees").defineEnum("rounding", (Enum)Rounder.NEAREST);
            this.canRequireMoreChopsThanBlocks = builder.comment("Whether felling a tree can require more chops than the number of blocks in the tree").define("canRequireMoreChopsThanBlocks", false);
            builder.comment("See https://github.com/hammertater/treechop/#logarithmic").push("logarithmic");
            this.logarithmicA = builder.comment("Determines the number of chops required to fell a tree; higher values require more chops for bigger trees").defineInRange("a", 10.0, 0.0, 10000.0);
            builder.pop();
            builder.comment("See https://github.com/hammertater/treechop/#linear").push("linear");
            this.linearM = builder.comment("The number of chops per block required to fell a tree; if chopsPerBlock = 0.5, it will take 50 chops to fell a 100 block tree").defineInRange("chopsPerBlock", 1.0, 0.0, 7.0);
            this.linearB = builder.comment("The base number of chops required to fell a tree regardless of its size").defineInRange("baseNumChops", 0.0, -10000.0, 10000.0);
            builder.pop();
            builder.pop();
            builder.push("compatibility");
            builder.push("general");
            this.preventChoppingOnRightClick = builder.comment("Whether to prevent chopping during right-click actions").define("preventChoppingOnRightClick", false);
            this.preventChopRecursion = builder.comment("Whether to prevent infinite loops when chopping; fixes crashes when using modded items that break multiple blocks").define("preventChopRecursion", true);
            builder.push("blacklist");
            this.blacklistOrWhitelist = builder.comment("Whether the listed items should be blacklisted or whitelisted").defineEnum("blacklistOrWhitelist", (Enum)ListType.BLACKLIST);
            this.itemsToBlacklist = builder.comment(String.join((CharSequence)"\n", "List of item registry names (mod:item), tags (#mod:tag), and namespaces (@mod) for items that should not chop when used to break a log", "- Items in this list that have special support for TreeChop will not be blacklisted; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#blacklist")).defineList("items", Arrays.asList("#tconstruct:modifiable/harvest", "botania:terra_axe", "mekanism:atomic_disassembler", "@lumberjack", "practicaltools:iron_greataxe", "practicaltools:golden_greataxe", "practicaltools:diamond_greataxe", "practicaltools:netherite_greataxe"), always -> true);
            builder.pop();
            builder.push("overrides");
            this.itemsToOverride = builder.comment(String.join((CharSequence)"\n", "List of item registry names (mod:item), tags (#mod:tag), and namespaces (@mod) for items that should not perform their default behavior when chopping", "- Add \"?chops=N\" to specify the number of chops to be performed when breaking a log with the item (defaults to 1)", "- Add \"?override=always\" to disable default behavior even when chopping is disabled", "- Add \"?override=never\" to never disable default behavior", "- Items in this list that have special support for TreeChop will not be overridden; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#overrides", "- This might not work as expected for some items; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#caveats")).defineList("items", Arrays.asList("silentgear:saw?chops=3,override=always"), always -> true);
            builder.pop();
            builder.comment("The chop settings used by non-player entities, such as robots and machine blocks");
            builder.push("fakePlayerChopSettings");
            this.fakePlayerChoppingEnabled = builder.comment("Use with caution! May cause conflicts with some mods, e.g. https://github.com/hammertater/treechop/issues/71").define("choppingEnabled", false);
            this.fakePlayerFellingEnabled = builder.comment("Felling only matters if chopping is enabled; probably best to leave this on").define("fellingEnabled", true);
            this.fakePlayerTreesMustHaveLeaves = builder.define("treesMustHaveLeaves", true);
            builder.pop();
            builder.pop();
            builder.push("specific");
            this.compatForProjectMMO = builder.comment(String.join((CharSequence)"\n", "Whether to enable compatibility with ProjectMMO; for example, award XP for chopping", "See https://www.curseforge.com/minecraft/mc-mods/project-mmo")).define("projectMMO", true);
            this.compatForDynamicTrees = builder.comment(String.join((CharSequence)"\n", "Whether to prevent conflicts with DynamicTrees", "See https://www.curseforge.com/minecraft/mc-mods/dynamictrees")).define("dynamicTrees", true);
            builder.pop();
            builder.pop();
        }

        private String getPrettyValueName(Object value) {
            return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue choppingEnabled;
        public final ForgeConfigSpec.BooleanValue fellingEnabled;
        public final ForgeConfigSpec.EnumValue<SneakBehavior> sneakBehavior;
        public final ForgeConfigSpec.BooleanValue treesMustHaveLeaves;
        public final ForgeConfigSpec.BooleanValue chopInCreativeMode;
        public final ForgeConfigSpec.BooleanValue showChoppingIndicators;
        public final ForgeConfigSpec.BooleanValue removeBarkOnInteriorLogs;
        public final ForgeConfigSpec.IntValue indicatorXOffset;
        public final ForgeConfigSpec.IntValue indicatorYOffset;
        public final ForgeConfigSpec.BooleanValue showFellingOptions;
        public final ForgeConfigSpec.BooleanValue showFeedbackMessages;
        public final ForgeConfigSpec.BooleanValue showTooltips;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("chopping");
            this.choppingEnabled = builder.comment("Default setting for whether or not the user wishes to chop (can be toggled in-game)").define("choppingEnabled", true);
            this.fellingEnabled = builder.comment("Default setting for whether or not the user wishes to fell tree when chopping (can be toggled in-game)").define("fellingEnabled", true);
            this.sneakBehavior = builder.comment("Default setting for the effect that sneaking has on chopping (can be cycled in-game)").defineEnum("sneakBehavior", (Enum)SneakBehavior.INVERT_CHOPPING);
            this.treesMustHaveLeaves = builder.comment("Whether to ignore trees without connected leaves").define("treesMustHaveLeaves", true);
            this.chopInCreativeMode = builder.comment("Whether to enable chopping when in creative mode (even when false, sneaking can still enable chopping)").define("chopInCreativeMode", false);
            builder.pop();
            builder.push("visuals");
            this.removeBarkOnInteriorLogs = builder.comment("Whether to replace the interior sides of logs with a chopped texture instead of bark").define("removeBarkOnInteriorLogs", true);
            builder.push("choppingIndicator");
            this.showChoppingIndicators = builder.comment("Whether to show an on-screen icon indicating whether targeted blocks can be chopped").define("enabled", true);
            this.indicatorXOffset = builder.comment("Horizontal location of the indicator relative to the player's crosshairs; positive values move the indicator to the right").defineInRange("xOffset", 16, -256, 256);
            this.indicatorYOffset = builder.comment("Vertical location of the indicator relative to the player's crosshairs; positive values move the indicator down").defineInRange("yOffset", 0, -256, 256);
            builder.pop();
            builder.pop();
            builder.push("settingsScreen");
            this.showFellingOptions = builder.comment("Whether to show in-game options for enabling and disable felling").define("showFellingOptions", false);
            this.showFeedbackMessages = builder.comment("Whether to show chat confirmations when using hotkeys to change chop settings").define("showFeedbackMessages", true);
            this.showTooltips = builder.comment("Whether to show tooltips in the settings screen").define("showTooltips", true);
            builder.pop();
        }

        public ChopSettings getChopSettings() {
            ChopSettings chopSettings = new ChopSettings();
            chopSettings.setChoppingEnabled((Boolean)ConfigHandler.CLIENT.choppingEnabled.get());
            chopSettings.setFellingEnabled((Boolean)ConfigHandler.CLIENT.fellingEnabled.get());
            chopSettings.setSneakBehavior((SneakBehavior)((Object)ConfigHandler.CLIENT.sneakBehavior.get()));
            chopSettings.setTreesMustHaveLeaves((Boolean)ConfigHandler.CLIENT.treesMustHaveLeaves.get());
            chopSettings.setChopInCreativeMode((Boolean)ConfigHandler.CLIENT.chopInCreativeMode.get());
            return chopSettings;
        }
    }
}

