/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.ACIHandler;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class CustomizableLoadingOverlay
extends LoadingOverlay {
    private ReloadInstance reload;
    private Consumer<Optional<Throwable>> onFinish;
    private boolean fadeIn;
    private float currentProgress;
    private long fadeOutStart;
    private long fadeInStart;
    protected boolean isUpdated = false;
    protected int lastWidth = 0;
    protected int lastHeight = 0;

    public CustomizableLoadingOverlay(LoadingOverlay parent) {
        super(Minecraft.m_91087_(), CustomizableLoadingOverlay.getReloadInstance(parent), CustomizableLoadingOverlay.getOnFinish(parent), CustomizableLoadingOverlay.getFadeIn(parent));
        this.reload = CustomizableLoadingOverlay.getReloadInstance(parent);
        this.onFinish = CustomizableLoadingOverlay.getOnFinish(parent);
        this.fadeIn = CustomizableLoadingOverlay.getFadeIn(parent);
        this.currentProgress = CustomizableLoadingOverlay.getCurrentProgress(parent);
        this.fadeOutStart = CustomizableLoadingOverlay.getFadeOutStart(parent);
        this.fadeInStart = CustomizableLoadingOverlay.getFadeInStart(parent);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        float g;
        Minecraft mc = Minecraft.m_91087_();
        SplashCustomizationLayer handler = SplashCustomizationLayer.getInstance();
        ACIHandler.onRenderOverlay(handler);
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        long time = Util.m_137550_();
        if (this.lastWidth != screenWidth || this.lastHeight != screenHeight) {
            this.isUpdated = false;
        }
        this.lastWidth = screenWidth;
        this.lastHeight = screenHeight;
        if (!this.isUpdated) {
            handler.updateCustomizations();
            this.isUpdated = true;
        }
        if (this.fadeIn && this.fadeInStart == -1L) {
            this.fadeInStart = time;
        }
        float f = this.fadeOutStart > -1L ? (float)(time - this.fadeOutStart) / 1000.0f : -1.0f;
        float f2 = g = this.fadeInStart > -1L ? (float)(time - this.fadeInStart) / 500.0f : -1.0f;
        if (f >= 1.0f) {
            if (mc.f_91080_ != null && !DrippyLoadingScreen.isFancyMenuLoaded() && handler.fadeOut) {
                mc.f_91080_.m_6305_(matrices, 0, 0, delta);
            }
        } else if (this.fadeIn && mc.f_91080_ != null && g < 1.0f && !DrippyLoadingScreen.isFancyMenuLoaded() && handler.fadeOut) {
            mc.f_91080_.m_6305_(matrices, mouseX, mouseY, delta);
        }
        float y = this.reload.m_7750_();
        this.currentProgress = Mth.m_14036_((float)(this.currentProgress * 0.95f + y * 0.050000012f), (float)0.0f, (float)1.0f);
        if (f >= 2.0f) {
            CustomizableLoadingOverlay.resetScale(handler);
            mc.m_91150_(null);
        }
        if (this.fadeOutStart == -1L && this.reload.m_7746_() && (!this.fadeIn || g >= 2.0f)) {
            try {
                this.reload.m_7748_();
                this.onFinish.accept(Optional.empty());
            }
            catch (Throwable var23) {
                this.onFinish.accept(Optional.of(var23));
            }
            this.fadeOutStart = Util.m_137550_();
            if (mc.f_91080_ != null) {
                mc.f_91080_.m_6575_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
            }
        }
        handler.reload = this.reload;
        handler.onFinish = this.onFinish;
        handler.fadeIn = this.fadeIn;
        handler.currentProgress = this.currentProgress;
        handler.fadeOutStart = this.fadeOutStart;
        handler.fadeInStart = this.fadeInStart;
        PlaceholderTextValueHelper.currentLoadingProgressValue = "" + (int)(this.currentProgress * 100.0f);
        handler.renderLayer();
    }

    private static void resetScale(SplashCustomizationLayer handler) {
        if (handler.scaled) {
            Minecraft mc = Minecraft.m_91087_();
            Window w = mc.m_91268_();
            int mcScale = w.m_85385_(mc.f_91066_.f_92072_, mc.m_91390_());
            w.m_85378_((double)mcScale);
            int screenWidth = w.m_85445_();
            int screenHeight = w.m_85446_();
            if (mc.f_91080_ != null) {
                mc.f_91080_.m_6575_(mc, screenWidth, screenHeight);
            }
            handler.scaled = false;
        }
    }

    private static ReloadInstance getReloadInstance(LoadingOverlay from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(LoadingOverlay.class, (String)"f_96164_");
            return (ReloadInstance)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Consumer<Optional<Throwable>> getOnFinish(LoadingOverlay from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(LoadingOverlay.class, (String)"f_96165_");
            return (Consumer)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean getFadeIn(LoadingOverlay from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(LoadingOverlay.class, (String)"f_96166_");
            return (Boolean)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static float getCurrentProgress(LoadingOverlay from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(LoadingOverlay.class, (String)"f_96167_");
            return ((Float)f.get(from)).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private static long getFadeOutStart(LoadingOverlay from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(LoadingOverlay.class, (String)"f_96168_");
            return (Long)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getFadeInStart(LoadingOverlay from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(LoadingOverlay.class, (String)"f_96169_");
            return (Long)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

