/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.expandedcaves;

import dev.nerdthings.expandedcaves.common.blocks.ModBlocks;
import dev.nerdthings.expandedcaves.common.config.ECaveConfig;
import dev.nerdthings.expandedcaves.common.gen.ModFeatures;
import dev.nerdthings.expandedcaves.common.gen.ModWorldGen;
import dev.nerdthings.expandedcaves.common.items.ModItems;
import dev.nerdthings.expandedcaves.data.Lang;
import dev.nerdthings.extendedcaves.repack.registrate.Registrate;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod(value="expcaves")
public class ECaveMod {
    @Nonnull
    public static final String MODID = "expcaves";
    private static final Lazy<Registrate> REGISTRATE = Lazy.of(() -> Registrate.create(MODID));
    public static CreativeModeTab TAB = new CreativeModeTab("expcaves.expcaves"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModBlocks.LUMISHROOM.get());
        }
    };

    public ECaveMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ECaveConfig.COMMON_SPEC, "expcaves_common.toml");
        ModBlocks.register();
        ModItems.register();
        ModFeatures.register();
        Lang.register();
        ECaveMod.registrate().addLang("itemGroup", ECaveMod.loc(MODID), "Expanded Caves");
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModWorldGen::onBiomeLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOWEST, this::gatherData);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModWorldGen.register());
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.get();
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            // empty if block
        }
    }
}

