/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.expandedcaves.common.config;

import dev.nerdthings.expandedcaves.common.config.helpers.OreFeatureConfig;
import dev.nerdthings.expandedcaves.common.config.helpers.PatchFeatureConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final OreFeatureConfig ORE_BROKEN_STONE;
    public final OreFeatureConfig ORE_BROKEN_DEEPSLATE;
    public final OreFeatureConfig ORE_SEDIMENT_STONE;
    public final OreFeatureConfig ORE_LAVASTONE;
    public final OreFeatureConfig ORE_DIRTSTONE;
    public final OreFeatureConfig ORE_MARLSTONE;
    public final OreFeatureConfig ORE_PACKED_ICE;
    public final PatchFeatureConfig FLINT_PEBBLE;
    public final PatchFeatureConfig PEBBLES;
    public final PatchFeatureConfig SURFACE_PEBBLES;
    public final PatchFeatureConfig ROCKPILES;
    public final PatchFeatureConfig STALAGMITES;
    public final PatchFeatureConfig STALACTITES;
    public final ForgeConfigSpec.BooleanValue MUSHROOMS_ENABLED;
    public final ForgeConfigSpec.BooleanValue MOSSES_ENABLED;
    public final ForgeConfigSpec.BooleanValue VINES_ENABLED;
    public final ForgeConfigSpec.IntValue SWEETSHROOM_COUNT;
    public final ForgeConfigSpec.IntValue GOLDISHROOM_COUNT;
    public final ForgeConfigSpec.IntValue SHINYSHROOM_COUNT;
    public final ForgeConfigSpec.IntValue LUMISHROOM_COUNT;
    public final ForgeConfigSpec.IntValue FLUOSHROOM_COUNT;
    public final ForgeConfigSpec.IntValue ROCKSHROOM_COUNT;
    public final ForgeConfigSpec.IntValue DRY_MOSS_COUNT;
    public final ForgeConfigSpec.IntValue FIRE_MOSS_COUNT;
    public final ForgeConfigSpec.IntValue FROZEN_MOSS_COUNT;
    public final ForgeConfigSpec.IntValue HANGING_ROOTS_COUNT;
    public final ForgeConfigSpec.IntValue HUMID_MOSS_COUNT;
    public final ForgeConfigSpec.IntValue CAVE_VINE_COUNT;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("oreFeatures");
        this.ORE_BROKEN_STONE = new OreFeatureConfig("brokenStone", 24, 12, builder);
        this.ORE_BROKEN_DEEPSLATE = new OreFeatureConfig("brokenDeepslate", 24, 12, builder);
        this.ORE_SEDIMENT_STONE = new OreFeatureConfig("sedimentStone", 54, 8, builder);
        this.ORE_LAVASTONE = new OreFeatureConfig("lavastone", 48, 12, builder);
        this.ORE_DIRTSTONE = new OreFeatureConfig("dirtstone", 64, 5, builder);
        this.ORE_MARLSTONE = new OreFeatureConfig("marlstone", 48, 5, builder);
        this.ORE_PACKED_ICE = new OreFeatureConfig("packedIce", 64, 5, builder);
        builder.pop();
        builder.push("rockFeatures");
        this.FLINT_PEBBLE = new PatchFeatureConfig("flintPebbles", 12, builder);
        this.PEBBLES = new PatchFeatureConfig("pebbles", 12, builder);
        this.SURFACE_PEBBLES = new PatchFeatureConfig("surface_pebbles", 4, builder);
        this.ROCKPILES = new PatchFeatureConfig("rockpiles", 12, builder);
        this.STALAGMITES = new PatchFeatureConfig("stalagmites", 16, builder);
        this.STALACTITES = new PatchFeatureConfig("stalactites", 16, builder);
        builder.pop();
        builder.push("mushrooms");
        this.MUSHROOMS_ENABLED = builder.comment("Whether mushrooms can generate.").define("enabled", true);
        this.SWEETSHROOM_COUNT = builder.comment("The number of sweetshroom generated. (default = 32)").defineInRange("sweetshroomCount", 32, 0, 64);
        this.GOLDISHROOM_COUNT = builder.comment("The number of goldishroom generated. (default = 16)").defineInRange("goldishroomCount", 16, 0, 64);
        this.SHINYSHROOM_COUNT = builder.comment("The number of shinyshroom generated. (default = 24)").defineInRange("shinyshroomCount", 24, 0, 64);
        this.LUMISHROOM_COUNT = builder.comment("The number of lumishroom generated. (default = 32)").defineInRange("lumishroomCount", 32, 0, 64);
        this.FLUOSHROOM_COUNT = builder.comment("The number of fluoshroom generated. (default = 32)").defineInRange("fluoshroomCount", 32, 0, 64);
        this.ROCKSHROOM_COUNT = builder.comment("The number of rockshroom generated. (default = 12)").defineInRange("rockshroomCount", 12, 0, 64);
        builder.pop();
        builder.push("mosses");
        this.MOSSES_ENABLED = builder.comment("Whether moss can generate.").define("enabled", true);
        this.DRY_MOSS_COUNT = builder.comment("The number of dry moss generated. (default = 54)").defineInRange("dryMossCount", 54, 0, 64);
        this.FIRE_MOSS_COUNT = builder.comment("The number of fire moss generated. (default = 24)").defineInRange("fireMossCount", 24, 0, 64);
        this.FROZEN_MOSS_COUNT = builder.comment("The number of frozen moss generated. (default = 32)").defineInRange("frozenMossCount", 32, 0, 64);
        this.HANGING_ROOTS_COUNT = builder.comment("The number of hanging roots generated. (default = 32)").defineInRange("hangingRootsCount", 32, 0, 64);
        this.HUMID_MOSS_COUNT = builder.comment("The number of humid moss generated. (default = 32)").defineInRange("humidMossCount", 32, 0, 64);
        builder.pop();
        builder.push("vines");
        this.VINES_ENABLED = builder.comment("Whether vines can generate.").define("enabled", true);
        this.CAVE_VINE_COUNT = builder.comment("The number of cave vines generated. (default = 54)").defineInRange("caveVineCount", 54, 0, 64);
        builder.pop();
        builder.push("structures");
        builder.pop();
    }
}

