/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.expandedcaves.common.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.nerdthings.expandedcaves.common.blocks.ModBlocks;
import dev.nerdthings.expandedcaves.common.blocks.rock.RockpileBlock;
import dev.nerdthings.expandedcaves.common.config.ECaveConfig;
import dev.nerdthings.expandedcaves.common.config.helpers.OreFeatureConfig;
import dev.nerdthings.expandedcaves.common.gen.ModFeatures;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModWorldGen {
    private static final int SPREAD_I = 8;
    private static final int SPREAD_J = 16;
    private static final int SPREAD_K = 4;
    private static final List<Block> WHITELIST_STONE = ImmutableList.of((Object)Blocks.f_50069_, (Object)((Block)ModBlocks.BROKEN_STONE.get()));
    private static final List<Block> WHITELIST_ANDESITE = ImmutableList.of((Object)Blocks.f_50334_);
    private static final List<Block> WHITELIST_DIORITE = ImmutableList.of((Object)Blocks.f_50228_);
    private static final List<Block> WHITELIST_GRANITE = ImmutableList.of((Object)Blocks.f_50122_);
    private static final List<Block> WHITELIST_TUFF = ImmutableList.of((Object)Blocks.f_152496_);
    private static final List<Block> WHITELIST_DEEPSLATE = ImmutableList.of((Object)Blocks.f_152550_);
    private static final List<Block> WHITELIST_SEDIMENT_STONE = ImmutableList.of((Object)((Block)ModBlocks.SEDIMENT_STONE.get()));
    private static final List<Block> WHITELIST_LAVASTONE = ImmutableList.of((Object)((Block)ModBlocks.LAVASTONE.get()));
    private static final List<Block> WHITELIST_PACKED_ICE = ImmutableList.of((Object)Blocks.f_50354_);
    private static final int FLINT_PEBBLE_TRIES = 8;
    private static final int STONE_PEBBLE_TRIES = 32;
    private static final int ANDESITE_PEBBLE_TRIES = 32;
    private static final int DIORITE_PEBBLE_TRIES = 32;
    private static final int GRANITE_PEBBLE_TRIES = 32;
    private static final int TUFF_PEBBLE_TRIES = 32;
    private static final int DEEPSLATE_PEBBLE_TRIES = 32;
    private static final int SEDIMENT_STONE_PEBBLE_TRIES = 32;
    private static final int LAVASTONE_PEBBLE_TRIES = 32;
    private static final int SMALL_STONE_PILE_TRIES = 32;
    private static final int SMALL_ANDESITE_PILE_TRIES = 32;
    private static final int SMALL_DIORITE_PILE_TRIES = 32;
    private static final int SMALL_GRANITE_PILE_TRIES = 32;
    private static final int SMALL_TUFF_PILE_TRIES = 32;
    private static final int SMALL_DEEPSLATE_PILE_TRIES = 32;
    private static final int SMALL_SEDIMENT_STONE_PILE_TRIES = 32;
    private static final int SMALL_LAVASTONE_PILE_TRIES = 32;
    private static final int BIG_STONE_PILE_TRIES = 32;
    private static final int BIG_ANDESITE_PILE_TRIES = 32;
    private static final int BIG_DIORITE_PILE_TRIES = 32;
    private static final int BIG_GRANITE_PILE_TRIES = 32;
    private static final int BIG_TUFF_PILE_TRIES = 32;
    private static final int BIG_DEEPSLATE_PILE_TRIES = 32;
    private static final int BIG_SEDIMENT_STONE_PILE_TRIES = 32;
    private static final int BIG_LAVASTONE_PILE_TRIES = 32;
    private static final int PEBBLE_COUNT = (Integer)ECaveConfig.COMMON.PEBBLES.COUNT.get();
    private static final int SURFACE_PEBBLE_COUNT = (Integer)ECaveConfig.COMMON.SURFACE_PEBBLES.COUNT.get();
    private static final int ROCKPILE_COUNT = (Integer)ECaveConfig.COMMON.ROCKPILES.COUNT.get();
    private static final int STALAGMITE_STONE_TRIES = 64;
    private static final int STALAGMITE_ANDESITE_TRIES = 64;
    private static final int STALAGMITE_DIORITE_TRIES = 64;
    private static final int STALAGMITE_GRANITE_TRIES = 64;
    private static final int STALAGMITE_TUFF_TRIES = 64;
    private static final int STALAGMITE_DEEPSLATE_TRIES = 64;
    private static final int STALAGMITE_SEDIMENT_STONE_TRIES = 32;
    private static final int STALAGMITE_LAVASTONE_TRIES = 32;
    private static final int STALAGMITE_PACKED_ICE_TRIES = 32;
    private static final int TALL_STALAGMITE_STONE_TRIES = 64;
    private static final int TALL_STALAGMITE_ANDESITE_TRIES = 64;
    private static final int TALL_STALAGMITE_DIORITE_TRIES = 64;
    private static final int TALL_STALAGMITE_GRANITE_TRIES = 64;
    private static final int TALL_STALAGMITE_TUFF_TRIES = 64;
    private static final int TALL_STALAGMITE_DEEPSLATE_TRIES = 64;
    private static final int TALL_STALAGMITE_SEDIMENT_STONE_TRIES = 32;
    private static final int TALL_STALAGMITE_LAVASTONE_TRIES = 32;
    private static final int TALL_STALAGMITE_PACKED_ICE_TRIES = 32;
    private static final int STALACTITE_STONE_TRIES = 64;
    private static final int STALACTITE_ANDESITE_TRIES = 64;
    private static final int STALACTITE_DIORITE_TRIES = 64;
    private static final int STALACTITE_GRANITE_TRIES = 64;
    private static final int STALACTITE_TUFF_TRIES = 64;
    private static final int STALACTITE_DEEPSLATE_TRIES = 64;
    private static final int STALACTITE_SEDIMENT_STONE_TRIES = 32;
    private static final int STALACTITE_LAVASTONE_TRIES = 32;
    private static final int STALACTITE_PACKED_ICE_TRIES = 32;
    private static final int TALL_STALACTITE_STONE_TRIES = 64;
    private static final int TALL_STALACTITE_ANDESITE_TRIES = 64;
    private static final int TALL_STALACTITE_DIORITE_TRIES = 64;
    private static final int TALL_STALACTITE_GRANITE_TRIES = 64;
    private static final int TALL_STALACTITE_TUFF_TRIES = 64;
    private static final int TALL_STALACTITE_DEEPSLATE_TRIES = 64;
    private static final int TALL_STALACTITE_SEDIMENT_STONE_TRIES = 32;
    private static final int TALL_STALACTITE_LAVASTONE_TRIES = 32;
    private static final int TALL_STALACTITE_PACKED_ICE_TRIES = 32;
    private static final int STALAGMITE_COUNT = (Integer)ECaveConfig.COMMON.STALAGMITES.COUNT.get();
    private static final int STALACTITE_COUNT = (Integer)ECaveConfig.COMMON.STALACTITES.COUNT.get();
    private static final int SWEETSHROOM_TRIES = 96;
    private static final ImmutableList<Block> SWEETSHROOM_BLACKLIST = ImmutableList.of((Object)Blocks.f_50354_, (Object)((Block)ModBlocks.DIRTSTONE.get()), (Object)((Block)ModBlocks.MARLSTONE.get()));
    private static final int GOLDISHROOM_TRIES = 96;
    private static final ImmutableList<Block> GOLDISHROOM_BLACKLIST = ImmutableList.of((Object)Blocks.f_50354_, (Object)((Block)ModBlocks.DIRTSTONE.get()), (Object)((Block)ModBlocks.MARLSTONE.get()));
    private static final int SHINYSHROOM_TRIES = 48;
    private static final ImmutableList<Block> SHINYSHROOM_BLACKLIST = ImmutableList.of((Object)Blocks.f_50354_, (Object)((Block)ModBlocks.DIRTSTONE.get()), (Object)((Block)ModBlocks.MARLSTONE.get()));
    private static final int LUMISHROOM_TRIES = 48;
    private static final ImmutableList<Block> LUMISHROOM_BLACKLIST = ImmutableList.of((Object)Blocks.f_50354_, (Object)((Block)ModBlocks.DIRTSTONE.get()), (Object)((Block)ModBlocks.MARLSTONE.get()));
    private static final int FLUOSHROOM_TRIES = 96;
    private static final ImmutableList<Block> FLUOSHROOM_BLACKLIST = ImmutableList.of((Object)Blocks.f_50493_, (Object)((Block)ModBlocks.DIRTSTONE.get()));
    private static final int ROCKSHROOM_TRIES = 32;
    private static final ImmutableList<Block> ROCKSHROOM_BLACKLIST = ImmutableList.of((Object)Blocks.f_50354_, (Object)((Block)ModBlocks.DIRTSTONE.get()), (Object)((Block)ModBlocks.MARLSTONE.get()));
    private static final int DRY_MOSS_TRIES = 8;
    private static final int FIRE_MOSS_TRIES = 24;
    private static final ImmutableList<Block> FIRE_MOSS_WHITELIST = ImmutableList.of((Object)((Block)ModBlocks.LAVASTONE.get()));
    private static final int FROZEN_MOSS_TRIES = 32;
    private static final ImmutableList<Block> FROZEN_MOSS_WHITELIST = ImmutableList.of((Object)Blocks.f_50354_);
    private static final int HANGING_ROOTS_TRIES = 8;
    private static final int HUMID_MOSS_GROUND_TRIES = 8;
    private static final int HUMID_MOSS_CEILING_TRIES = 32;
    private static final ImmutableList<Block> HUMID_MOSS_CEILING_WHITELIST = ImmutableList.of((Object)((Block)ModBlocks.DIRTSTONE.get()), (Object)Blocks.f_50493_);
    private static final int CAVE_VINE_TRIES = 8;
    private static final Set<Biome.BiomeCategory> INVALID_BIOMES = ImmutableSet.of((Object)Biome.BiomeCategory.THEEND, (Object)Biome.BiomeCategory.NETHER);
    private static final Set<Biome.BiomeCategory> IN_HUMID = ImmutableSet.of((Object)Biome.BiomeCategory.JUNGLE, (Object)Biome.BiomeCategory.MUSHROOM, (Object)Biome.BiomeCategory.SWAMP);
    private static final Set<Biome.BiomeCategory> IN_DRY = ImmutableSet.of((Object)Biome.BiomeCategory.DESERT, (Object)Biome.BiomeCategory.MESA, (Object)Biome.BiomeCategory.SAVANNA);
    private static final Set<Biome.BiomeCategory> IN_COLD = ImmutableSet.of((Object)Biome.BiomeCategory.ICY, (Object)Biome.BiomeCategory.TAIGA);

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (!INVALID_BIOMES.contains(event.getCategory())) {
            if (IN_COLD.contains(event.getCategory())) {
                // empty if block
            }
            if (event.getCategory() == Biome.BiomeCategory.TAIGA) {
                // empty if block
            }
            if (event.getCategory() == Biome.BiomeCategory.JUNGLE) {
                // empty if block
            }
            if (event.getCategory() == Biome.BiomeCategory.SAVANNA) {
                // empty if block
            }
            if (((Boolean)ECaveConfig.COMMON.ORE_BROKEN_STONE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_BROKEN_STONE);
            }
            if (((Boolean)ECaveConfig.COMMON.ORE_BROKEN_DEEPSLATE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_BROKEN_DEEPSLATE);
            }
            if (((Boolean)ECaveConfig.COMMON.ORE_SEDIMENT_STONE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_SEDIMENT_STONE);
            }
            if (((Boolean)ECaveConfig.COMMON.ORE_LAVASTONE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_LAVASTONE);
            }
            if (IN_HUMID.contains(event.getCategory()) && ((Boolean)ECaveConfig.COMMON.ORE_DIRTSTONE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_DIRTSTONE);
            }
            if (IN_DRY.contains(event.getCategory()) && ((Boolean)ECaveConfig.COMMON.ORE_MARLSTONE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_MARLSTONE);
            }
            if (IN_COLD.contains(event.getCategory()) && ((Boolean)ECaveConfig.COMMON.ORE_PACKED_ICE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.ORE_PACKED_ICE);
            }
            if (((Boolean)ECaveConfig.COMMON.FLINT_PEBBLE.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.FLINT_PEBBLE);
                if (event.getCategory() == Biome.BiomeCategory.BEACH || event.getCategory() == Biome.BiomeCategory.RIVER) {
                    generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.FLINT_PEBBLE_SURFACE);
                }
            }
            if (((Boolean)ECaveConfig.COMMON.PEBBLES.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STONE_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.ANDESITE_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.DIORITE_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.GRANITE_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TUFF_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.DEEPSLATE_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SEDIMENT_STONE_PEBBLE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.LAVASTONE_PEBBLE);
            }
            if (((Boolean)ECaveConfig.COMMON.ROCKPILES.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_STONE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_ANDESITE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_DIORITE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_GRANITE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_TUFF_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_DEEPSLATE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_SEDIMENT_STONE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.SMALL_LAVASTONE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_STONE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_ANDESITE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_DIORITE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_GRANITE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_TUFF_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_DEEPSLATE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_SEDIMENT_STONE_PILE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.BIG_LAVASTONE_PILE);
            }
            if (((Boolean)ECaveConfig.COMMON.STALAGMITES.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_ANDESITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_ANDESITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_DIORITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_DIORITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_GRANITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_GRANITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_TUFF);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_TUFF);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_DEEPSLATE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_DEEPSLATE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_SEDIMENT_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_SEDIMENT_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_LAVASTONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_LAVASTONE);
                if (IN_COLD.contains(event.getCategory())) {
                    generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALAGMITE_PACKED_ICE);
                    generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALAGMITE_PACKED_ICE);
                }
            }
            if (((Boolean)ECaveConfig.COMMON.STALACTITES.ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_ANDESITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_ANDESITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_DIORITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_DIORITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_GRANITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_GRANITE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_TUFF);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_TUFF);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_DEEPSLATE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_DEEPSLATE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_SEDIMENT_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_SEDIMENT_STONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_LAVASTONE);
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_LAVASTONE);
                if (IN_COLD.contains(event.getCategory())) {
                    generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.STALACTITE_PACKED_ICE);
                    generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, Placements.TALL_STALACTITE_PACKED_ICE);
                }
            }
            if (((Boolean)ECaveConfig.COMMON.MUSHROOMS_ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.SWEETSHROOM);
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.GOLDISHROOM);
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.SHINYSHROOM);
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.LUMISHROOM);
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.ROCKSHROOM);
                if (IN_HUMID.contains(event.getCategory())) {
                    generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.FLUOSHROOM);
                }
            }
            if (((Boolean)ECaveConfig.COMMON.MOSSES_ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.DRY_MOSS);
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.FIRE_MOSS);
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HANGING_ROOTS);
                if (IN_HUMID.contains(event.getCategory())) {
                    generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HUMID_MOSS_GROUND);
                    generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HUMID_MOSS_CEILING);
                }
                if (IN_COLD.contains(event.getCategory())) {
                    generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.FROZEN_MOSS);
                }
            }
            if (((Boolean)ECaveConfig.COMMON.VINES_ENABLED.get()).booleanValue()) {
                generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.CAVE_VINE);
            }
        }
    }

    public static void register() {
    }

    private static class Placements {
        private static final Holder<PlacedFeature> ORE_BROKEN_STONE = Placements.ore("ore_broken_stone", Configured.ORE_BROKEN_STONE, ECaveConfig.COMMON.ORE_BROKEN_STONE, VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158935_((int)16));
        private static final Holder<PlacedFeature> ORE_BROKEN_DEEPSLATE = Placements.ore("ore_broken_deepslate", Configured.ORE_BROKEN_DEEPSLATE, ECaveConfig.COMMON.ORE_BROKEN_DEEPSLATE, VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)0));
        private static final Holder<PlacedFeature> ORE_SEDIMENT_STONE = Placements.ore("ore_sediment_stone", Configured.ORE_SEDIMENT_STONE, ECaveConfig.COMMON.ORE_SEDIMENT_STONE, VerticalAnchor.m_158922_((int)16), VerticalAnchor.m_158935_((int)16));
        private static final Holder<PlacedFeature> ORE_LAVASTONE = Placements.ore("ore_lavastone", Configured.ORE_LAVASTONE, ECaveConfig.COMMON.ORE_LAVASTONE, VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)0));
        private static final Holder<PlacedFeature> ORE_DIRTSTONE = Placements.ore("ore_dirtstone", Configured.ORE_DIRTSTONE, ECaveConfig.COMMON.ORE_DIRTSTONE, VerticalAnchor.m_158922_((int)16), VerticalAnchor.m_158935_((int)16));
        private static final Holder<PlacedFeature> ORE_MARLSTONE = Placements.ore("ore_marlstone", Configured.ORE_MARLSTONE, ECaveConfig.COMMON.ORE_MARLSTONE, VerticalAnchor.m_158922_((int)16), VerticalAnchor.m_158935_((int)16));
        private static final Holder<PlacedFeature> ORE_PACKED_ICE = Placements.ore("ore_packed_ice", Configured.ORE_PACKED_ICE, ECaveConfig.COMMON.ORE_PACKED_ICE, VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158935_((int)16));
        private static final Holder<PlacedFeature> FLINT_PEBBLE = Placements.underground("flint_pebble", Configured.FLINT_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> FLINT_PEBBLE_SURFACE = Placements.surface("flint_pebble_surface", Configured.FLINT_PEBBLE_SURFACE, SURFACE_PEBBLE_COUNT);
        private static final Holder<PlacedFeature> STONE_PEBBLE = Placements.underground("stone_pebble", Configured.STONE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> ANDESITE_PEBBLE = Placements.underground("andesite_pebble", Configured.ANDESITE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> DIORITE_PEBBLE = Placements.underground("diorite_pebble", Configured.DIORITE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> GRANITE_PEBBLE = Placements.underground("granite_pebble", Configured.GRANITE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> TUFF_PEBBLE = Placements.underground("tuff_pebble", Configured.TUFF_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> DEEPSLATE_PEBBLE = Placements.underground("deepslate_pebble", Configured.DEEPSLATE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> SEDIMENT_STONE_PEBBLE = Placements.underground("sediment_stone_pebble", Configured.SEDIMENT_STONE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> LAVASTONE_PEBBLE = Placements.underground("lavastone_pebble", Configured.LAVASTONE_PEBBLE, PEBBLE_COUNT);
        private static final Holder<PlacedFeature> SMALL_STONE_PILE = Placements.underground("small_stone_pile", Configured.SMALL_STONE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_ANDESITE_PILE = Placements.underground("small_andesite_pile", Configured.SMALL_ANDESITE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_DIORITE_PILE = Placements.underground("small_diorite_pile", Configured.SMALL_DIORITE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_GRANITE_PILE = Placements.underground("small_granite_pile", Configured.SMALL_GRANITE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_TUFF_PILE = Placements.underground("small_tuff_pile", Configured.SMALL_TUFF_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_DEEPSLATE_PILE = Placements.underground("small_deepslate_pile", Configured.SMALL_DEEPSLATE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_SEDIMENT_STONE_PILE = Placements.underground("small_sediment_stone_pile", Configured.SMALL_SEDIMENT_STONE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> SMALL_LAVASTONE_PILE = Placements.underground("small_lavastone_pile", Configured.SMALL_LAVASTONE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_STONE_PILE = Placements.underground("big_stone_pile", Configured.BIG_STONE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_ANDESITE_PILE = Placements.underground("big_andesite_pile", Configured.BIG_ANDESITE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_DIORITE_PILE = Placements.underground("big_diorite_pile", Configured.BIG_DIORITE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_GRANITE_PILE = Placements.underground("big_granite_pile", Configured.BIG_GRANITE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_TUFF_PILE = Placements.underground("big_tuff_pile", Configured.BIG_TUFF_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_DEEPSLATE_PILE = Placements.underground("big_deepslate_pile", Configured.BIG_DEEPSLATE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_SEDIMENT_STONE_PILE = Placements.underground("big_sediment_stone_pile", Configured.BIG_SEDIMENT_STONE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> BIG_LAVASTONE_PILE = Placements.underground("big_lavastone_pile", Configured.BIG_LAVASTONE_PILE, ROCKPILE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_STONE = Placements.underground("stalagmite_stone", Configured.STALAGMITE_STONE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_ANDESITE = Placements.underground("stalagmite_andesite", Configured.STALAGMITE_ANDESITE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_DIORITE = Placements.underground("stalagmite_diorite", Configured.STALAGMITE_DIORITE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_GRANITE = Placements.underground("stalagmite_granite", Configured.STALAGMITE_GRANITE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_TUFF = Placements.underground("stalagmite_tuff", Configured.STALAGMITE_TUFF, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_DEEPSLATE = Placements.underground("stalagmite_deepslate", Configured.STALAGMITE_DEEPSLATE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_SEDIMENT_STONE = Placements.underground("stalagmite_sediment_stone", Configured.STALAGMITE_SEDIMENT_STONE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_LAVASTONE = Placements.underground("stalagmite_lavastone", Configured.STALAGMITE_LAVASTONE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALAGMITE_PACKED_ICE = Placements.underground("stalagmite_packed_ice", Configured.STALAGMITE_PACKED_ICE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_STONE = Placements.underground("tall_stalagmite_stone", Configured.TALL_STALAGMITE_STONE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_ANDESITE = Placements.underground("tall_stalagmite_andesite", Configured.TALL_STALAGMITE_ANDESITE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_DIORITE = Placements.underground("tall_stalagmite_diorite", Configured.TALL_STALAGMITE_DIORITE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_GRANITE = Placements.underground("tall_stalagmite_granite", Configured.TALL_STALAGMITE_GRANITE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_TUFF = Placements.underground("tall_stalagmite_tuff", Configured.TALL_STALAGMITE_TUFF, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_DEEPSLATE = Placements.underground("tall_stalagmite_deepslate", Configured.TALL_STALAGMITE_DEEPSLATE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_SEDIMENT_STONE = Placements.underground("tall_stalagmite_sediment_stone", Configured.TALL_STALAGMITE_SEDIMENT_STONE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_LAVASTONE = Placements.underground("tall_stalagmite_lavastone", Configured.TALL_STALAGMITE_LAVASTONE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALAGMITE_PACKED_ICE = Placements.underground("tall_stalagmite_packed_ice", Configured.TALL_STALAGMITE_PACKED_ICE, STALAGMITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_STONE = Placements.underground("stalactite_stone", Configured.STALACTITE_STONE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_ANDESITE = Placements.underground("stalactite_andesite", Configured.STALACTITE_ANDESITE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_DIORITE = Placements.underground("stalactite_diorite", Configured.STALACTITE_DIORITE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_GRANITE = Placements.underground("stalactite_granite", Configured.STALACTITE_GRANITE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_TUFF = Placements.underground("stalactite_tuff", Configured.STALACTITE_TUFF, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_DEEPSLATE = Placements.underground("stalactite_deepslate", Configured.STALACTITE_DEEPSLATE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_SEDIMENT_STONE = Placements.underground("stalactite_sediment_stone", Configured.STALACTITE_SEDIMENT_STONE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_LAVASTONE = Placements.underground("stalactite_lavastone", Configured.STALACTITE_LAVASTONE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> STALACTITE_PACKED_ICE = Placements.underground("stalactite_packed_ice", Configured.STALACTITE_PACKED_ICE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_STONE = Placements.underground("tall_stalactite_stone", Configured.TALL_STALACTITE_STONE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_ANDESITE = Placements.underground("tall_stalactite_andesite", Configured.TALL_STALACTITE_ANDESITE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_DIORITE = Placements.underground("tall_stalactite_diorite", Configured.TALL_STALACTITE_DIORITE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_GRANITE = Placements.underground("tall_stalactite_granite", Configured.TALL_STALACTITE_GRANITE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_TUFF = Placements.underground("tall_stalactite_tuff", Configured.TALL_STALACTITE_TUFF, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_DEEPSLATE = Placements.underground("tall_stalactite_deepslate", Configured.TALL_STALACTITE_DEEPSLATE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_SEDIMENT_STONE = Placements.underground("tall_stalactite_sediment_stone", Configured.TALL_STALACTITE_SEDIMENT_STONE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_LAVASTONE = Placements.underground("tall_stalactite_lavastone", Configured.TALL_STALACTITE_LAVASTONE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> TALL_STALACTITE_PACKED_ICE = Placements.underground("tall_stalactite_packed_ice", Configured.TALL_STALACTITE_PACKED_ICE, STALACTITE_COUNT);
        private static final Holder<PlacedFeature> SWEETSHROOM = Placements.underground("sweetshroom", Configured.SWEETSHROOM, (Integer)ECaveConfig.COMMON.SWEETSHROOM_COUNT.get());
        private static final Holder<PlacedFeature> GOLDISHROOM = Placements.underground("goldishroom", Configured.GOLDISHROOM, (Integer)ECaveConfig.COMMON.GOLDISHROOM_COUNT.get());
        private static final Holder<PlacedFeature> SHINYSHROOM = Placements.underground("shinyshroom", Configured.SHINYSHROOM, (Integer)ECaveConfig.COMMON.SHINYSHROOM_COUNT.get());
        private static final Holder<PlacedFeature> LUMISHROOM = Placements.underground("lumishroom", Configured.LUMISHROOM, (Integer)ECaveConfig.COMMON.LUMISHROOM_COUNT.get());
        private static final Holder<PlacedFeature> FLUOSHROOM = Placements.underground("fluoshroom", Configured.FLUOSHROOM, (Integer)ECaveConfig.COMMON.FLUOSHROOM_COUNT.get());
        private static final Holder<PlacedFeature> ROCKSHROOM = Placements.underground("rockshroom", Configured.ROCKSHROOM, (Integer)ECaveConfig.COMMON.ROCKSHROOM_COUNT.get());
        private static final Holder<PlacedFeature> DRY_MOSS = Placements.underground("dry_moss", Configured.DRY_MOSS, (Integer)ECaveConfig.COMMON.DRY_MOSS_COUNT.get());
        private static final Holder<PlacedFeature> FIRE_MOSS = Placements.underground("fire_moss", Configured.FIRE_MOSS, (Integer)ECaveConfig.COMMON.FIRE_MOSS_COUNT.get());
        private static final Holder<PlacedFeature> FROZEN_MOSS = Placements.underground("frozen_moss", Configured.FROZEN_MOSS, (Integer)ECaveConfig.COMMON.FROZEN_MOSS_COUNT.get());
        private static final Holder<PlacedFeature> HANGING_ROOTS = Placements.underground("hanging_roots", Configured.HANGING_ROOTS, (Integer)ECaveConfig.COMMON.HANGING_ROOTS_COUNT.get());
        private static final Holder<PlacedFeature> HUMID_MOSS_GROUND = Placements.underground("humid_moss_ground", Configured.HUMID_MOSS_GROUND, (Integer)ECaveConfig.COMMON.HUMID_MOSS_COUNT.get());
        private static final Holder<PlacedFeature> HUMID_MOSS_CEILING = Placements.underground("humid_moss_ceiling", Configured.HUMID_MOSS_CEILING, (Integer)ECaveConfig.COMMON.HUMID_MOSS_COUNT.get());
        private static final Holder<PlacedFeature> CAVE_VINE = Placements.underground("cave_vine", Configured.CAVE_VINE, (Integer)ECaveConfig.COMMON.CAVE_VINE_COUNT.get());

        private Placements() {
        }

        private static Holder<PlacedFeature> ore(String name, Holder<ConfiguredFeature<OreConfiguration, ?>> configured, OreFeatureConfig config, VerticalAnchor bottom, VerticalAnchor top) {
            return PlacementUtils.m_206513_((String)("expcaves:" + name), configured, (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)((Integer)config.COUNT.get())), HeightRangePlacement.m_191680_((VerticalAnchor)bottom, (VerticalAnchor)top), BiomeFilter.m_191561_()});
        }

        private static Holder<PlacedFeature> surface(String name, Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> feature, int count) {
            return PlacementUtils.m_206513_((String)("expcaves:" + name), feature, (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        }

        private static Holder<PlacedFeature> underground(String name, Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> feature, int count) {
            return PlacementUtils.m_206513_((String)("expcaves:" + name), feature, (PlacementModifier[])new PlacementModifier[]{CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), PlacementUtils.f_195360_, SurfaceRelativeThresholdFilter.m_191930_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-13), BiomeFilter.m_191561_()});
        }
    }

    private static class Configured {
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_BROKEN_STONE = Configured.ore("ore_broken_stone", OreFeatures.f_195072_, ModBlocks.BROKEN_STONE.getDefaultState(), ECaveConfig.COMMON.ORE_BROKEN_STONE);
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_BROKEN_DEEPSLATE = Configured.ore("ore_broken_deepslate", OreFeatures.f_195073_, ModBlocks.BROKEN_DEEPSLATE.getDefaultState(), ECaveConfig.COMMON.ORE_BROKEN_DEEPSLATE);
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_SEDIMENT_STONE = Configured.ore("ore_sediment_stone", OreFeatures.f_195071_, ModBlocks.SEDIMENT_STONE.getDefaultState(), ECaveConfig.COMMON.ORE_SEDIMENT_STONE);
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_LAVASTONE = Configured.ore("ore_lavastone", OreFeatures.f_195071_, ModBlocks.LAVASTONE.getDefaultState(), ECaveConfig.COMMON.ORE_LAVASTONE);
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_DIRTSTONE = Configured.ore("ore_dirtstone", OreFeatures.f_195071_, ModBlocks.DIRTSTONE.getDefaultState(), ECaveConfig.COMMON.ORE_DIRTSTONE);
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_MARLSTONE = Configured.ore("ore_marlstone", OreFeatures.f_195071_, ModBlocks.MARLSTONE.getDefaultState(), ECaveConfig.COMMON.ORE_MARLSTONE);
        private static final Holder<ConfiguredFeature<OreConfiguration, ?>> ORE_PACKED_ICE = Configured.ore("ore_packed_ice", OreFeatures.f_195071_, Blocks.f_50354_.m_49966_(), ECaveConfig.COMMON.ORE_PACKED_ICE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLINT_PEBBLE = Configured.floorRandomPatch("flint_pebble", ModBlocks.PEBBLE_FLINT.getDefaultState(), 8, 8, 8);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLINT_PEBBLE_SURFACE = Configured.floorRandomPatch("flint_pebble_surface", ModBlocks.PEBBLE_FLINT.getDefaultState(), 8, 16, 16);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STONE_PEBBLE = Configured.floorRandomPatchWhitelist("stone_pebble", ((RockpileBlock)((Object)ModBlocks.STONE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_STONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ANDESITE_PEBBLE = Configured.floorRandomPatchWhitelist("andesite_pebble", ((RockpileBlock)((Object)ModBlocks.ANDESITE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_ANDESITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> DIORITE_PEBBLE = Configured.floorRandomPatchWhitelist("diorite_pebble", ((RockpileBlock)((Object)ModBlocks.DIORITE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_DIORITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> GRANITE_PEBBLE = Configured.floorRandomPatchWhitelist("granite_pebble", ((RockpileBlock)((Object)ModBlocks.GRANITE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_GRANITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TUFF_PEBBLE = Configured.floorRandomPatchWhitelist("tuff_pebble", ((RockpileBlock)((Object)ModBlocks.TUFF_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_TUFF);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> DEEPSLATE_PEBBLE = Configured.floorRandomPatchWhitelist("deepslate_pebble", ((RockpileBlock)((Object)ModBlocks.DEEPSLATE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_DEEPSLATE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SEDIMENT_STONE_PEBBLE = Configured.floorRandomPatchWhitelist("sediment_stone_pebble", ((RockpileBlock)((Object)ModBlocks.SEDIMENT_STONE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_SEDIMENT_STONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> LAVASTONE_PEBBLE = Configured.floorRandomPatchWhitelist("lavastone_pebble", ((RockpileBlock)((Object)ModBlocks.LAVASTONE_PEBBLES.get())).getPebbleState(), 32, 16, 16, WHITELIST_LAVASTONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_STONE_PILE = Configured.floorRandomPatchWhitelist("small_stone_pile", ((RockpileBlock)((Object)ModBlocks.STONE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_STONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_ANDESITE_PILE = Configured.floorRandomPatchWhitelist("small_andesite_pile", ((RockpileBlock)((Object)ModBlocks.ANDESITE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_ANDESITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_DIORITE_PILE = Configured.floorRandomPatchWhitelist("small_diorite_pile", ((RockpileBlock)((Object)ModBlocks.DIORITE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_DIORITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_GRANITE_PILE = Configured.floorRandomPatchWhitelist("small_granite_pile", ((RockpileBlock)((Object)ModBlocks.GRANITE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_GRANITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_TUFF_PILE = Configured.floorRandomPatchWhitelist("small_tuff_pile", ((RockpileBlock)((Object)ModBlocks.TUFF_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_TUFF);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_DEEPSLATE_PILE = Configured.floorRandomPatchWhitelist("small_deepslate_pile", ((RockpileBlock)((Object)ModBlocks.DEEPSLATE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_DEEPSLATE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_SEDIMENT_STONE_PILE = Configured.floorRandomPatchWhitelist("small_sediment_stone_pile", ((RockpileBlock)((Object)ModBlocks.SEDIMENT_STONE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_SEDIMENT_STONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SMALL_LAVASTONE_PILE = Configured.floorRandomPatchWhitelist("small_lavastone_pile", ((RockpileBlock)((Object)ModBlocks.LAVASTONE_PEBBLES.get())).getSmallPileState(), 32, 16, 16, WHITELIST_LAVASTONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_STONE_PILE = Configured.floorRandomPatchWhitelist("big_stone_pile", ((RockpileBlock)((Object)ModBlocks.STONE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_STONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_ANDESITE_PILE = Configured.floorRandomPatchWhitelist("big_andesite_pile", ((RockpileBlock)((Object)ModBlocks.ANDESITE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_ANDESITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_DIORITE_PILE = Configured.floorRandomPatchWhitelist("big_diorite_pile", ((RockpileBlock)((Object)ModBlocks.DIORITE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_DIORITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_GRANITE_PILE = Configured.floorRandomPatchWhitelist("big_granite_pile", ((RockpileBlock)((Object)ModBlocks.GRANITE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_GRANITE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_TUFF_PILE = Configured.floorRandomPatchWhitelist("big_tuff_pile", ((RockpileBlock)((Object)ModBlocks.TUFF_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_TUFF);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_DEEPSLATE_PILE = Configured.floorRandomPatchWhitelist("big_deepslate_pile", ((RockpileBlock)((Object)ModBlocks.DEEPSLATE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_DEEPSLATE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_SEDIMENT_STONE_PILE = Configured.floorRandomPatchWhitelist("big_sediment_stone_pile", ((RockpileBlock)((Object)ModBlocks.SEDIMENT_STONE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_SEDIMENT_STONE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> BIG_LAVASTONE_PILE = Configured.floorRandomPatchWhitelist("big_lavastone_pile", ((RockpileBlock)((Object)ModBlocks.LAVASTONE_PEBBLES.get())).getBigPileState(), 32, 16, 16, WHITELIST_LAVASTONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_STONE = Configured.floorRandomPatchWhitelist("stalagmite_stone", ModBlocks.STONE_SPELOTHEMS.stalagmite.getDefaultState(), 64, 8, 8, WHITELIST_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_ANDESITE = Configured.floorRandomPatchWhitelist("stalagmite_andesite", ModBlocks.ANDESITE_SPELOTHEMS.stalagmite.getDefaultState(), 64, 8, 8, WHITELIST_ANDESITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_DIORITE = Configured.floorRandomPatchWhitelist("stalagmite_diorite", ModBlocks.DIORITE_SPELOTHEMS.stalagmite.getDefaultState(), 64, 8, 8, WHITELIST_DIORITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_GRANITE = Configured.floorRandomPatchWhitelist("stalagmite_granite", ModBlocks.GRANITE_SPELOTHEMS.stalagmite.getDefaultState(), 64, 8, 8, WHITELIST_GRANITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_TUFF = Configured.floorRandomPatchWhitelist("stalagmite_tuff", ModBlocks.TUFF_SPELOTHEMS.stalagmite.getDefaultState(), 64, 8, 8, WHITELIST_TUFF);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_DEEPSLATE = Configured.floorRandomPatchWhitelist("stalagmite_deepslate", ModBlocks.DEEPSLATE_SPELOTHEMS.stalagmite.getDefaultState(), 64, 8, 8, WHITELIST_DEEPSLATE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_SEDIMENT_STONE = Configured.floorRandomPatchWhitelist("stalagmite_sediment_stone", ModBlocks.SEDIMENT_STONE_SPELOTHEMS.stalagmite.getDefaultState(), 32, 8, 8, WHITELIST_SEDIMENT_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_LAVASTONE = Configured.floorRandomPatchWhitelist("stalagmite_lavastone", ModBlocks.LAVASTONE_SPELOTHEMS.stalagmite.getDefaultState(), 32, 8, 8, WHITELIST_LAVASTONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALAGMITE_PACKED_ICE = Configured.floorRandomPatchWhitelist("stalagmite_packed_ice", ModBlocks.PACKED_ICE_SPELOTHEMS.stalagmite.getDefaultState(), 32, 8, 8, WHITELIST_PACKED_ICE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_STONE = Configured.floorRandomPatchWhitelist("tall_stalagmite_stone", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.STONE_SPELOTHEMS.tallStalagmite.getDefaultState(), 64, 8, 8, WHITELIST_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_ANDESITE = Configured.floorRandomPatchWhitelist("tall_stalagmite_andesite", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.ANDESITE_SPELOTHEMS.tallStalagmite.getDefaultState(), 64, 8, 8, WHITELIST_ANDESITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_DIORITE = Configured.floorRandomPatchWhitelist("tall_stalagmite_diorite", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.DIORITE_SPELOTHEMS.tallStalagmite.getDefaultState(), 64, 8, 8, WHITELIST_DIORITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_GRANITE = Configured.floorRandomPatchWhitelist("tall_stalagmite_granite", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.GRANITE_SPELOTHEMS.tallStalagmite.getDefaultState(), 64, 8, 8, WHITELIST_GRANITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_TUFF = Configured.floorRandomPatchWhitelist("tall_stalagmite_tuff", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.TUFF_SPELOTHEMS.tallStalagmite.getDefaultState(), 64, 8, 8, WHITELIST_TUFF);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_DEEPSLATE = Configured.floorRandomPatchWhitelist("tall_stalagmite_deepslate", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.DEEPSLATE_SPELOTHEMS.tallStalagmite.getDefaultState(), 64, 8, 8, WHITELIST_DEEPSLATE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_SEDIMENT_STONE = Configured.floorRandomPatchWhitelist("tall_stalagmite_sediment_stone", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.SEDIMENT_STONE_SPELOTHEMS.tallStalagmite.getDefaultState(), 32, 8, 8, WHITELIST_SEDIMENT_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_LAVASTONE = Configured.floorRandomPatchWhitelist("tall_stalagmite_lavastone", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.LAVASTONE_SPELOTHEMS.tallStalagmite.getDefaultState(), 32, 8, 8, WHITELIST_LAVASTONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALAGMITE_PACKED_ICE = Configured.floorRandomPatchWhitelist("tall_stalagmite_packed_ice", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.PACKED_ICE_SPELOTHEMS.tallStalagmite.getDefaultState(), 32, 8, 8, WHITELIST_PACKED_ICE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_STONE = Configured.ceilingRandomPatchWhitelist("stalactite_stone", ModBlocks.STONE_SPELOTHEMS.stalactite.getDefaultState(), 64, 8, 8, WHITELIST_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_ANDESITE = Configured.ceilingRandomPatchWhitelist("stalactite_andesite", ModBlocks.ANDESITE_SPELOTHEMS.stalactite.getDefaultState(), 64, 8, 8, WHITELIST_ANDESITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_DIORITE = Configured.ceilingRandomPatchWhitelist("stalactite_diorite", ModBlocks.DIORITE_SPELOTHEMS.stalactite.getDefaultState(), 64, 8, 8, WHITELIST_DIORITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_GRANITE = Configured.ceilingRandomPatchWhitelist("stalactite_granite", ModBlocks.GRANITE_SPELOTHEMS.stalactite.getDefaultState(), 64, 8, 8, WHITELIST_GRANITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_TUFF = Configured.ceilingRandomPatchWhitelist("stalactite_tuff", ModBlocks.TUFF_SPELOTHEMS.stalactite.getDefaultState(), 64, 8, 8, WHITELIST_TUFF);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_DEEPSLATE = Configured.ceilingRandomPatchWhitelist("stalactite_deepslate", ModBlocks.DEEPSLATE_SPELOTHEMS.stalactite.getDefaultState(), 64, 8, 8, WHITELIST_DEEPSLATE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_SEDIMENT_STONE = Configured.ceilingRandomPatchWhitelist("stalactite_sediment_stone", ModBlocks.SEDIMENT_STONE_SPELOTHEMS.stalactite.getDefaultState(), 32, 8, 8, WHITELIST_SEDIMENT_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_LAVASTONE = Configured.ceilingRandomPatchWhitelist("stalactite_lavastone", ModBlocks.LAVASTONE_SPELOTHEMS.stalactite.getDefaultState(), 32, 8, 8, WHITELIST_LAVASTONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> STALACTITE_PACKED_ICE = Configured.ceilingRandomPatchWhitelist("stalactite_packed_ice", ModBlocks.PACKED_ICE_SPELOTHEMS.stalactite.getDefaultState(), 32, 8, 8, WHITELIST_PACKED_ICE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_STONE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_stone", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.STONE_SPELOTHEMS.tallStalactite.getDefaultState(), 64, 8, 8, WHITELIST_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_ANDESITE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_andesite", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.ANDESITE_SPELOTHEMS.tallStalactite.getDefaultState(), 64, 8, 8, WHITELIST_ANDESITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_DIORITE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_diorite", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.DIORITE_SPELOTHEMS.tallStalactite.getDefaultState(), 64, 8, 8, WHITELIST_DIORITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_GRANITE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_granite", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.GRANITE_SPELOTHEMS.tallStalactite.getDefaultState(), 64, 8, 8, WHITELIST_GRANITE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_TUFF = Configured.ceilingRandomPatchWhitelist("tall_stalactite_tuff", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.TUFF_SPELOTHEMS.tallStalactite.getDefaultState(), 64, 8, 8, WHITELIST_TUFF);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_DEEPSLATE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_deepslate", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.DEEPSLATE_SPELOTHEMS.tallStalactite.getDefaultState(), 64, 8, 8, WHITELIST_DEEPSLATE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_SEDIMENT_STONE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_sediment_stone", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.SEDIMENT_STONE_SPELOTHEMS.tallStalactite.getDefaultState(), 32, 8, 8, WHITELIST_SEDIMENT_STONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_LAVASTONE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_lavastone", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.LAVASTONE_SPELOTHEMS.tallStalactite.getDefaultState(), 32, 8, 8, WHITELIST_LAVASTONE);
        private static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TALL_STALACTITE_PACKED_ICE = Configured.ceilingRandomPatchWhitelist("tall_stalactite_packed_ice", (Feature<SimpleBlockConfiguration>)((Feature)ModFeatures.TALL_SPELOTHEM.get()), ModBlocks.PACKED_ICE_SPELOTHEMS.tallStalactite.getDefaultState(), 32, 8, 8, WHITELIST_PACKED_ICE);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SWEETSHROOM = Configured.floorRandomPatchBlacklist("sweetshroom", ModBlocks.SWEETSHROOM.getDefaultState(), 96, 8, 4, SWEETSHROOM_BLACKLIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> GOLDISHROOM = Configured.floorRandomPatchBlacklist("goldishroom", ModBlocks.GOLDISHROOM.getDefaultState(), 96, 8, 4, GOLDISHROOM_BLACKLIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> SHINYSHROOM = Configured.floorRandomPatchBlacklist("shinyshroom", ModBlocks.SHINYSHROOM.getDefaultState(), 48, 8, 4, SHINYSHROOM_BLACKLIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> LUMISHROOM = Configured.floorRandomPatchBlacklist("lumishroom", ModBlocks.LUMISHROOM.getDefaultState(), 48, 8, 4, LUMISHROOM_BLACKLIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLUOSHROOM = Configured.floorRandomPatchBlacklist("fluoshroom", ModBlocks.FLUOSHROOM.getDefaultState(), 96, 8, 4, FLUOSHROOM_BLACKLIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ROCKSHROOM = Configured.floorRandomPatchBlacklist("rockshroom", ModBlocks.ROCKSHROOM.getDefaultState(), 32, 8, 4, ROCKSHROOM_BLACKLIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> DRY_MOSS = Configured.floorRandomPatch("dry_moss", ModBlocks.MOSS_DRY.getDefaultState(), 8, 8, 4);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FIRE_MOSS = Configured.floorRandomPatchWhitelist("fire_moss", ModBlocks.MOSS_FIRE.getDefaultState(), 24, 8, 4, FIRE_MOSS_WHITELIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FROZEN_MOSS = Configured.floorRandomPatchWhitelist("frozen_moss", ModBlocks.MOSS_FROZEN.getDefaultState(), 32, 8, 4, FROZEN_MOSS_WHITELIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> HANGING_ROOTS = Configured.ceilingRandomPatch("hanging_roots", ModBlocks.MOSS_HANGING_ROOTS.getDefaultState(), 8, 8, 4);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> HUMID_MOSS_GROUND = Configured.floorRandomPatchWhitelist("humid_moss_ground", ModBlocks.MOSS_HUMID_GROUND.getDefaultState(), 8, 8, 4, HUMID_MOSS_CEILING_WHITELIST);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> HUMID_MOSS_CEILING = Configured.ceilingRandomPatch("humid_moss_ceiling", ModBlocks.MOSS_HUMID_CEILING.getDefaultState(), 32, 8, 4);
        public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> CAVE_VINE = Configured.ceilingRandomPatch("cave_vine", ModBlocks.CAVE_VINE_END.getDefaultState(), 8, 8, 4);

        private Configured() {
        }

        private static Holder<ConfiguredFeature<OreConfiguration, ?>> ore(String name, RuleTest test, BlockState state, OreFeatureConfig config) {
            return FeatureUtils.m_206488_((String)("expcaves:" + name), (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(test, state, ((Integer)config.VEIN_SIZE.get()).intValue()));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> floorRandomPatchBlacklist(String name, BlockState state, int tries, int xzspread, int yspread, List<Block> blacklist) {
            return Configured.floorRandomPatchBlacklist(name, (Feature<SimpleBlockConfiguration>)Feature.f_65741_, state, tries, xzspread, yspread, blacklist);
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> floorRandomPatchBlacklist(String name, Feature<SimpleBlockConfiguration> feature, BlockState state, int tries, int xzspread, int yspread, List<Block> blacklist) {
            return Configured.randomPatch(name, new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206498_(feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190414_(blacklist, (Vec3i)new BlockPos(0, -1, 0)))))));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> floorRandomPatchWhitelist(String name, BlockState state, int tries, int xzspread, int yspread, List<Block> whitelist) {
            return Configured.floorRandomPatchWhitelist(name, (Feature<SimpleBlockConfiguration>)Feature.f_65741_, state, tries, xzspread, yspread, whitelist);
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> floorRandomPatchWhitelist(String name, Feature<SimpleBlockConfiguration> feature, BlockState state, int tries, int xzspread, int yspread, List<Block> whitelist) {
            return Configured.randomPatch(name, new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206498_(feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_190414_(whitelist, (Vec3i)new BlockPos(0, -1, 0))))));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> floorRandomPatch(String name, BlockState state, int tries, int xzspread, int yspread) {
            return Configured.floorRandomPatch(name, (Feature<SimpleBlockConfiguration>)Feature.f_65741_, state, tries, xzspread, yspread);
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> floorRandomPatch(String name, Feature<SimpleBlockConfiguration> feature, BlockState state, int tries, int xzspread, int yspread) {
            return Configured.randomPatch(name, new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206502_(feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_190423_((Vec3i)new BlockPos(0, -1, 0))))})));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ceilingRandomPatchBlacklist(String name, BlockState state, int tries, int xzspread, int yspread, List<Block> blacklist) {
            return Configured.ceilingRandomPatchBlacklist(name, (Feature<SimpleBlockConfiguration>)Feature.f_65741_, state, tries, xzspread, yspread, blacklist);
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ceilingRandomPatchBlacklist(String name, Feature<SimpleBlockConfiguration> feature, BlockState state, int tries, int xzspread, int yspread, List<Block> blacklist) {
            return Configured.randomPatch(name, new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206498_(feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190414_(blacklist, (Vec3i)new BlockPos(0, 1, 0)))))));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ceilingRandomPatchWhitelist(String name, BlockState state, int tries, int xzspread, int yspread, List<Block> whitelist) {
            return Configured.ceilingRandomPatchWhitelist(name, (Feature<SimpleBlockConfiguration>)Feature.f_65741_, state, tries, xzspread, yspread, whitelist);
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ceilingRandomPatchWhitelist(String name, Feature<SimpleBlockConfiguration> feature, BlockState state, int tries, int xzspread, int yspread, List<Block> whitelist) {
            return Configured.randomPatch(name, new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206498_(feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_190414_(whitelist, (Vec3i)new BlockPos(0, 1, 0))))));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ceilingRandomPatch(String name, BlockState state, int tries, int xzspread, int yspread) {
            return Configured.ceilingRandomPatch(name, (Feature<SimpleBlockConfiguration>)Feature.f_65741_, state, tries, xzspread, yspread);
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> ceilingRandomPatch(String name, Feature<SimpleBlockConfiguration> feature, BlockState state, int tries, int xzspread, int yspread) {
            return Configured.randomPatch(name, new RandomPatchConfiguration(tries, xzspread, yspread, PlacementUtils.m_206502_(feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_190423_((Vec3i)new BlockPos(0, 1, 0))))})));
        }

        private static Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> randomPatch(String name, RandomPatchConfiguration config) {
            return FeatureUtils.m_206488_((String)("expcaves:" + name), (Feature)Feature.f_65763_, (FeatureConfiguration)config);
        }
    }
}

