/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.extendedcaves.repack.registrate.util;

import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonElement;
import dev.nerdthings.extendedcaves.repack.registrate.providers.RegistrateRecipeProvider;
import dev.nerdthings.extendedcaves.repack.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class DataIngredient
extends Ingredient {
    private final Ingredient parent;
    private final ResourceLocation id;
    private final Function<RegistrateRecipeProvider, InventoryChangeTrigger.TriggerInstance> criteriaFactory;

    private DataIngredient(Ingredient parent, ItemLike item) {
        super(Stream.empty());
        this.parent = parent;
        this.id = item.m_5456_().getRegistryName();
        this.criteriaFactory = prov -> RegistrateRecipeProvider.has(item);
    }

    private DataIngredient(Ingredient parent, TagKey<Item> tag) {
        super(Stream.empty());
        this.parent = parent;
        this.id = tag.f_203868_();
        this.criteriaFactory = prov -> RegistrateRecipeProvider.has(tag);
    }

    private DataIngredient(Ingredient parent, ResourceLocation id, ItemPredicate ... predicates) {
        super(Stream.empty());
        this.parent = parent;
        this.id = id;
        this.criteriaFactory = prov -> RegistrateRecipeProvider.inventoryTrigger(predicates);
    }

    public IIngredientSerializer<DataIngredient> getSerializer() {
        throw new UnsupportedOperationException("DataIngredient should only be used for data generation!");
    }

    public InventoryChangeTrigger.TriggerInstance getCritereon(RegistrateRecipeProvider prov) {
        return this.criteriaFactory.apply(prov);
    }

    @SafeVarargs
    public static <T extends ItemLike & IForgeRegistryEntry<?>> DataIngredient items(NonNullSupplier<? extends T> first, NonNullSupplier<? extends T> ... others) {
        return DataIngredient.items((ItemLike)((ItemLike)first.get()), (ItemLike[])((ItemLike[])Arrays.stream(others).map(Supplier::get).toArray(ItemLike[]::new)));
    }

    @SafeVarargs
    public static <T extends ItemLike & IForgeRegistryEntry<?>> DataIngredient items(T first, T ... others) {
        return DataIngredient.ingredient(Ingredient.m_43929_((ItemLike[])((ItemLike[])ObjectArrays.concat(first, (Object[])others))), first);
    }

    public static DataIngredient stacks(ItemStack first, ItemStack ... others) {
        return DataIngredient.ingredient(Ingredient.m_43927_((ItemStack[])((ItemStack[])ObjectArrays.concat((Object)first, (Object[])others))), (ItemLike)first.m_41720_());
    }

    public static DataIngredient tag(TagKey<Item> tag) {
        return DataIngredient.ingredient(Ingredient.m_204132_(tag), tag);
    }

    public static DataIngredient ingredient(Ingredient parent, ItemLike required) {
        return new DataIngredient(parent, required);
    }

    public static DataIngredient ingredient(Ingredient parent, TagKey<Item> required) {
        return new DataIngredient(parent, required);
    }

    public static DataIngredient ingredient(Ingredient parent, ResourceLocation id, ItemPredicate ... criteria) {
        return new DataIngredient(parent, id, criteria);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack[] m_43908_() {
        return this.parent.m_43908_();
    }

    public boolean test(ItemStack p_43914_) {
        return this.parent.test(p_43914_);
    }

    public IntList m_43931_() {
        return this.parent.m_43931_();
    }

    public JsonElement m_43942_() {
        return this.parent.m_43942_();
    }

    public boolean m_43947_() {
        return this.parent.m_43947_();
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    public Predicate<ItemStack> and(Predicate<? super ItemStack> other) {
        return this.parent.and(other);
    }

    public Predicate<ItemStack> negate() {
        return this.parent.negate();
    }

    public Predicate<ItemStack> or(Predicate<? super ItemStack> other) {
        return this.parent.or(other);
    }

    private static interface Excludes {
        public IIngredientSerializer<DataIngredient> getSerializer();

        public void toNetwork(FriendlyByteBuf var1);

        public boolean isVanilla();

        public boolean checkInvalidation();
    }
}

